/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.File;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.rrd.RrdRepository;

public class LatencyCollectionResource
implements CollectionResource {
    private final String m_serviceName;
    private final String m_ipAddress;

    public LatencyCollectionResource(String serviceName, String ipAddress) {
        this.m_serviceName = serviceName;
        this.m_ipAddress = ipAddress;
    }

    public String getInstance() {
        return this.m_ipAddress + "[" + this.m_serviceName + "]";
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public String getInterfaceLabel() {
        return this.m_serviceName;
    }

    public String getResourceTypeName() {
        return "if";
    }

    public boolean rescanNeeded() {
        return false;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public void visit(CollectionSetVisitor visitor) {
    }

    public String getOwnerName() {
        return this.m_ipAddress;
    }

    public File getResourceDir(RrdRepository repository) {
        return new File(repository.getRrdBaseDir(), this.m_ipAddress);
    }

    public String toString() {
        return this.m_serviceName + "@" + this.m_ipAddress;
    }

    public String getParent() {
        return this.m_ipAddress;
    }

    public TimeKeeper getTimeKeeper() {
        return null;
    }
}

