/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OspfGeneralGroup
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(OspfGeneralGroup.class);
    public static final String OSPF_ROUTER_ID_ALIAS = "ospfRouterId";
    public static final String OSPF_ROUTER_ID_OID = ".1.3.6.1.2.1.14.1.1";
    public static NamedSnmpVar[] ms_elemList = null;
    public static final String OSPF_GENERAL_GROUP_OID = ".1.3.6.1.2.1.14.1";
    private SnmpStore m_store;
    private InetAddress m_address;

    public OspfGeneralGroup(InetAddress address) {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
        this.m_address = address;
        this.m_store = new SnmpStore(ms_elemList);
    }

    public InetAddress getOspfRouterId() {
        return this.m_store.getIPAddress(OSPF_ROUTER_ID_ALIAS);
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        this.log().warn("Error retrieving lldpLocalGroup from " + this.m_address + ". " + msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        this.log().info("Error retrieving lldpLocalGroup from " + this.m_address + ". " + msg);
    }

    private Logger log() {
        return LOG;
    }

    static {
        ms_elemList = new NamedSnmpVar[1];
        int ndx = 0;
        OspfGeneralGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpIPAddress", OSPF_ROUTER_ID_ALIAS, OSPF_ROUTER_ID_OID);
    }
}

