/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.model.OnmsStpNode;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Dot1dStpGroup
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(Dot1dStpGroup.class);
    public static final String STP_PROTOCOL_SPEC = "dot1dStpProtocolSpecification";
    public static final String STP_PRIORITY = "dot1dStpPriority";
    public static final String STP_DESIGNATED_ROOT = "dot1dStpDesignatedRoot";
    public static final String STP_ROOT_COST = "dot1dStpRootCost";
    public static final String STP_ROOT_PORT = "dot1dStpRootPort";
    private static final NamedSnmpVar[] ms_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "dot1dStpProtocolSpecification", ".1.3.6.1.2.1.17.2.1"), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "dot1dStpPriority", ".1.3.6.1.2.1.17.2.2"), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "dot1dStpDesignatedRoot", ".1.3.6.1.2.1.17.2.5"), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "dot1dStpRootCost", ".1.3.6.1.2.1.17.2.6"), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "dot1dStpRootPort", ".1.3.6.1.2.1.17.2.7")};
    public static final String SYSTEM_OID = ".1.3.6.1.2.1.17.2";
    private SnmpStore m_store;
    private InetAddress m_address;

    public Dot1dStpGroup(InetAddress address) {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
        this.m_address = address;
        this.m_store = new SnmpStore(ms_elemList);
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving systemGroup from {}: {}", (Object)this.m_address, (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving systemGroup from {}: {}", (Object)this.m_address, (Object)msg);
    }

    public int getStpProtocolSpecification() {
        return this.m_store.getValue(STP_PROTOCOL_SPEC) == null ? -1 : this.m_store.getInt32(STP_PROTOCOL_SPEC);
    }

    public int getStpPriority() {
        return this.m_store.getValue(STP_PRIORITY) == null ? -1 : this.m_store.getInt32(STP_PRIORITY);
    }

    public String getStpDesignatedRoot() {
        return this.m_store.getHexString(STP_DESIGNATED_ROOT);
    }

    public int getStpRootCost() {
        return this.m_store.getValue(STP_ROOT_COST) == null ? -1 : this.m_store.getInt32(STP_ROOT_COST);
    }

    public int getStpRootPort() {
        return this.m_store.getValue(STP_ROOT_PORT) == null ? -1 : this.m_store.getInt32(STP_ROOT_PORT);
    }

    public OnmsStpNode getOnmsStpNode(OnmsStpNode node) {
        if (this.getStpDesignatedRoot() == null || this.getStpProtocolSpecification() == -1) {
            return node;
        }
        node.setStpDesignatedRoot(this.getStpDesignatedRoot());
        node.setStpProtocolSpecification(OnmsStpNode.StpProtocolSpecification.get((Integer)this.getStpProtocolSpecification()));
        node.setStpPriority(Integer.valueOf(this.getStpPriority()));
        node.setStpRootCost(Integer.valueOf(this.getStpRootCost()));
        node.setStpRootPort(Integer.valueOf(this.getStpRootPort()));
        return node;
    }
}

