/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.AtInterfaceDao;
import org.opennms.netmgt.dao.api.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.IpRouteInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.api.StpInterfaceDao;
import org.opennms.netmgt.dao.api.StpNodeDao;
import org.opennms.netmgt.dao.api.VlanDao;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.QueryManager;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.SnmpVlanCollection;
import org.opennms.netmgt.linkd.snmp.CdpCacheTableEntry;
import org.opennms.netmgt.linkd.snmp.CdpInterfaceTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dBasePortTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dStpPortTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dTpFdbTableEntry;
import org.opennms.netmgt.linkd.snmp.IpNetToMediaTableEntry;
import org.opennms.netmgt.linkd.snmp.IpRouteCollectorEntry;
import org.opennms.netmgt.linkd.snmp.IsisCircTableEntry;
import org.opennms.netmgt.linkd.snmp.IsisISAdjTableEntry;
import org.opennms.netmgt.linkd.snmp.LldpLocTableEntry;
import org.opennms.netmgt.linkd.snmp.LldpRemTableEntry;
import org.opennms.netmgt.linkd.snmp.MtxrWlRtabTableEntry;
import org.opennms.netmgt.linkd.snmp.OspfNbrTableEntry;
import org.opennms.netmgt.linkd.snmp.QBridgeDot1dTpFdbTableEntry;
import org.opennms.netmgt.linkd.snmp.Vlan;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsAtInterface;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsIpRouteInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.OnmsStpNode;
import org.opennms.netmgt.model.OnmsVlan;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.topology.AtInterface;
import org.opennms.netmgt.model.topology.CdpInterface;
import org.opennms.netmgt.model.topology.IsisISAdjInterface;
import org.opennms.netmgt.model.topology.LinkableNode;
import org.opennms.netmgt.model.topology.LinkableSnmpNode;
import org.opennms.netmgt.model.topology.LldpRemInterface;
import org.opennms.netmgt.model.topology.NodeToNodeLink;
import org.opennms.netmgt.model.topology.OspfNbrInterface;
import org.opennms.netmgt.model.topology.RouterInterface;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class HibernateEventWriter
implements QueryManager {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateEventWriter.class);
    private static final InetAddress m_zeroAddress = InetAddressUtils.addr((String)"0.0.0.0");
    public static final int SNMP_IF_TYPE_ETHERNET = 6;
    public static final int SNMP_IF_TYPE_PROP_VIRTUAL = 53;
    public static final int SNMP_IF_TYPE_L2_VLAN = 135;
    public static final int SNMP_IF_TYPE_L3_VLAN = 136;
    public static final int SNMP_DOT1D_FDB_STATUS_OTHER = 1;
    public static final int SNMP_DOT1D_FDB_STATUS_INVALID = 2;
    public static final int SNMP_DOT1D_FDB_STATUS_LEARNED = 3;
    public static final int SNMP_DOT1D_FDB_STATUS_SELF = 4;
    public static final int SNMP_DOT1D_FDB_STATUS_MGMT = 5;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private SnmpInterfaceDao m_snmpInterfaceDao;
    private AtInterfaceDao m_atInterfaceDao;
    private VlanDao m_vlanDao;
    private StpNodeDao m_stpNodeDao;
    private StpInterfaceDao m_stpInterfaceDao;
    private IpRouteInterfaceDao m_ipRouteInterfaceDao;
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public AtInterfaceDao getAtInterfaceDao() {
        return this.m_atInterfaceDao;
    }

    public void setAtInterfaceDao(AtInterfaceDao atInterfaceDao) {
        this.m_atInterfaceDao = atInterfaceDao;
    }

    public VlanDao getVlanDao() {
        return this.m_vlanDao;
    }

    public void setVlanDao(VlanDao vlanDao) {
        this.m_vlanDao = vlanDao;
    }

    public StpNodeDao getStpNodeDao() {
        return this.m_stpNodeDao;
    }

    public void setStpNodeDao(StpNodeDao stpNodeDao) {
        this.m_stpNodeDao = stpNodeDao;
    }

    public StpInterfaceDao getStpInterfaceDao() {
        return this.m_stpInterfaceDao;
    }

    public void setStpInterfaceDao(StpInterfaceDao stpInterfaceDao) {
        this.m_stpInterfaceDao = stpInterfaceDao;
    }

    public IpRouteInterfaceDao getIpRouteInterfaceDao() {
        return this.m_ipRouteInterfaceDao;
    }

    public void setIpRouteInterfaceDao(IpRouteInterfaceDao ipRouteInterfaceDao) {
        this.m_ipRouteInterfaceDao = ipRouteInterfaceDao;
    }

    public DataLinkInterfaceDao getDataLinkInterfaceDao() {
        return this.m_dataLinkInterfaceDao;
    }

    public void setDataLinkInterfaceDao(DataLinkInterfaceDao dataLinkInterfaceDao) {
        this.m_dataLinkInterfaceDao = dataLinkInterfaceDao;
    }

    protected void sendNewSuspectEvent(InetAddress ipaddress, InetAddress ipowner, String name, Linkd linkd) {
        linkd.sendNewSuspectEvent(ipaddress, ipowner, name);
    }

    @Override
    public List<LinkableSnmpNode> getSnmpNodeList() {
        ArrayList<LinkableSnmpNode> nodes = new ArrayList<LinkableSnmpNode>();
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
        builder.alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN);
        builder.eq("type", (Object)"A");
        builder.eq("iface.isSnmpPrimary", (Object)PrimaryType.PRIMARY);
        for (OnmsNode node : this.m_nodeDao.findMatching(builder.toCriteria())) {
            String sysObjectId = node.getSysObjectId();
            nodes.add(new LinkableSnmpNode(node.getId().intValue(), node.getPrimaryInterface().getIpAddress(), sysObjectId == null ? "-1" : sysObjectId, node.getSysName()));
        }
        return nodes;
    }

    @Override
    public LinkableSnmpNode getSnmpNode(int nodeid) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
        builder.alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN);
        builder.eq("type", (Object)"A");
        builder.eq("iface.isSnmpPrimary", (Object)PrimaryType.PRIMARY);
        builder.eq("id", (Object)nodeid);
        List nodes = this.m_nodeDao.findMatching(builder.toCriteria());
        if (nodes.size() > 0) {
            OnmsNode node = (OnmsNode)nodes.get(0);
            String sysObjectId = node.getSysObjectId();
            return new LinkableSnmpNode(node.getId().intValue(), node.getPrimaryInterface().getIpAddress(), sysObjectId == null ? "-1" : sysObjectId, node.getSysName());
        }
        return null;
    }

    @Override
    public void updateDeletedNodes() {
        this.m_atInterfaceDao.markDeletedIfNodeDeleted();
        this.m_atInterfaceDao.flush();
        this.m_vlanDao.markDeletedIfNodeDeleted();
        this.m_vlanDao.flush();
        this.m_stpNodeDao.markDeletedIfNodeDeleted();
        this.m_stpNodeDao.flush();
        this.m_stpInterfaceDao.markDeletedIfNodeDeleted();
        this.m_stpInterfaceDao.flush();
        this.m_ipRouteInterfaceDao.markDeletedIfNodeDeleted();
        this.m_ipRouteInterfaceDao.flush();
        this.m_dataLinkInterfaceDao.markDeletedIfNodeDeleted();
        this.m_dataLinkInterfaceDao.flush();
    }

    protected void markOldDataInactive(Date scanTime, int nodeid) {
        this.m_atInterfaceDao.deactivateForSourceNodeIdIfOlderThan(nodeid, scanTime);
        this.m_atInterfaceDao.flush();
        this.m_vlanDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_vlanDao.flush();
        this.m_ipRouteInterfaceDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_ipRouteInterfaceDao.flush();
        this.m_stpNodeDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_stpNodeDao.flush();
        this.m_stpInterfaceDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_stpInterfaceDao.flush();
    }

    protected void deleteOlderData(Date scanTime, int nodeid) {
        this.m_atInterfaceDao.deleteForNodeSourceIdIfOlderThan(nodeid, scanTime);
        this.m_atInterfaceDao.flush();
        this.m_vlanDao.deleteForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_vlanDao.flush();
        this.m_ipRouteInterfaceDao.deleteForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_ipRouteInterfaceDao.flush();
        this.m_stpNodeDao.deleteForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_stpNodeDao.flush();
        this.m_stpInterfaceDao.deleteForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_stpInterfaceDao.flush();
    }

    @Override
    @Transactional
    public LinkableNode storeSnmpCollection(LinkableNode node, SnmpCollection snmpColl, Linkd linkd) {
        Date scanTime = new Date();
        OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(node.getNodeId()));
        if (onmsNode == null) {
            LOG.debug("no node found!");
            return null;
        }
        LOG.debug("storeSnmpCollection: wifi hasMtxrWlRtabTable: {}", (Object)snmpColl.hasMtxrWlRtabTable());
        if (snmpColl.hasMtxrWlRtabTable()) {
            this.processWifi(node, snmpColl, scanTime);
        }
        LOG.debug("storeSnmpCollection: ospf hasOspfGeneralGroup/hasOspfNbrTable: {}/{}", (Object)snmpColl.hasOspfGeneralGroup(), (Object)snmpColl.hasOspfNbrTable());
        if (snmpColl.hasOspfGeneralGroup() && snmpColl.hasOspfNbrTable()) {
            this.processOspf(node, snmpColl, scanTime);
        }
        LOG.debug("storeSnmpCollection: isis hasIsIsSystemObjectGroup/hasIsisCircTable/hasIsisISAdjTable: {}/{}/{}", new Object[]{snmpColl.hasIsIsSysObjectGroup(), snmpColl.hasIsisCircTable(), snmpColl.hasIsisISAdjTable()});
        if (snmpColl.hasIsIsSysObjectGroup() && snmpColl.hasIsisCircTable() && snmpColl.hasIsisISAdjTable()) {
            this.processIsis(node, snmpColl, scanTime);
        }
        LOG.debug("storeSnmpCollection: lldp hasLldpLocalGroup/hasLldpLocTable/haLldpRemTable: {}/{}/{}", new Object[]{snmpColl.hasLldpLocalGroup(), snmpColl.hasLldpLocTable(), snmpColl.hasLldpRemTable()});
        if (snmpColl.hasLldpLocalGroup()) {
            this.processLldp(node, snmpColl, scanTime);
        }
        LOG.debug("storeSnmpCollection: hasIpNetToMediaTable: {}", (Object)snmpColl.hasIpNetToMediaTable());
        if (snmpColl.hasIpNetToMediaTable()) {
            this.processIpNetToMediaTable(node, snmpColl, scanTime, linkd);
        }
        LOG.debug("storeSnmpCollection: hasCdpGlobalGroup: {}", (Object)snmpColl.hasCdpGlobalGroup());
        LOG.debug("storeSnmpCollection: hasCdpCacheTable: {}", (Object)snmpColl.hasCdpCacheTable());
        if (snmpColl.hasCdpGlobalGroup() && snmpColl.hasCdpCacheTable()) {
            this.processCdp(node, snmpColl, scanTime, linkd);
        }
        LOG.debug("storeSnmpCollection: hasRouteTable: {}", (Object)snmpColl.hasRouteTable());
        if (snmpColl.hasRouteTable()) {
            this.processRouteTable(onmsNode, node, snmpColl, scanTime, linkd);
        }
        LOG.debug("storeSnmpCollection: hasVlanTable: {}", (Object)snmpColl.hasVlanTable());
        if (snmpColl.hasVlanTable()) {
            this.processVlanTable(onmsNode, node, snmpColl, scanTime);
        }
        if (!snmpColl.getSnmpVlanCollections().isEmpty()) {
            node.setMacIdentifiers(this.getPhysAddrs(node.getNodeId()));
            for (OnmsVlan vlan : snmpColl.getSnmpVlanCollections().keySet()) {
                LOG.debug("storeSnmpCollection: parsing bridge data on VLAN {}/{}", (Object)vlan.getVlanId(), (Object)vlan.getVlanName());
                this.storeSnmpVlanCollection(onmsNode, node, vlan, snmpColl.getSnmpVlanCollections().get(vlan), scanTime, linkd);
            }
        }
        this.markOldDataInactive(scanTime, node.getNodeId());
        this.deleteOlderData(new Date(scanTime.getTime() - snmpColl.getPollInterval() * 3L), node.getNodeId());
        return node;
    }

    private DataLinkInterface getDatabaseLink(Collection<DataLinkInterface> links, int nodeparentid, int parentifindex, DataLinkInterface.DiscoveryProtocol protocol) {
        for (DataLinkInterface link : links) {
            if (link.getNodeParentId() != nodeparentid || link.getParentIfIndex() != parentifindex || link.getProtocol() != protocol) continue;
            LOG.info("storeDiscoveryLink: found link {} on database.", (Object)link);
            return link;
        }
        return null;
    }

    @Override
    @Transactional
    public void storeDiscoveryLink(DiscoveryLink discoveryLink) {
        Date now = new Date();
        String source = "linkd/" + discoveryLink.getPackageName();
        for (NodeToNodeLink lk : discoveryLink.getLinks()) {
            LOG.debug("storeDiscoveryLink: parsing link {}.", (Object)lk);
            DataLinkInterface link = this.getDatabaseLink(this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(lk.getNodeId()), Integer.valueOf(lk.getIfindex())), lk.getNodeparentid(), lk.getParentifindex(), lk.getProtocol());
            if (link == null) {
                LOG.info("storeDiscoveryLink: no found interface on database for link {}. Creating a new one", (Object)lk);
                OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(lk.getNodeId()));
                link = new DataLinkInterface(onmsNode, lk.getIfindex(), lk.getNodeparentid(), lk.getParentifindex(), OnmsArpInterface.StatusType.ACTIVE, now);
                link.setProtocol(lk.getProtocol());
            } else {
                link.setStatus(OnmsArpInterface.StatusType.ACTIVE);
                link.setLastPollTime(now);
            }
            link.setSource(source);
            DataLinkInterface reverselink = this.getDatabaseLink(this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(lk.getNodeparentid()), Integer.valueOf(lk.getParentifindex())), lk.getNodeId(), lk.getIfindex(), lk.getProtocol());
            if (reverselink != null) {
                LOG.info("storeDiscoveryLink: Deleting found reverse link {}.", (Object)reverselink);
                this.m_dataLinkInterfaceDao.delete((Object)reverselink);
            }
            LOG.debug("storeDiscoveryLink: Storing {}", (Object)link);
            this.m_dataLinkInterfaceDao.saveOrUpdate((Object)link);
        }
        this.m_dataLinkInterfaceDao.deactivateIfOlderThan(now, source);
        this.m_dataLinkInterfaceDao.deleteIfOlderThan(new Date(now.getTime() - 3L * discoveryLink.getInterval()), source);
        this.m_dataLinkInterfaceDao.flush();
    }

    @Override
    public void update(int nodeid, OnmsArpInterface.StatusType action, Set<String> activePackages) {
        this.m_vlanDao.setStatusForNode(Integer.valueOf(nodeid), action);
        this.m_atInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), action);
        this.m_ipRouteInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), action);
        this.m_stpNodeDao.setStatusForNode(Integer.valueOf(nodeid), action);
        this.m_stpInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), action);
        for (String packageName : activePackages) {
            this.m_dataLinkInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), "linkd/" + packageName, action);
        }
    }

    @Override
    public void updateForInterface(int nodeid, String ipAddr, int ifIndex, OnmsArpInterface.StatusType action, Set<String> activePackages) {
        if (ipAddr != null && ipAddr.length() != 0 && !"0.0.0.0".equals(ipAddr)) {
            this.m_atInterfaceDao.setStatusForNodeAndIp(Integer.valueOf(nodeid), ipAddr, action);
        }
        if (ifIndex > -1) {
            this.m_atInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), action);
            this.m_stpInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), action);
            this.m_ipRouteInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), action);
            for (String packageName : activePackages) {
                this.m_dataLinkInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), "linkd/" + packageName, action);
            }
        }
    }

    protected int getIfIndexByName(int targetCdpNodeId, String cdpTargetDevicePort) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.alias("node", "node");
        builder.eq("node.id", (Object)targetCdpNodeId);
        builder.or((Restriction)new EqRestriction("ifName", (Object)cdpTargetDevicePort), (Restriction)new EqRestriction("ifDescr", (Object)cdpTargetDevicePort));
        List interfaces = this.m_snmpInterfaceDao.findMatching(builder.toCriteria());
        if (interfaces.isEmpty()) {
            return -1;
        }
        if (interfaces.size() > 1) {
            LOG.debug("getIfIndexByName: More than one SnmpInterface matches nodeId {} and snmpIfName/snmpIfDescr {}", (Object)targetCdpNodeId, (Object)cdpTargetDevicePort);
        }
        return ((OnmsSnmpInterface)interfaces.get(0)).getIfIndex();
    }

    protected List<OnmsNode> getNodeidFromIp(InetAddress cdpTargetIpAddr) {
        ArrayList<OnmsNode> nodeids = new ArrayList<OnmsNode>();
        CriteriaBuilder builder = new CriteriaBuilder(OnmsIpInterface.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.eq("ipAddress", (Object)cdpTargetIpAddr);
        builder.eq("node.type", (Object)"A");
        List interfaces = this.m_ipInterfaceDao.findMatching(builder.toCriteria());
        LOG.debug("getNodeidFromIp: Found {} nodeids matching ipAddress {}", (Object)interfaces.size(), (Object)InetAddressUtils.str((InetAddress)cdpTargetIpAddr));
        for (OnmsIpInterface ipinterface : interfaces) {
            nodeids.add(ipinterface.getNode());
        }
        return nodeids;
    }

    protected List<RouterInterface> getRouteInterface(InetAddress nexthop, int ifindex) {
        ArrayList<RouterInterface> routes = new ArrayList<RouterInterface>();
        List interfaces = this.m_ipInterfaceDao.findByIpAddress(InetAddressUtils.str((InetAddress)nexthop));
        LOG.debug("getRouteInterface: Found {} interface matching ipAddress {}", (Object)interfaces.size(), (Object)InetAddressUtils.str((InetAddress)nexthop));
        for (OnmsIpInterface ipInterface : interfaces) {
            RouterInterface route = null;
            OnmsNode node = ipInterface.getNode();
            OnmsSnmpInterface snmpInterface = ipInterface.getSnmpInterface();
            route = snmpInterface == null || snmpInterface.getNetMask() == null ? new RouterInterface(node.getId().intValue(), -1) : new RouterInterface(node.getId().intValue(), snmpInterface.getIfIndex().intValue(), snmpInterface.getNetMask());
            route.setNextHop(nexthop);
            route.setIfindex(ifindex);
            LOG.debug("getRouteInterface: adding {} route interface", (Object)route);
            routes.add(route);
        }
        return routes;
    }

    protected int getSnmpIfType(int nodeId, Integer ifIndex) {
        Integer snmpIfType = -1;
        OnmsSnmpInterface snmpInterface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(nodeId), ifIndex);
        if (snmpInterface != null) {
            snmpIfType = snmpInterface.getIfType();
        }
        LOG.debug("getSnmpIfType({}, {}), found {}.", new Object[]{nodeId, ifIndex, snmpIfType});
        return snmpIfType;
    }

    protected Map<Integer, String> getPhysAddrs(int nodeId) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.alias("node", "node");
        builder.eq("node.id", (Object)nodeId);
        TreeMap<Integer, String> addrMap = new TreeMap<Integer, String>();
        for (OnmsSnmpInterface snmpInterface : this.m_snmpInterfaceDao.findMatching(builder.toCriteria())) {
            Integer ifindex = snmpInterface.getIfIndex();
            if (ifindex == null) {
                ifindex = -1;
            }
            addrMap.put(ifindex, snmpInterface.getPhysAddr());
        }
        return addrMap;
    }

    @Transactional
    protected void saveIpRouteInterface(final OnmsIpRouteInterface saveMe) {
        new UpsertTemplate<OnmsIpRouteInterface, IpRouteInterfaceDao>(this.m_transactionManager, this.m_ipRouteInterfaceDao){

            protected OnmsIpRouteInterface query() {
                return ((IpRouteInterfaceDao)this.m_dao).findByNodeAndDest(saveMe.getNode().getId(), saveMe.getRouteDest());
            }

            protected OnmsIpRouteInterface doUpdate(OnmsIpRouteInterface updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getRouteDest().equals(saveMe.getRouteDest()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setRouteIfIndex(saveMe.getRouteIfIndex());
                updateMe.setRouteMask(saveMe.getRouteMask());
                updateMe.setRouteMetric1(saveMe.getRouteMetric1());
                updateMe.setRouteMetric2(saveMe.getRouteMetric2());
                updateMe.setRouteMetric3(saveMe.getRouteMetric3());
                updateMe.setRouteMetric4(saveMe.getRouteMetric4());
                updateMe.setRouteMetric5(saveMe.getRouteMetric5());
                updateMe.setRouteNextHop(saveMe.getRouteNextHop());
                updateMe.setRouteProto(saveMe.getRouteProto());
                updateMe.setRouteType(saveMe.getRouteType());
                updateMe.setStatus(saveMe.getStatus());
                ((IpRouteInterfaceDao)this.m_dao).update((Object)updateMe);
                ((IpRouteInterfaceDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsIpRouteInterface doInsert() {
                ((IpRouteInterfaceDao)this.m_dao).save((Object)saveMe);
                ((IpRouteInterfaceDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Transactional
    protected void saveVlan(final OnmsVlan saveMe) {
        new UpsertTemplate<OnmsVlan, VlanDao>(this.m_transactionManager, this.m_vlanDao){

            protected OnmsVlan query() {
                return ((VlanDao)this.m_dao).findByNodeAndVlan(saveMe.getNode().getId(), saveMe.getVlanId());
            }

            protected OnmsVlan doUpdate(OnmsVlan updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getVlanId().equals(saveMe.getVlanId()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setStatus(saveMe.getStatus());
                updateMe.setVlanName(saveMe.getVlanName());
                updateMe.setVlanStatus(saveMe.getVlanStatus());
                updateMe.setVlanType(saveMe.getVlanType());
                ((VlanDao)this.m_dao).update((Object)updateMe);
                ((VlanDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsVlan doInsert() {
                ((VlanDao)this.m_dao).save((Object)saveMe);
                ((VlanDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Transactional
    protected void saveStpNode(final OnmsStpNode saveMe) {
        new UpsertTemplate<OnmsStpNode, StpNodeDao>(this.m_transactionManager, this.m_stpNodeDao){

            protected OnmsStpNode query() {
                return ((StpNodeDao)this.m_dao).findByNodeAndVlan(saveMe.getNode().getId(), saveMe.getBaseVlan());
            }

            protected OnmsStpNode doUpdate(OnmsStpNode updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getBaseVlan().equals(saveMe.getBaseVlan()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setBaseBridgeAddress(saveMe.getBaseBridgeAddress());
                updateMe.setBaseNumPorts(saveMe.getBaseNumPorts());
                updateMe.setBaseType(saveMe.getBaseType());
                updateMe.setBaseVlanName(saveMe.getBaseVlanName());
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setStatus(saveMe.getStatus());
                updateMe.setStpDesignatedRoot(saveMe.getStpDesignatedRoot());
                updateMe.setStpPriority(saveMe.getStpPriority());
                updateMe.setStpProtocolSpecification(saveMe.getStpProtocolSpecification());
                updateMe.setStpRootCost(saveMe.getStpRootCost());
                updateMe.setStpRootPort(saveMe.getStpRootPort());
                ((StpNodeDao)this.m_dao).update((Object)updateMe);
                ((StpNodeDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsStpNode doInsert() {
                ((StpNodeDao)this.m_dao).save((Object)saveMe);
                ((StpNodeDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Transactional
    protected void saveStpInterface(final OnmsStpInterface saveMe) {
        new UpsertTemplate<OnmsStpInterface, StpInterfaceDao>(this.m_transactionManager, this.m_stpInterfaceDao){

            protected OnmsStpInterface query() {
                return ((StpInterfaceDao)this.m_dao).findByNodeAndVlan(saveMe.getNode().getId(), saveMe.getBridgePort(), saveMe.getVlan());
            }

            protected OnmsStpInterface doUpdate(OnmsStpInterface updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getBridgePort().equals(saveMe.getBridgePort()));
                Assert.isTrue((boolean)updateMe.getVlan().equals(saveMe.getVlan()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setIfIndex(saveMe.getIfIndex());
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setStatus(saveMe.getStatus());
                updateMe.setStpPortDesignatedBridge(saveMe.getStpPortDesignatedBridge());
                updateMe.setStpPortDesignatedCost(saveMe.getStpPortDesignatedCost());
                updateMe.setStpPortDesignatedPort(saveMe.getStpPortDesignatedPort());
                updateMe.setStpPortDesignatedRoot(saveMe.getStpPortDesignatedRoot());
                updateMe.setStpPortPathCost(saveMe.getStpPortPathCost());
                updateMe.setStpPortState(saveMe.getStpPortState());
                ((StpInterfaceDao)this.m_dao).update((Object)updateMe);
                ((StpInterfaceDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsStpInterface doInsert() {
                ((StpInterfaceDao)this.m_dao).save((Object)saveMe);
                ((StpInterfaceDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Transactional
    protected void saveAtInterface(final OnmsAtInterface saveMe) {
        new UpsertTemplate<OnmsAtInterface, AtInterfaceDao>(this.m_transactionManager, this.m_atInterfaceDao){

            protected OnmsAtInterface query() {
                return ((AtInterfaceDao)this.m_dao).findByNodeAndAddress(saveMe.getNode().getId(), saveMe.getIpAddress(), saveMe.getMacAddress());
            }

            protected OnmsAtInterface doUpdate(OnmsAtInterface updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getIpAddress().equals(saveMe.getIpAddress()));
                Assert.isTrue((boolean)updateMe.getMacAddress().equals(saveMe.getMacAddress()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setIfIndex(saveMe.getIfIndex());
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setStatus(saveMe.getStatus());
                ((AtInterfaceDao)this.m_dao).update((Object)updateMe);
                ((AtInterfaceDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsAtInterface doInsert() {
                ((AtInterfaceDao)this.m_dao).save((Object)saveMe);
                ((AtInterfaceDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    protected OnmsSnmpInterface getFromSysnameIpAddress(String lldpRemSysname, InetAddress lldpRemPortid) {
        Criteria criteria = new Criteria(OnmsSnmpInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN), new Alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.sysName", (Object)lldpRemSysname));
        criteria.addRestriction((Restriction)new EqRestriction("iface.ipAddress", (Object)lldpRemPortid));
        List interfaces = this.m_snmpInterfaceDao.findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty() && interfaces.size() == 1) {
            return (OnmsSnmpInterface)interfaces.get(0);
        }
        return null;
    }

    protected OnmsSnmpInterface getFromSysnameIfName(String lldpRemSysname, String lldpRemPortid) {
        Criteria criteria = new Criteria(OnmsSnmpInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.sysName", (Object)lldpRemSysname));
        criteria.addRestriction((Restriction)new EqRestriction("ifName", (Object)lldpRemPortid));
        List interfaces = this.m_snmpInterfaceDao.findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty() && interfaces.size() == 1) {
            return (OnmsSnmpInterface)interfaces.get(0);
        }
        return null;
    }

    protected OnmsSnmpInterface getFromSysnameIfIndex(String lldpRemSysname, Integer lldpRemPortid) {
        Criteria criteria = new Criteria(OnmsSnmpInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.sysName", (Object)lldpRemSysname));
        criteria.addRestriction((Restriction)new EqRestriction("ifIndex", (Object)lldpRemPortid));
        List interfaces = this.m_snmpInterfaceDao.findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty() && interfaces.size() == 1) {
            return (OnmsSnmpInterface)interfaces.get(0);
        }
        return null;
    }

    protected OnmsSnmpInterface getFromSysnameMacAddress(String lldpRemSysname, String lldpRemPortid) {
        Criteria criteria = new Criteria(OnmsSnmpInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.sysName", (Object)lldpRemSysname));
        criteria.addRestriction((Restriction)new EqRestriction("physAddr", (Object)lldpRemPortid));
        List interfaces = this.m_snmpInterfaceDao.findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty() && interfaces.size() == 1) {
            return (OnmsSnmpInterface)interfaces.get(0);
        }
        return null;
    }

    protected OnmsSnmpInterface getFromSysnameIfAlias(String lldpRemSysname, String lldpRemPortid) {
        Criteria criteria = new Criteria(OnmsSnmpInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.sysName", (Object)lldpRemSysname));
        criteria.addRestriction((Restriction)new EqRestriction("ifAlias", (Object)lldpRemPortid));
        List interfaces = this.m_snmpInterfaceDao.findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty() && interfaces.size() == 1) {
            return (OnmsSnmpInterface)interfaces.get(0);
        }
        return null;
    }

    protected OnmsSnmpInterface getFromSysnameAgentCircuitId(String lldpRemSysname, String lldpRemPortid) {
        LOG.warn("getFromSysnameAgentCircuitId: AgentCircuitId LLDP PortSubTypeId not supported");
        return null;
    }

    protected OnmsSnmpInterface getFromSysnamePortComponent(String lldpRemSysname, String lldpRemPortid) {
        LOG.warn("getFromSysnamePortComponent:PortComponent LLDP PortSubTypeId not supported");
        return null;
    }

    protected void processIpNetToMediaTable(LinkableNode node, SnmpCollection snmpcoll, Date scanTime, Linkd linkd) {
        boolean hasPrimaryIpAsAtinterface = false;
        if (LOG.isDebugEnabled()) {
            if (snmpcoll.getIpNetToMediaTable().size() > 0) {
                LOG.debug("processIpNetToMediaTable: Starting ipNetToMedia table processing for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            } else {
                LOG.debug("processIpNetToMediaTable: Zero ipNetToMedia table entries for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            }
        }
        for (IpNetToMediaTableEntry ent : snmpcoll.getIpNetToMediaTable()) {
            int ifindex = ent.getIpNetToMediaIfIndex();
            if (ifindex < 0) {
                LOG.warn("processIpNetToMediaTable: invalid ifindex {}", (Object)ifindex);
                continue;
            }
            InetAddress ipaddress = ent.getIpNetToMediaNetAddress();
            if (ipaddress.equals(node.getSnmpPrimaryIpAddr())) {
                hasPrimaryIpAsAtinterface = true;
            }
            String hostAddress = InetAddressUtils.str((InetAddress)ipaddress);
            if (ipaddress == null || ipaddress.isLoopbackAddress() || m_zeroAddress.equals(ipaddress)) {
                LOG.warn("processIpNetToMediaTable: invalid IP: {}", (Object)hostAddress);
                continue;
            }
            String physAddr = ent.getIpNetToMediaPhysAddress();
            if (physAddr == null || physAddr.equals("000000000000") || physAddr.equalsIgnoreCase("ffffffffffff")) {
                LOG.warn("processIpNetToMediaTable: invalid MAC address {} for IP {}", (Object)physAddr, (Object)hostAddress);
                continue;
            }
            LOG.debug("processIpNetToMediaTable: trying save ipNetToMedia info: IP address {}, MAC address {}, ifIndex {}", new Object[]{hostAddress, physAddr, ifindex});
            List iplist = this.m_ipInterfaceDao.findByIpAddress(hostAddress);
            if (iplist.isEmpty()) {
                LOG.debug("processIpNetToMediaTable: no node found for IP address {}.", (Object)hostAddress);
                this.sendNewSuspectEvent(ipaddress, snmpcoll.getTarget(), snmpcoll.getPackageName(), linkd);
                continue;
            }
            OnmsIpInterface ipinterface = null;
            if (iplist.size() > 1) {
                LOG.debug("processIpNetToMediaTable: found duplicated  IP address {}.", (Object)hostAddress);
                for (OnmsIpInterface ip : iplist) {
                    LOG.debug("processIpNetToMediaTable: parsing duplicated  ip interface {}.", (Object)ip);
                    if (ip.getNode().getId().intValue() != node.getNodeId()) continue;
                    LOG.debug("processIpNetToMediaTable: suitable ip interface found. Skipping entry {}", (Object)ip);
                    ipinterface = ip;
                    break;
                }
                if (ipinterface == null) {
                    LOG.debug("processIpNetToMediaTable: no suitable duplicated  arp interface found. Skipping entry {}", (Object)ent);
                    continue;
                }
            } else {
                ipinterface = (OnmsIpInterface)iplist.iterator().next();
            }
            OnmsAtInterface at = new OnmsAtInterface(ipinterface.getNode(), ipinterface.getIpAddress());
            int interfaceindex = this.getIfIndex(at.getNode().getId(), hostAddress);
            LOG.debug("processIpNetToMediaTable: found ifindex {} for node {} IP address {}.", new Object[]{interfaceindex, node.getNodeId(), hostAddress});
            at.setSourceNodeId(Integer.valueOf(node.getNodeId()));
            if (at.getMacAddress() != null && !at.getMacAddress().equals(physAddr)) {
                LOG.info("processIpNetToMediaTable: Setting OnmsAtInterface MAC address to {} but it used to be '{}' (IP Address = {}, ifIndex = {})", new Object[]{physAddr, at.getMacAddress(), hostAddress, ifindex});
            }
            at.setMacAddress(physAddr);
            if (at.getIfIndex() != null && at.getIfIndex() != ifindex) {
                LOG.info("processIpNetToMediaTable: Setting OnmsAtInterface ifIndex to {} but it used to be '{}' (IP Address = {}, MAC = {})", new Object[]{ifindex, at.getIfIndex(), hostAddress, physAddr});
            }
            at.setIfIndex(Integer.valueOf(interfaceindex));
            at.setLastPollTime(scanTime);
            at.setStatus(OnmsArpInterface.StatusType.ACTIVE);
            this.saveAtInterface(at);
            AtInterface atinterface = new AtInterface(at.getNode().getId(), physAddr, at.getIpAddress());
            atinterface.setIfIndex(Integer.valueOf(interfaceindex));
            linkd.addAtInterface(snmpcoll.getPackageName(), atinterface);
        }
        if (!hasPrimaryIpAsAtinterface) {
            this.savePrimaryAddressAtInterface(snmpcoll.getPackageName(), node, linkd);
        }
    }

    private void savePrimaryAddressAtInterface(String packageName, LinkableNode node, Linkd linkd) {
        OnmsSnmpInterface snmpinterface;
        LOG.info("savePrimaryAddressAtInterface: try to setting ifindex for linkednode primary ip address '{}' ", (Object)node.getSnmpPrimaryIpAddr().getHostAddress());
        OnmsIpInterface ipinterface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(Integer.valueOf(node.getNodeId()), node.getSnmpPrimaryIpAddr().getHostAddress());
        if (ipinterface != null && (snmpinterface = ipinterface.getSnmpInterface()) != null && snmpinterface.getPhysAddr() != null) {
            AtInterface at = new AtInterface(Integer.valueOf(node.getNodeId()), snmpinterface.getPhysAddr(), node.getSnmpPrimaryIpAddr());
            at.setMacAddress(snmpinterface.getPhysAddr());
            LOG.info("savePrimaryAddressAtInterface: Setting AtInterface ifIndex to {}, for primary IP Address {}, MAC = {})", new Object[]{at.getIfIndex(), at.getIpAddress().getHostAddress(), at.getMacAddress()});
            at.setIfIndex(snmpinterface.getIfIndex());
            linkd.addAtInterface(packageName, at);
        }
    }

    protected Integer getIfIndex(Integer nodeid, String ipaddress) {
        OnmsIpInterface ipinterface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeid, ipaddress);
        if (ipinterface != null && ipinterface.getIfIndex() != null) {
            LOG.info("getIfindex: found ip interface for address '{}' on ifindex {}", (Object)ipinterface.getIpAddress().getHostAddress(), (Object)ipinterface.getIfIndex());
            return ipinterface.getIfIndex();
        }
        LOG.info("getIfIndex: no (ipinterface)ifindex found for nodeid {}, address '{}'.", (Object)nodeid, (Object)ipaddress);
        return -1;
    }

    protected void processIsis(LinkableNode node, SnmpCollection snmpcoll, Date scanTime) {
        String isisSysId = snmpcoll.getIsIsSystemObjectGroup().getIsisSysId();
        LOG.debug("processIsis: isis node/isissysId: {}/{}", (Object)node.getNodeId(), (Object)isisSysId);
        if (snmpcoll.getIsIsSystemObjectGroup().getIsisSysAdminState() == IsIsElement.IsisAdminState.off) {
            LOG.info("processIsis: isis admin down on node/isisSysId: {}/{}. Skipping!", (Object)node.getNodeId(), (Object)isisSysId);
            return;
        }
        node.setIsisSysId(isisSysId);
        TreeMap<Integer, Integer> isisCircIndexIfIndexMap = new TreeMap<Integer, Integer>();
        for (IsisCircTableEntry circ : snmpcoll.getIsisCircTable()) {
            isisCircIndexIfIndexMap.put(circ.getIsisCircIndex(), circ.getIsisCircIfIndex());
        }
        ArrayList<IsisISAdjInterface> isisinterfaces = new ArrayList<IsisISAdjInterface>();
        for (IsisISAdjTableEntry isisAdj : snmpcoll.getIsisISAdjTable()) {
            if (isisAdj.getIsIsAdjStatus() != IsIsLink.IsisISAdjState.up) {
                LOG.info("processIsis: isis adj status not UP but {}, on node/isisISAdjNeighSysId/isisLocalCircIndex: {}/{}/{}. Skipping!", new Object[]{isisAdj.getIsIsAdjStatus(), node.getNodeId(), isisAdj.getIsIsAdjNeighSysId(), isisAdj.getIsisCircIndex()});
                return;
            }
            if (!isisCircIndexIfIndexMap.containsKey(isisAdj.getIsisCircIndex())) {
                LOG.info("processIsis: isis Circ Index not found on CircTable, on node/isisISAdjNeighSysId/isisLocalCircIndex: {}/{}/{}. Skipping!", new Object[]{node.getNodeId(), isisAdj.getIsIsAdjNeighSysId(), isisAdj.getIsisCircIndex()});
                return;
            }
            IsisISAdjInterface isisinterface = new IsisISAdjInterface(isisAdj.getIsIsAdjNeighSysId(), (Integer)isisCircIndexIfIndexMap.get(isisAdj.getIsisCircIndex()), isisAdj.getIsIsAdjNeighSnpaAddress(), isisAdj.getIsisISAdjIndex());
            LOG.debug("processIsis: isis adding adj interface node/interface: {}/{}", (Object)node.getNodeId(), (Object)isisinterface);
            isisinterfaces.add(isisinterface);
        }
        node.setIsisInterfaces(isisinterfaces);
    }

    protected void processWifi(LinkableNode node, SnmpCollection snmpcoll, Date scanTime) {
        for (MtxrWlRtabTableEntry entry : snmpcoll.getMtxrWlRtabTable().getEntries()) {
            node.addWifiMacAddress(entry.getMtxrWlRtabIface(), entry.getMtxrWlRtabAddr());
        }
    }

    protected void processOspf(LinkableNode node, SnmpCollection snmpcoll, Date scanTime) {
        InetAddress ospfRouterId = snmpcoll.getOspfGeneralGroup().getOspfRouterId();
        LOG.debug("processOspf: node {}: ospf router id: {}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)ospfRouterId));
        if (m_zeroAddress.equals(ospfRouterId)) {
            LOG.info("processOspf: node {}: invalid ospf ruoter id: ospfrouterid: {}. Skipping!", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)ospfRouterId));
            return;
        }
        node.setOspfRouterId(ospfRouterId);
        ArrayList<OspfNbrInterface> ospfinterfaces = new ArrayList<OspfNbrInterface>();
        for (OspfNbrTableEntry ospfNbrTableEntry : snmpcoll.getOspfNbrTable()) {
            InetAddress ospfNbrRouterId = ospfNbrTableEntry.getOspfNbrRouterId();
            InetAddress ospfNbrIpAddr = ospfNbrTableEntry.getOspfNbrIpAddress();
            LOG.debug("processOspf: node {}: ospf nei: ospfnbraddress/ospfnbrrouterid: {}/{}", new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)ospfNbrIpAddr), InetAddressUtils.str((InetAddress)ospfNbrRouterId)});
            if (m_zeroAddress.equals(ospfNbrIpAddr) || m_zeroAddress.equals(ospfNbrRouterId)) {
                LOG.info("processOspf: node {}: ospf nei found invalid ip address: ospfnbraddress/ospfnbrrouterid: {}/{}", new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)ospfNbrIpAddr), InetAddressUtils.str((InetAddress)ospfNbrRouterId)});
                continue;
            }
            Integer ifIndex = ospfNbrTableEntry.getOspfNbrAddressLessIndex();
            LOG.debug("processOspf: node {}: ospf nei ospfnbrAddressLessIfIndex {} for: ospfnbraddress/ospfnbrrouterid: {}/{}", new Object[]{node.getNodeId(), ifIndex, InetAddressUtils.str((InetAddress)ospfNbrIpAddr), InetAddressUtils.str((InetAddress)ospfNbrRouterId)});
            List ipinterfaces = this.m_ipInterfaceDao.findByIpAddress(InetAddressUtils.str((InetAddress)ospfNbrIpAddr));
            for (OnmsIpInterface ipinterface : ipinterfaces) {
                if (ifIndex == 0) {
                    ifIndex = ipinterface.getIfIndex();
                }
                LOG.debug("processOspf: node {}: ospf nei nodeid/ifindex {}/{} for: ospfnbraddress/ospfnbrrouterid: {}/{}", new Object[]{node.getNodeId(), ipinterface.getNode().getId(), ifIndex, InetAddressUtils.str((InetAddress)ospfNbrIpAddr), InetAddressUtils.str((InetAddress)ospfNbrRouterId)});
                if (ifIndex != null && ifIndex > 0) {
                    OspfNbrInterface ospfinterface = new OspfNbrInterface(ospfNbrRouterId);
                    ospfinterface.setOspfNbrNodeId(ipinterface.getNode().getId().intValue());
                    ospfinterface.setOspfNbrIpAddr(ospfNbrIpAddr);
                    OnmsSnmpInterface snmpinterface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(ipinterface.getNode().getId(), ifIndex);
                    if (snmpinterface != null && snmpinterface.getNetMask() != null) {
                        ospfinterface.setOspfNbrNetMask(snmpinterface.getNetMask());
                    } else {
                        ospfinterface.setOspfNbrNetMask(InetAddressUtils.getInetAddress((String)"255.255.255.252"));
                    }
                    ospfinterface.setOspfNbrIfIndex(ifIndex.intValue());
                    LOG.debug("processOspf: node {}: found ospf nei netmask {} for: ospfnbraddress/ospfnbrrouterid: {}/{}", new Object[]{node.getNodeId(), InetAddressUtils.str((InetAddress)ospfinterface.getOspfNbrNetMask()), InetAddressUtils.str((InetAddress)ospfNbrIpAddr), InetAddressUtils.str((InetAddress)ospfNbrRouterId)});
                    LOG.debug("processOspf: node {}: adding ospf nei interface: ospfinterface: {}", (Object)node.getNodeId(), (Object)ospfinterface);
                    ospfinterfaces.add(ospfinterface);
                    continue;
                }
                LOG.info("processOspf: node {}: ospf nei invalid ifindex {} for: ospfnbraddress/ospfnbrrouterid: {}/{}. Skipping!", new Object[]{node.getNodeId(), ifIndex, InetAddressUtils.str((InetAddress)ospfNbrIpAddr), InetAddressUtils.str((InetAddress)ospfNbrRouterId)});
            }
        }
        node.setOspfinterfaces(ospfinterfaces);
    }

    protected void processLldp(LinkableNode node, SnmpCollection snmpcoll, Date scanTime) {
        node.setLldpChassisId(snmpcoll.getLldpLocalGroup().getLldpLocChassisid());
        node.setLldpChassisIdSubtype(snmpcoll.getLldpLocalGroup().getLldpLocChassisidSubType());
        node.setLldpSysname(snmpcoll.getLldpLocalGroup().getLldpLocSysname());
        Map<Integer, LldpLocTableEntry> localPortNumberToLocTableEntryMap = this.getLocalPortNumberToLocalTableEntryMap(snmpcoll);
        ArrayList<LldpRemInterface> lldpRemInterfaces = new ArrayList<LldpRemInterface>();
        for (LldpRemTableEntry lldpRemTableEntry : snmpcoll.getLldpRemTable()) {
            LOG.debug("processLldp: lldp remote entry node/localport/remporttype/remport: {}/{}/{}/{}", new Object[]{node.getNodeId(), lldpRemTableEntry.getLldpRemLocalPortNum(), lldpRemTableEntry.getLldpRemPortidSubtype(), lldpRemTableEntry.getLldpRemPortid()});
            Integer lldpLocsnmpIf = this.getLldpLocIfIndex(node.getLldpSysname(), localPortNumberToLocTableEntryMap.get(lldpRemTableEntry.getLldpRemLocalPortNum()));
            if (lldpLocsnmpIf == null) {
                LOG.warn("processLldp: lldp local ifindex not found for local node/lldpLocalPortNumber: {}/{}", (Object)node.getNodeId(), (Object)lldpRemTableEntry.getLldpRemLocalPortNum());
                continue;
            }
            LOG.debug("processLldp: lldp local entry node/localport/localifIndex: {}/{}/{}", new Object[]{node.getNodeId(), lldpRemTableEntry.getLldpRemLocalPortNum(), lldpLocsnmpIf});
            OnmsSnmpInterface lldpRemSnmpInterface = this.getLldpRemIfIndex(lldpRemTableEntry);
            if (lldpRemSnmpInterface == null) {
                LOG.warn("processLldp: lldp remote node/ifindex not found for remote sysname/porttype/portid: {}/{}/{}", new Object[]{lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortidSubtype(), lldpRemTableEntry.getLldpRemPortid()});
                continue;
            }
            LldpRemInterface lldpremint = new LldpRemInterface(lldpRemTableEntry.getLldpRemChassisidSubtype(), lldpRemTableEntry.getLldpRemChassiid(), lldpRemSnmpInterface.getNode().getId(), lldpRemSnmpInterface.getIfIndex(), lldpLocsnmpIf);
            lldpRemInterfaces.add(lldpremint);
        }
        node.setLldpRemInterfaces(lldpRemInterfaces);
    }

    private Map<Integer, LldpLocTableEntry> getLocalPortNumberToLocalTableEntryMap(SnmpCollection snmpcoll) {
        TreeMap<Integer, LldpLocTableEntry> localPortNumberToLocTableEntryMap = new TreeMap<Integer, LldpLocTableEntry>();
        for (LldpLocTableEntry lldpLocTableEntry : snmpcoll.getLldpLocTable()) {
            localPortNumberToLocTableEntryMap.put(lldpLocTableEntry.getLldpLocPortNum(), lldpLocTableEntry);
        }
        return localPortNumberToLocTableEntryMap;
    }

    private OnmsSnmpInterface getLldpRemIfIndex(LldpRemTableEntry lldpRemTableEntry) {
        LOG.debug("getLldpRemIfIndex: parsing sysname/porttype/portid: {}/{}/{}", new Object[]{lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortidSubtype(), lldpRemTableEntry.getLldpRemPortid()});
        OnmsSnmpInterface snmpif = null;
        switch (lldpRemTableEntry.getLldpRemPortidSubtype()) {
            case 1: {
                snmpif = this.getFromSysnameIfAlias(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortid());
                if (snmpif != null) break;
                snmpif = this.getFromSysnameIfName(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortid());
                break;
            }
            case 2: {
                snmpif = this.getFromSysnamePortComponent(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortid());
                break;
            }
            case 3: {
                snmpif = this.getFromSysnameMacAddress(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemMacAddress());
                break;
            }
            case 4: {
                snmpif = this.getFromSysnameIpAddress(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemIpAddress());
                break;
            }
            case 5: {
                snmpif = this.getFromSysnameIfName(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortid());
                break;
            }
            case 6: {
                snmpif = this.getFromSysnameAgentCircuitId(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortid());
                break;
            }
            case 7: {
                try {
                    snmpif = this.getFromSysnameIfIndex(lldpRemTableEntry.getLldpRemSysname(), Integer.parseInt(lldpRemTableEntry.getLldpRemPortid()));
                    break;
                }
                catch (NumberFormatException e) {
                    snmpif = this.getFromSysnameIfName(lldpRemTableEntry.getLldpRemSysname(), lldpRemTableEntry.getLldpRemPortid());
                }
            }
        }
        return snmpif;
    }

    private Integer getLldpLocIfIndex(String sysname, LldpLocTableEntry lldpLocTableEntry) {
        OnmsSnmpInterface snmpif = null;
        LOG.debug("getLldpLocIfIndex: parsing sysname/porttype/portid: {}/{}/{}", new Object[]{sysname, lldpLocTableEntry.getLldpLocPortIdSubtype(), lldpLocTableEntry.getLldpLocPortid()});
        switch (lldpLocTableEntry.getLldpLocPortIdSubtype()) {
            case 1: {
                snmpif = this.getFromSysnameIfAlias(sysname, lldpLocTableEntry.getLldpLocPortid());
                if (snmpif != null) break;
                snmpif = this.getFromSysnameIfName(sysname, lldpLocTableEntry.getLldpLocPortid());
                break;
            }
            case 2: {
                snmpif = this.getFromSysnamePortComponent(sysname, lldpLocTableEntry.getLldpLocPortid());
                break;
            }
            case 3: {
                snmpif = this.getFromSysnameMacAddress(sysname, lldpLocTableEntry.getLldpLocMacAddress());
                break;
            }
            case 4: {
                snmpif = this.getFromSysnameIpAddress(sysname, lldpLocTableEntry.getLldpLocIpAddress());
                break;
            }
            case 5: {
                snmpif = this.getFromSysnameIfName(sysname, lldpLocTableEntry.getLldpLocPortid());
                break;
            }
            case 6: {
                snmpif = this.getFromSysnameAgentCircuitId(sysname, lldpLocTableEntry.getLldpLocPortid());
                break;
            }
            case 7: {
                try {
                    return Integer.parseInt(lldpLocTableEntry.getLldpLocPortid());
                }
                catch (NumberFormatException e) {
                    snmpif = this.getFromSysnameIfName(sysname, lldpLocTableEntry.getLldpLocPortid());
                }
            }
        }
        if (snmpif != null) {
            return snmpif.getIfIndex();
        }
        return null;
    }

    protected void processCdp(LinkableNode node, SnmpCollection snmpcoll, Date scanTime, Linkd linkd) {
        String cdpDeviceid = snmpcoll.getCdpGlobalGroup().getCdpDeviceId();
        LOG.debug("processCdp: Setting CDP device id {} for node {} with ip primary {}", new Object[]{cdpDeviceid, node.getNodeId(), InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr())});
        node.setCdpDeviceId(cdpDeviceid);
        if (LOG.isDebugEnabled()) {
            if (snmpcoll.getCdpCacheTable().size() > 0) {
                LOG.debug("processCdp: Starting CDP cache table processing for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            } else {
                LOG.debug("processCdp: Zero CDP cache table entries for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            }
        }
        TreeMap<Integer, String> cdpifindextoIfnameMap = new TreeMap<Integer, String>();
        if (snmpcoll.hasCdpInterfaceTable()) {
            for (CdpInterfaceTableEntry cdpEntry : snmpcoll.getCdpInterfaceTable()) {
                LOG.debug("processCdp:adding interface table entries ifindex/ifname {}/{} for node {}", new Object[]{cdpEntry.getCdpInterfaceIfIndex(), cdpEntry.getCdpInterfaceName(), node.getNodeId()});
                cdpifindextoIfnameMap.put(cdpEntry.getCdpInterfaceIfIndex(), cdpEntry.getCdpInterfaceName());
            }
        } else {
            LOG.debug("processCdp:no interface table entries  for node {}", (Object)node.getNodeId());
        }
        ArrayList<CdpInterface> cdpInterfaces = new ArrayList<CdpInterface>();
        for (CdpCacheTableEntry cdpEntry : snmpcoll.getCdpCacheTable()) {
            OnmsSnmpInterface iface;
            int cdpIfIndex = cdpEntry.getCdpCacheIfIndex();
            if (cdpIfIndex < 0) {
                LOG.debug("processCdp: ifIndex not valid: {}", (Object)cdpIfIndex);
                continue;
            }
            LOG.debug("processCdp: ifIndex found: {}", (Object)cdpIfIndex);
            String cdpTargetDeviceId = cdpEntry.getCdpCacheDeviceId();
            if (cdpTargetDeviceId == null) {
                LOG.warn("processCdp: Target device id not found. Skipping.");
                continue;
            }
            LOG.debug("processCdp: cdpTargetDeviceId found: {}", (Object)cdpTargetDeviceId);
            String cdpTargetIfName = cdpEntry.getCdpCacheDevicePort();
            if (cdpTargetIfName == null) {
                LOG.warn("processCdp: Target device port not found. Skipping.");
                continue;
            }
            LOG.debug("processCdp: Target device port name found: {}", (Object)cdpTargetIfName);
            int cdpAddrType = cdpEntry.getCdpCacheAddressType();
            if (cdpAddrType != 1) {
                LOG.warn("processCdp: CDP address type not ip: {}. Skipping", (Object)cdpAddrType);
                continue;
            }
            InetAddress cdpTargetIpAddr = cdpEntry.getCdpCacheIpv4Address();
            LOG.debug("processCdp: cdp cache ip address found: {}", (Object)InetAddressUtils.str((InetAddress)cdpTargetIpAddr));
            if (cdpTargetIpAddr == null || cdpTargetIpAddr.isLoopbackAddress() || m_zeroAddress.equals(cdpTargetIpAddr)) {
                LOG.debug("processCdp: IP address is not valid: {}. Skipping", (Object)InetAddressUtils.str((InetAddress)cdpTargetIpAddr));
                continue;
            }
            if (!linkd.isInterfaceInPackage(cdpTargetIpAddr, snmpcoll.getPackageName())) {
                LOG.debug("processCdp: target IP address {} Not in package: {}.  Skipping.", (Object)InetAddressUtils.str((InetAddress)cdpTargetIpAddr), (Object)snmpcoll.getPackageName());
                continue;
            }
            String cdpIfName = (String)cdpifindextoIfnameMap.get(cdpIfIndex);
            if (cdpIfName == null && (iface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(node.getNodeId()), Integer.valueOf(cdpIfIndex))) != null) {
                cdpIfName = iface.getIfName();
            }
            CdpInterface cdpIface = new CdpInterface(cdpIfIndex);
            cdpIface.setCdpIfName(cdpIfName);
            cdpIface.setCdpTargetDeviceId(cdpTargetDeviceId);
            cdpIface.setCdpTargetIfName(cdpTargetIfName);
            LOG.debug("processCdp: Adding cdp interface {} to linkable node {}.", (Object)cdpIface, (Object)node.getNodeId());
            cdpInterfaces.add(cdpIface);
            LOG.debug("processCdp: try to add cdp interface for non snmp node");
            List<OnmsNode> targetCdpNodeIds = this.getNodeidFromIp(cdpTargetIpAddr);
            if (targetCdpNodeIds.isEmpty()) {
                LOG.info("processCdp: No Target node IDs found: interface {} not added to linkable SNMP node. Skipping.", (Object)InetAddressUtils.str((InetAddress)cdpTargetIpAddr));
                this.sendNewSuspectEvent(cdpTargetIpAddr, snmpcoll.getTarget(), snmpcoll.getPackageName(), linkd);
                continue;
            }
            if (targetCdpNodeIds.size() > 1) {
                LOG.info("processCdp: More Then One Target node IDs found: interface {} not added to linkable SNMP node. Skipping adding non snmp node.", (Object)InetAddressUtils.str((InetAddress)cdpTargetIpAddr));
                continue;
            }
            OnmsNode targetCdpNode = targetCdpNodeIds.iterator().next();
            if (targetCdpNode.getSysName() != null && !targetCdpNode.getSysName().equals("")) continue;
            LOG.info("processCdp: no snmp Target node ID found: {}.", (Object)targetCdpNode.getId());
            CdpInterface cdpIfaceNotSnmp = new CdpInterface(cdpIfIndex);
            cdpIfaceNotSnmp.setCdpTargetNodeId(targetCdpNode.getId());
            LOG.debug("processCdp: Adding cdp interface {} to linkable node {}.", (Object)cdpIfaceNotSnmp, (Object)node.getNodeId());
            cdpInterfaces.add(cdpIfaceNotSnmp);
        }
        node.setCdpInterfaces(cdpInterfaces);
    }

    protected void processRouteTable(OnmsNode onmsNode, LinkableNode node, SnmpCollection snmpcoll, Date scanTime, Linkd linkd) {
        if (LOG.isDebugEnabled()) {
            int routes = snmpcoll.getIpRouteTable().size();
            if (routes > 0) {
                LOG.debug("processRouteTable: Starting route table processing for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
                LOG.debug("processRouteTable: processing # {} routing interfaces", (Object)routes);
            } else {
                LOG.debug("processRouteTable: Zero route table entries for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            }
        }
        ArrayList<RouterInterface> routeInterfaces = new ArrayList<RouterInterface>();
        for (SnmpStore ent : snmpcoll.getIpRouteTable()) {
            IpRouteCollectorEntry route = (IpRouteCollectorEntry)ent;
            InetAddress nexthop = route.getIpRouteNextHop();
            InetAddress routedest = route.getIpRouteDest();
            InetAddress routemask = route.getIpRouteMask();
            LOG.debug("processRouteTable: processing routedest/routemask/routenexthop {}/{}/{}", new Object[]{InetAddressUtils.str((InetAddress)routedest), InetAddressUtils.str((InetAddress)routemask), InetAddressUtils.str((InetAddress)nexthop)});
            if (linkd.saveRouteTable(snmpcoll.getPackageName())) {
                OnmsIpRouteInterface ipRouteInterface = route.getOnmsIpRouteInterface(new OnmsIpRouteInterface());
                if (ipRouteInterface != null) {
                    LOG.debug("processRouteTable: persisting {}", (Object)ipRouteInterface);
                    ipRouteInterface.setNode(onmsNode);
                    ipRouteInterface.setLastPollTime(scanTime);
                    ipRouteInterface.setStatus(OnmsArpInterface.StatusType.ACTIVE);
                    this.saveIpRouteInterface(ipRouteInterface);
                } else {
                    LOG.warn("processRouteTable: cannot persist routing table entry routedest/routemask/routenexthop {}/{}/{}", new Object[]{InetAddressUtils.str((InetAddress)routedest), InetAddressUtils.str((InetAddress)routemask), InetAddressUtils.str((InetAddress)nexthop)});
                }
            }
            if (nexthop == null) {
                LOG.warn("processRouteTable: next hop not found on node {}. Skipping.", (Object)node.getNodeId());
                continue;
            }
            if (nexthop.isLoopbackAddress()) {
                LOG.info("processRouteTable: next hop is a loopback address. Skipping.");
                continue;
            }
            if (m_zeroAddress.equals(nexthop)) {
                LOG.info("processRouteTable: next hop is a broadcast address. Skipping.");
                continue;
            }
            if (nexthop.isMulticastAddress()) {
                LOG.info("processRouteTable: next hop is a multicast address. Skipping.");
                continue;
            }
            if (!linkd.isInterfaceInPackage(nexthop, snmpcoll.getPackageName())) {
                LOG.info("processRouteTable: nexthop address {} is not in package {}. Skipping.", (Object)InetAddressUtils.str((InetAddress)nexthop), (Object)snmpcoll.getPackageName());
                continue;
            }
            if (routedest == null) {
                LOG.warn("processRouteTable: route destination not found on node {}. Skipping.", (Object)node.getNodeId());
                continue;
            }
            if (routemask == null) {
                LOG.warn("processRouteTable: route mask not found on node {}. Skipping.", (Object)node.getNodeId());
                continue;
            }
            if (routemask.getHostAddress().equals("255.255.255.255")) {
                LOG.warn("processRouteTable: route mask 255.255.255.255 on node {}. Skipping.", (Object)node.getNodeId());
                continue;
            }
            Integer ifindex = route.getIpRouteIfIndex();
            if (ifindex == null) {
                LOG.warn("processRouteTable: Invalid ifIndex {} on node {}. Skipping.", (Object)ifindex, (Object)node.getNodeId());
                continue;
            }
            Integer routemetric1 = route.getIpRouteMetric1();
            if (routemetric1 == null || routemetric1 == -1) {
                LOG.info("processRouteTable: Route metric1 is invalid or \" not used\". checking the route status.");
                Integer routestatus = route.getIpRouteStatus();
                if (routestatus != null && routestatus != 1) {
                    LOG.info("processRouteTable: Route status {} is not active. Skipping", (Object)routestatus);
                    continue;
                }
            }
            LOG.debug("processRouteTable: parsing routeDest/routeMask/nextHop: {}/{}/{} - ifIndex = {}", new Object[]{InetAddressUtils.str((InetAddress)routedest), InetAddressUtils.str((InetAddress)routemask), InetAddressUtils.str((InetAddress)nexthop), ifindex});
            int snmpiftype = -2;
            if (ifindex == 0) {
                LOG.debug("processRouteTable: ifindex is 0. Looking local table to get a valid index.");
                for (OnmsIpInterface ip : this.m_ipInterfaceDao.findByNodeId(Integer.valueOf(node.getNodeId()))) {
                    InetAddress ipaddr = ip.getIpAddress();
                    InetAddress netmask = ip.getSnmpInterface().getNetMask();
                    LOG.debug("processRouteTable: parsing ip {} with netmask {}.", (Object)InetAddressUtils.str((InetAddress)ipaddr), (Object)InetAddressUtils.str((InetAddress)netmask));
                    InetAddress net1 = Linkd.getNetwork(ip.getIpAddress(), netmask);
                    LOG.debug("processRouteTable: found network {}.", (Object)InetAddressUtils.str((InetAddress)net1));
                    LOG.debug("processRouteTable: getting network for nexthop {} with netmask {}.", (Object)InetAddressUtils.str((InetAddress)nexthop), (Object)InetAddressUtils.str((InetAddress)netmask));
                    InetAddress net2 = Linkd.getNetwork(nexthop, netmask);
                    LOG.debug("processRouteTable: found network {}.", (Object)InetAddressUtils.str((InetAddress)net2));
                    if (!InetAddressUtils.str((InetAddress)net1).equals(InetAddressUtils.str((InetAddress)net2))) continue;
                    ifindex = ip.getIfIndex();
                    LOG.debug("processRouteTable: ifindex {} found for local ip {}. ", (Object)ifindex, (Object)InetAddressUtils.str((InetAddress)ip.getIpAddress()));
                    break;
                }
            }
            if (ifindex > 0) {
                snmpiftype = this.getSnmpIfType(node.getNodeId(), ifindex);
            }
            if (snmpiftype <= 0) {
                LOG.warn("processRouteTable: interface has an invalid ifType ({}).", (Object)snmpiftype);
            }
            if (linkd.forceIpRoutediscoveryOnEthernet(snmpcoll.getPackageName())) {
                LOG.debug("processRouteTable: forceIpRoutediscoveryOnEthernet is true, no validation for SNMP interface type");
            } else {
                LOG.debug("processRouteTable: forceIpRoutediscoveryOnEthernet is false, checking SNMP interface type");
                if (snmpiftype == 6) {
                    LOG.debug("run: Ethernet interface for nexthop {}. Skipping.", (Object)nexthop);
                    continue;
                }
                if (snmpiftype == 53) {
                    LOG.debug("run: PropVirtual interface for nodeid {}. Skipping.", (Object)nexthop);
                    continue;
                }
                if (snmpiftype == 135) {
                    LOG.debug("run: Layer2 VLAN interface for nodeid {}. Skipping.", (Object)nexthop);
                    continue;
                }
                if (snmpiftype == 136) {
                    LOG.debug("run: Layer3 VLAN interface for nodeid {}. Skipping.", (Object)nexthop);
                    continue;
                }
            }
            List<RouterInterface> routeIfaces = this.getRouteInterface(nexthop, ifindex);
            if (routeIfaces.isEmpty()) {
                LOG.info("processRouteTable: No node ID found for next hop IP address {}. Not adding the IP route interface to the linkable SNMP node.", (Object)InetAddressUtils.str((InetAddress)nexthop));
                this.sendNewSuspectEvent(nexthop, snmpcoll.getTarget(), snmpcoll.getPackageName(), linkd);
                continue;
            }
            for (RouterInterface routeIface : routeIfaces) {
                if (node.getNodeId() == routeIface.getNextHopNodeid()) {
                    LOG.debug("processRouteTable: node for IP next hop address {} is itself. Skipping.", (Object)InetAddressUtils.str((InetAddress)nexthop));
                    continue;
                }
                routeInterfaces.add(routeIface);
            }
        }
        node.setRouteInterfaces(routeInterfaces);
    }

    protected void processVlanTable(OnmsNode onmsNode, LinkableNode node, SnmpCollection snmpcoll, Date scanTime) {
        if (LOG.isDebugEnabled()) {
            if (snmpcoll.getVlanTable().size() > 0) {
                LOG.debug("processVlanTable: Starting VLAN table processing for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            } else {
                LOG.debug("processVlanTable: Zero VLAN table entries for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            }
        }
        ArrayList<OnmsVlan> vlans = new ArrayList<OnmsVlan>();
        for (SnmpStore ente : snmpcoll.getVlanTable()) {
            Vlan ent = (Vlan)ente;
            OnmsVlan vlan = ent.getOnmsVlan();
            vlan.setLastPollTime(scanTime);
            vlan.setNode(onmsNode);
            vlan.setStatus(OnmsArpInterface.StatusType.ACTIVE);
            vlans.add(vlan);
            LOG.debug("processVlanTable: Saving VLAN entry: {}", (Object)vlan);
            this.saveVlan(vlan);
        }
    }

    protected void storeSnmpVlanCollection(OnmsNode onmsNode, LinkableNode node, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl, Date scanTime, Linkd linkd) {
        if (!snmpVlanColl.hasDot1dBase()) {
            LOG.debug("storeSnmpVlanCollection: No Bridge MIB informations found for Vlan: {}. Skipping...", (Object)vlan.getVlanName());
            return;
        }
        LOG.debug("storeSnmpVlanCollection: Starting Bridge MIB processing for Vlan: {}.", (Object)vlan.getVlanName());
        this.processDot1dBaseAndDot1dStp(onmsNode, node, vlan, snmpVlanColl, scanTime, linkd);
        if (snmpVlanColl.hasDot1dBasePortTable()) {
            this.processDot1dBasePortAndStpPortTables(onmsNode, node, vlan, snmpVlanColl, scanTime, linkd);
        }
        if (snmpVlanColl.hasDot1dTpFdbTable()) {
            this.processDot1DTpFdbTable(node, vlan, snmpVlanColl, scanTime);
        }
        if (snmpVlanColl.hasQBridgeDot1dTpFdbTable()) {
            this.processQBridgeDot1dTpFdbTable(node, vlan, snmpVlanColl);
        }
    }

    private void processDot1dBasePortAndStpPortTables(OnmsNode onmsNode, LinkableNode node, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl, Date scanTime, Linkd linkd) {
        Map<Integer, OnmsStpInterface> stpinterfaces = new TreeMap<Integer, OnmsStpInterface>();
        stpinterfaces = this.processDot1DBasePortTable(onmsNode, node, scanTime, vlan, snmpVlanColl, stpinterfaces);
        if (snmpVlanColl.hasDot1dStpPortTable()) {
            stpinterfaces = this.processDot1StpPortTable(node, scanTime, vlan, snmpVlanColl, stpinterfaces);
        }
        if (linkd.saveStpInterfaceTable(snmpVlanColl.getPackageName())) {
            for (OnmsStpInterface stpInterface : stpinterfaces.values()) {
                LOG.debug("processDot1dBasePortAndStpPortTables: saving {} in stpinterface table", (Object)stpInterface);
                this.saveStpInterface(stpInterface);
            }
        }
        for (OnmsStpInterface stpInterface : stpinterfaces.values()) {
            if (stpInterface.getStpPortDesignatedBridge() == null) continue;
            if (stpInterface.getStpPortDesignatedBridge().substring(5, 16).equals(snmpVlanColl.getDot1dBase().getBridgeAddress())) {
                LOG.debug("processDot1dBasePortAndStpPortTables: portdesignatedBridge is bridge itself {}. Nothing to add to linkable node ", (Object)snmpVlanColl.getDot1dBase().getBridgeAddress());
                continue;
            }
            LOG.debug("processDot1dBasePortAndStpPortTables: portdesignatedBridge/port {}/{} added to linkable node skipped", (Object)stpInterface.getStpPortDesignatedBridge(), (Object)stpInterface.getBridgePort());
            node.addStpInterface(stpInterface);
        }
    }

    private void processDot1dBaseAndDot1dStp(OnmsNode onmsNode, LinkableNode node, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl, Date scanTime, Linkd linkd) {
        String baseBridgeAddress = snmpVlanColl.getDot1dBase().getBridgeAddress();
        if (baseBridgeAddress == null) {
            LOG.info("processDot1dBaseAndDot1dStp: Invalid base bridge address ({}) on node/vlan {}/{}", new Object[]{baseBridgeAddress, node.getNodeId(), vlan.getId()});
            return;
        }
        LOG.debug("processDot1dBaseAndDot1dStp: Found Bridge Identifier {} for Vlan {}.", (Object)baseBridgeAddress, (Object)vlan.getVlanId());
        node.addBridgeIdentifier(baseBridgeAddress, vlan.getVlanId());
        if (snmpVlanColl.hasDot1dStp()) {
            LOG.debug("processDot1dBaseAndDot1dStp: processing Dot1dStpGroup in stpnode");
            String stpDesignatedRoot = snmpVlanColl.getDot1dStp().getStpDesignatedRoot();
            if (stpDesignatedRoot != null) {
                LOG.debug("processDot1dBaseAndDot1dStp: Dot1dStpGroup found valid stpDesignatedRoot {}, adding to Linkable node", (Object)stpDesignatedRoot);
                node.setVlanStpRoot(vlan.getVlanId(), stpDesignatedRoot);
            }
        }
        if (linkd.saveStpNodeTable(snmpVlanColl.getPackageName())) {
            this.saveStpNode(this.getOnmsStpNode(onmsNode, node, scanTime, vlan, snmpVlanColl));
        }
    }

    protected void processQBridgeDot1dTpFdbTable(LinkableNode node, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl) {
        if (LOG.isDebugEnabled()) {
            if (snmpVlanColl.getQBridgeDot1dFdbTable().size() > 0) {
                LOG.debug("processQBridgeDot1dTpFdbTable: Starting Q-BRIDGE-MIB dot1dTpFdb table processing for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            } else {
                LOG.debug("processQBridgeDot1dTpFdbTable: Zero Q-BRIDGE-MIB dot1dTpFdb table entries for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            }
        }
        for (QBridgeDot1dTpFdbTableEntry dot1dfdbentry : snmpVlanColl.getQBridgeDot1dFdbTable()) {
            String curMacAddress = dot1dfdbentry.getQBridgeDot1dTpFdbAddress();
            if (curMacAddress == null || curMacAddress.equals("000000000000")) {
                LOG.info("processQBridgeDot1DTpFdbTable: Invalid MAC addres {} on node {}. Skipping.", (Object)curMacAddress, (Object)node.getNodeId());
                continue;
            }
            LOG.debug("processQBridgeDot1DTpFdbTable: Found MAC address {} on node {}", (Object)curMacAddress, (Object)node.getNodeId());
            int fdbport = dot1dfdbentry.getQBridgeDot1dTpFdbPort();
            if (fdbport == -1) {
                LOG.debug("processQBridgeDot1DTpFdbTable: Invalid FDB port ({}) for MAC address {} on node {}. Skipping.", new Object[]{fdbport, curMacAddress, node.getNodeId()});
                continue;
            }
            if (fdbport == 0) {
                LOG.debug("processQBridgeDot1DTpFdbTable: FDB port ({}) for MAC address {} on node {}. Saving generic port.", new Object[]{fdbport, curMacAddress, node.getNodeId()});
            }
            LOG.debug("processQBridgeDot1DTpFdbTable: Found bridge port {} on node {}.", (Object)fdbport, (Object)node.getNodeId());
            int curfdbstatus = dot1dfdbentry.getQBridgeDot1dTpFdbStatus();
            if (curfdbstatus == 3) {
                node.addBridgeForwardingTableEntry(fdbport, curMacAddress);
                LOG.debug("processQBridgeDot1DTpFdbTable: Found learned status on bridge port.");
                continue;
            }
            if (curfdbstatus == 4) {
                Integer ifIndex = node.getIfindexFromBridgePort(fdbport);
                if (ifIndex == null) {
                    ifIndex = -1;
                }
                node.getMacIdentifiers().put(ifIndex, curMacAddress);
                LOG.debug("processQBridgeDot1DTpFdbTable: MAC address ({}) is used as port identifier.", (Object)curMacAddress);
                continue;
            }
            if (curfdbstatus == 2) {
                LOG.debug("processQBridgeDot1DTpFdbTable: Found 'INVALID' status. Skipping.");
                continue;
            }
            if (curfdbstatus == 5) {
                node.addBridgeForwardingTableEntry(fdbport, curMacAddress);
                LOG.debug("processQBridgeDot1DTpFdbTable: Found 'MGMT' status. Saving.");
                continue;
            }
            if (curfdbstatus == 1) {
                node.addBridgeForwardingTableEntry(fdbport, curMacAddress);
                LOG.debug("processQBridgeDot1DTpFdbTable: Found 'OTHER' status. Saving.");
                continue;
            }
            if (curfdbstatus != -1) continue;
            LOG.warn("processQBridgeDot1DTpFdbTable: Unable to determine status. Skipping.");
        }
    }

    protected void processDot1DTpFdbTable(LinkableNode node, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl, Date scanTime) {
        if (LOG.isDebugEnabled()) {
            if (snmpVlanColl.getDot1dFdbTable().size() > 0) {
                LOG.debug("processDot1DTpFdbTable: Starting dot1dTpFdb table processing for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            } else {
                LOG.debug("processDot1DTpFdbTable: Zero dot1dTpFdb table entries for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            }
        }
        for (Dot1dTpFdbTableEntry dot1dfdbentry : snmpVlanColl.getDot1dFdbTable()) {
            String curMacAddress = dot1dfdbentry.getDot1dTpFdbAddress();
            int fdbport = dot1dfdbentry.getDot1dTpFdbPort();
            int curfdbstatus = dot1dfdbentry.getDot1dTpFdbStatus();
            if (curMacAddress == null || curMacAddress.equals("000000000000")) {
                LOG.info("processDot1DTpFdbTable: Invalid MAC address {} on node {}. Skipping.", (Object)curMacAddress, (Object)node.getNodeId());
                continue;
            }
            LOG.debug("processDot1DTpFdbTable: Found valid MAC address {} on node {}", (Object)curMacAddress, (Object)node.getNodeId());
            if (fdbport == 0 || fdbport == -1) {
                LOG.debug("processDot1DTpFdbTable: Invalid FDB port ({}) for MAC address {} on node {}. Skipping.", new Object[]{fdbport, curMacAddress, node.getNodeId()});
                continue;
            }
            LOG.debug("processDot1DTpFdbTable: MAC address ({}) found on bridge port {} on node {}", new Object[]{curMacAddress, fdbport, node.getNodeId()});
            if (curfdbstatus == 3 && vlan.getVlanId() != null) {
                node.addBridgeForwardingTableEntry(fdbport, curMacAddress);
                LOG.debug("processDot1DTpFdbTable: Found learned status on bridge port.");
                continue;
            }
            if (curfdbstatus == 4) {
                Integer ifIndex = node.getIfindexFromBridgePort(fdbport);
                if (ifIndex == null) {
                    ifIndex = -1;
                }
                node.getMacIdentifiers().put(ifIndex, curMacAddress);
                LOG.debug("processDot1DTpFdbTable: MAC address ({}) is used as port identifier.", (Object)curMacAddress);
                continue;
            }
            if (curfdbstatus == 2) {
                LOG.debug("processDot1DTpFdbTable: Found 'INVALID' status. Skipping.");
                continue;
            }
            if (curfdbstatus == 5) {
                node.addBridgeForwardingTableEntry(fdbport, curMacAddress);
                LOG.debug("processDot1DTpFdbTable: Found 'MGMT' status. Saving.");
                continue;
            }
            if (curfdbstatus == 1) {
                node.addBridgeForwardingTableEntry(fdbport, curMacAddress);
                LOG.debug("processDot1DTpFdbTable: Found 'OTHER' status. Saving.");
                continue;
            }
            if (curfdbstatus != -1) continue;
            LOG.warn("processDot1DTpFdbTable: Unable to determine status. Skipping.");
        }
    }

    protected Map<Integer, OnmsStpInterface> processDot1StpPortTable(LinkableNode node, Date scanTime, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl, Map<Integer, OnmsStpInterface> stpinterfaces) {
        if (LOG.isDebugEnabled()) {
            if (snmpVlanColl.getDot1dStpPortTable().size() > 0) {
                LOG.debug("processDot1StpPortTable: Processing dot1StpPortTable for nodeid/ip for {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            } else {
                LOG.debug("processDot1StpPortTable: Zero dot1StpPort table entries for nodeid/ip {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            }
        }
        for (Dot1dStpPortTableEntry dot1dstpptentry : snmpVlanColl.getDot1dStpPortTable()) {
            Integer stpport = dot1dstpptentry.getDot1dStpPort();
            if (stpport == null || stpinterfaces.get(stpport) == null) {
                LOG.info("processDot1StpPortTable: Found invalid bridge port. Skipping.");
                continue;
            }
            OnmsStpInterface stpInterface = dot1dstpptentry.getOnmsStpInterface(stpinterfaces.get(stpport));
            LOG.debug("processDot1StpPortTable: found stpport/designatedbridge/designatedport {}/{}/{}", new Object[]{stpport, stpInterface.getStpPortDesignatedBridge(), stpInterface.getStpPortDesignatedPort()});
        }
        return stpinterfaces;
    }

    protected Map<Integer, OnmsStpInterface> processDot1DBasePortTable(OnmsNode onmsNode, LinkableNode node, Date scanTime, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl, Map<Integer, OnmsStpInterface> stpinterfaces) {
        if (LOG.isDebugEnabled()) {
            if (snmpVlanColl.getDot1dBasePortTable().size() > 0) {
                LOG.debug("processDot1DBasePortTable: Processing dot1BasePortTable for nodeid/ip {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            } else {
                LOG.debug("processDot1DBasePortTable: Zero dot1BasePort table entries for nodeid/ip {}/{}", (Object)node.getNodeId(), (Object)InetAddressUtils.str((InetAddress)node.getSnmpPrimaryIpAddr()));
            }
        }
        for (Dot1dBasePortTableEntry dot1dbaseptentry : snmpVlanColl.getDot1dBasePortTable()) {
            int baseport = dot1dbaseptentry.getBaseBridgePort();
            int ifindex = dot1dbaseptentry.getBaseBridgePortIfindex();
            LOG.debug("processDot1DBasePortTable: processing bridge port ({}) with ifIndex ({}).", (Object)baseport, (Object)ifindex);
            if (baseport == -1 || ifindex == -1) {
                LOG.info("processDot1DBasePortTable: Invalid base port ({}) or ifIndex ({}). Skipping.", (Object)baseport, (Object)ifindex);
                continue;
            }
            node.setIfIndexBridgePort(Integer.valueOf(ifindex), Integer.valueOf(baseport));
            OnmsStpInterface stpInterface = new OnmsStpInterface(onmsNode, Integer.valueOf(baseport), vlan.getVlanId());
            stpInterface.setBridgePort(Integer.valueOf(baseport));
            stpInterface.setVlan(vlan.getVlanId());
            stpInterface.setIfIndex(Integer.valueOf(ifindex));
            stpInterface.setStatus(OnmsArpInterface.StatusType.ACTIVE);
            stpInterface.setLastPollTime(scanTime);
            stpinterfaces.put(baseport, stpInterface);
        }
        return stpinterfaces;
    }

    protected OnmsStpNode getOnmsStpNode(OnmsNode onmsNode, LinkableNode node, Date scanTime, OnmsVlan vlan, SnmpVlanCollection snmpVlanColl) {
        LOG.debug("getOnmsStpNode: Starting stpnode processing for Vlan: {}", (Object)vlan.getVlanName());
        LOG.debug("getOnmsStpNode: processing Dot1dBaseGroup in stpnode");
        OnmsStpNode stpNode = new OnmsStpNode(onmsNode, vlan.getVlanId());
        stpNode = snmpVlanColl.getDot1dBase().getOnmsStpNode(stpNode);
        stpNode.setLastPollTime(scanTime);
        stpNode.setStatus(OnmsArpInterface.StatusType.ACTIVE);
        stpNode.setBaseVlanName(vlan.getVlanName());
        if (snmpVlanColl.hasDot1dStp()) {
            LOG.debug("getOnmsStpNode: processing Dot1dStpGroup in stpnode");
            stpNode = snmpVlanColl.getDot1dStp().getOnmsStpNode(stpNode);
            if (stpNode.getStpDesignatedRoot() == null) {
                LOG.debug("getOnmsStpNode: Dot1dStpGroup found stpDesignatedRoot null, not adding to Linkable node");
                stpNode.setStpDesignatedRoot("0000000000000000");
            }
            LOG.debug("getOnmsStpNode: stpDesignatedRoot = {}", (Object)stpNode.getStpDesignatedRoot());
        }
        return stpNode;
    }
}

