/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.linkd.EventUtils;
import org.opennms.netmgt.linkd.InsufficientInformationException;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.xml.event.Event;

@EventListener(name="linkd")
public final class EventProcessor {
    private Linkd m_linkd;

    public void setLinkd(Linkd linkd) {
        this.m_linkd = linkd;
    }

    public Linkd getLinkd() {
        return this.m_linkd;
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void handleNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_linkd.deleteNode(event.getNodeid().intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceDeleted")
    public void handleInterfaceDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterfaceOrIfIndex(event);
        int ifIndex = -1;
        if (event.hasIfIndex()) {
            ifIndex = event.getIfIndex();
        }
        this.m_linkd.deleteInterface(event.getNodeid().intValue(), event.getInterface(), ifIndex);
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeGainedService")
    public void handleNodeGainedService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_linkd.scheduleNodeCollection(event.getNodeid().intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeLostService")
    public void handleNodeLostService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_linkd.suspendNodeCollection(event.getNodeid().intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeRegainedService")
    public void handleRegainedService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_linkd.wakeUpNodeCollection(event.getNodeid().intValue());
    }
}

