/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.snmp.LldpRemTableTracker;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LldpLocPortGetter
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(LldpLocPortGetter.class);
    public static final SnmpObjId LLDP_LOC_PORTID_SUBTYPE = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.2");
    public static final SnmpObjId LLDP_LOC_PORTID = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.3");
    public static final SnmpObjId LLDP_LOC_DESCR = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.4");
    private SnmpAgentConfig m_agentConfig;

    public LldpLocPortGetter(SnmpAgentConfig peer) {
        super(new SnmpObjId[0]);
        this.m_agentConfig = peer;
    }

    public LldpLink get(Integer lldpRemLocalPortNum) {
        SnmpObjId instance = SnmpObjId.get((String)lldpRemLocalPortNum.toString());
        SnmpObjId[] oids = new SnmpObjId[]{SnmpObjId.get((SnmpObjId)LLDP_LOC_PORTID_SUBTYPE, (SnmpObjId)instance), SnmpObjId.get((SnmpObjId)LLDP_LOC_PORTID, (SnmpObjId)instance), SnmpObjId.get((SnmpObjId)LLDP_LOC_DESCR, (SnmpObjId)instance)};
        SnmpValue[] val = SnmpUtils.get((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId[])oids);
        LldpLink lldplink = new LldpLink();
        lldplink.setLldpLocalPortNum(lldpRemLocalPortNum);
        if (val == null || val.length != 3) {
            LOG.warn("get: cannot find local instance for lldp local port number {}", (Object)lldpRemLocalPortNum);
            LOG.warn("get: setting default not found Values: portidtype \"InterfaceAlias\", portid=\"Not Found On lldpLocPortTable\"");
            lldplink.setLldpPortIdSubType(LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACEALIAS);
            lldplink.setLldpPortId("\"Not Found On lldpLocPortTable\"");
            lldplink.setLldpPortDescr("");
            return lldplink;
        }
        if (val[0] == null || val[0].isError() || !val[0].isNumeric()) {
            LOG.warn("get: port id subtype is null or invalid for lldp local port number {}", (Object)lldpRemLocalPortNum);
            LOG.warn("get: setting default not found Values: portidtype \"InterfaceAlias\"");
            lldplink.setLldpPortIdSubType(LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACEALIAS);
        } else {
            lldplink.setLldpPortIdSubType(LldpUtils.LldpPortIdSubType.get((Integer)val[0].toInt()));
        }
        if (val[1] == null || val[1].isError()) {
            LOG.warn("get: port id is null for lldp local port number {}", (Object)lldpRemLocalPortNum);
            LOG.warn("get: setting default not found Values: portid=\"Not Found On lldpLocPortTable\"");
            lldplink.setLldpPortId("\"Not Found On lldpLocPortTable\"");
        } else {
            lldplink.setLldpPortId(LldpRemTableTracker.decodeLldpPortId(lldplink.getLldpPortIdSubType().getValue(), val[1]));
        }
        if (val[2] != null && !val[2].isError()) {
            lldplink.setLldpPortDescr(val[2].toDisplayString());
        } else {
            lldplink.setLldpPortDescr("");
        }
        if (val[0].isNumeric() && val[0].toInt() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL.getValue().intValue()) {
            try {
                lldplink.setLldpPortIfindex(Integer.valueOf(val[1].toInt()));
            }
            catch (Exception e) {
                LOG.debug("get: failed to convert to ifindex local port id {}", (Object)val[1]);
            }
        }
        return lldplink;
    }
}

