/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CdpGlobalGroupTracker
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(CdpGlobalGroupTracker.class);
    public static final String CDP_GLOBAL_RUN = "cdpGlobalRun";
    public static final String CDP_GLOBAL_DEVICEID = "cdpGlobalDeviceId";
    public static final NamedSnmpVar[] ms_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "cdpGlobalRun", ".1.3.6.1.4.1.9.9.23.1.3.1"), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "cdpGlobalDeviceId", ".1.3.6.1.4.1.9.9.23.1.3.4")};
    private SnmpStore m_store = new SnmpStore(ms_elemList);

    public CdpGlobalGroupTracker() {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving systemGroup: {}", (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving systemGroup: {}", (Object)msg);
    }

    public String getCdpDeviceId() {
        return this.m_store.getDisplayString(CDP_GLOBAL_DEVICEID);
    }

    public Integer getCdpGlobalRun() {
        return this.m_store.getInt32(CDP_GLOBAL_RUN);
    }

    public CdpElement getCdpElement() {
        CdpElement cdpElement = new CdpElement();
        cdpElement.setCdpGlobalRun(OspfElement.TruthValue.get((Integer)this.getCdpGlobalRun()));
        cdpElement.setCdpGlobalDeviceId(this.getCdpDeviceId());
        return cdpElement;
    }
}

