/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.jmx.connectors;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class IsolatingClassLoader
extends URLClassLoader {
    private String[] m_isolatedPrefixes;
    private Set<String> m_isolatedClassNames = new HashSet<String>();

    public IsolatingClassLoader(String name, URL[] classpath, String[] isolated, boolean augmentClassPath) throws InvalidContextClassLoaderException {
        super(classpath);
        this.init(name, isolated, augmentClassPath);
    }

    public IsolatingClassLoader(String name, URL[] classpath, ClassLoader parent, String[] isolated, boolean augmentClassPath) throws InvalidContextClassLoaderException {
        super(classpath, parent);
        this.init(name, isolated, augmentClassPath);
    }

    private void init(String name, String[] isolated, boolean augmentClassPath) throws InvalidContextClassLoaderException {
        HashSet<String> prefixes = new HashSet<String>();
        for (int i = 0; i < isolated.length; ++i) {
            int index = isolated[i].indexOf(42);
            if (index >= 0) {
                prefixes.add(isolated[i].substring(0, index));
                continue;
            }
            this.m_isolatedClassNames.add(isolated[i]);
        }
        this.m_isolatedPrefixes = prefixes.toArray(new String[0]);
        if (augmentClassPath) {
            ClassLoader callerClassLoader = Thread.currentThread().getContextClassLoader();
            if (callerClassLoader instanceof URLClassLoader) {
                URL[] newURLs = ((URLClassLoader)callerClassLoader).getURLs();
                for (int i = 0; i < newURLs.length; ++i) {
                    this.addURL(newURLs[i]);
                }
            } else {
                throw new InvalidContextClassLoaderException("Caller classloader is not a URLClassLoader, can't automatically augument classpath.Its a " + callerClassLoader.getClass());
            }
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean isolated = this.m_isolatedClassNames.contains(name);
        if (!isolated) {
            for (int i = 0; i < this.m_isolatedPrefixes.length; ++i) {
                if (!name.startsWith(this.m_isolatedPrefixes[i])) continue;
                isolated = true;
                break;
            }
        }
        if (isolated) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        return super.loadClass(name, resolve);
    }

    public static class InvalidContextClassLoaderException
    extends Exception {
        private static final long serialVersionUID = -82741827583768184L;

        public InvalidContextClassLoaderException(String message) {
            super(message);
        }
    }
}

