/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.netmgt.config.xmlrpcd.SubscribedEvent;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BroadcastEventProcessor
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastEventProcessor.class);
    private final FifoQueue<Event> m_eventQ;
    private final int m_maxQSize;
    private final Set<String> m_events;
    private final String m_nameSuffix;

    BroadcastEventProcessor(String nameSuffix, FifoQueue<Event> eventQ, int maxQSize, List<SubscribedEvent> eventList) {
        this.m_nameSuffix = nameSuffix;
        ArrayList<String> ueiList = new ArrayList<String>();
        for (SubscribedEvent event : eventList) {
            ueiList.add(event.getUei());
        }
        this.m_eventQ = eventQ;
        this.m_maxQSize = maxQSize;
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this, ueiList);
        this.m_events = new HashSet<String>();
        this.m_events.addAll(ueiList);
    }

    public void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        String eventUei = event.getUei();
        if (eventUei == null) {
            return;
        }
        LOG.debug("Received event: {}", (Object)eventUei);
        try {
            if (this.m_events.contains(eventUei)) {
                if (this.m_eventQ.size() >= this.m_maxQSize) {
                    this.m_eventQ.remove(1000L);
                    LOG.debug("Event {} removed from event queue", (Object)eventUei);
                }
                this.m_eventQ.add((Object)event);
                LOG.debug("Event {} added to event queue", (Object)eventUei);
            }
        }
        catch (InterruptedException ex) {
            LOG.error("Failed to process event", (Throwable)ex);
            return;
        }
        catch (FifoQueueException ex) {
            LOG.error("Failed to process event", (Throwable)ex);
            return;
        }
        catch (Throwable t) {
            LOG.error("Failed to process event", t);
            return;
        }
    }

    public String getName() {
        return "Xmlrpcd:BroadcastEventProcessor_" + this.m_nameSuffix;
    }
}

