/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.scriptd.helper.EventForwarder;
import org.opennms.netmgt.scriptd.helper.EventSynchronization;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class AlarmEventSynchronization
implements EventSynchronization {
    List<EventForwarder> m_forwarders = new ArrayList<EventForwarder>();

    @Override
    public void addEventForwarder(EventForwarder forwarder) {
        if (forwarder != null) {
            this.m_forwarders.add(forwarder);
        }
    }

    @Override
    public void sync() {
        for (EventForwarder forwarder : this.m_forwarders) {
            forwarder.sendStartSync();
            for (Event event : this.getEvents()) {
                forwarder.flushSyncEvent(event);
            }
            forwarder.sendEndSync();
        }
    }

    private Event getXMLEvent(OnmsAlarm alarm) {
        Event event = new Event();
        event.setDbid(alarm.getLastEvent().getId());
        if (alarm.getUei() == null) {
            return null;
        }
        event.setUei(alarm.getUei());
        if (alarm.getLastEvent().getEventSource() != null) {
            event.setSource(alarm.getLastEvent().getEventSource());
        }
        if (alarm.getNode() != null) {
            event.setNodeid(Long.valueOf(alarm.getNode().getId().longValue()));
        }
        if (alarm.getFirstEventTime() != null) {
            event.setCreationTime(alarm.getFirstEventTime());
        }
        if (alarm.getLastEventTime() != null) {
            event.setTime(alarm.getLastEventTime());
        }
        if (alarm.getLastEvent().getEventHost() != null) {
            event.setHost(alarm.getLastEvent().getEventHost());
        }
        if (alarm.getIpAddr() != null) {
            event.setInterfaceAddress(alarm.getIpAddr());
        }
        if (alarm.getServiceType() != null) {
            event.setService(alarm.getServiceType().getName());
        }
        if (alarm.getDescription() != null) {
            event.setDescr(alarm.getDescription());
        }
        if (alarm.getLogMsg() != null) {
            Logmsg msg = new Logmsg();
            msg.setContent(alarm.getLogMsg());
            event.setLogmsg(msg);
        }
        if (alarm.getSeverity() != null) {
            event.setSeverity(alarm.getSeverity().getLabel());
        }
        if (alarm.getOperInstruct() != null) {
            event.setOperinstruct(alarm.getOperInstruct());
        }
        AlarmData ad = new AlarmData();
        ad.setReductionKey(alarm.getReductionKey());
        ad.setAlarmType(alarm.getAlarmType());
        if (alarm.getClearKey() != null) {
            ad.setClearKey(alarm.getClearKey());
        }
        event.setAlarmData(ad);
        return event;
    }

    @Override
    public List<Event> getEvents() {
        BeanFactoryReference bf = BeanUtils.getBeanFactory((String)"daoContext");
        final AlarmDao alarmDao = (AlarmDao)BeanUtils.getBean((BeanFactoryReference)bf, (String)"alarmDao", AlarmDao.class);
        final ArrayList<Event> xmlevents = new ArrayList<Event>();
        TransactionTemplate transTemplate = (TransactionTemplate)BeanUtils.getBean((BeanFactoryReference)bf, (String)"transactionTemplate", TransactionTemplate.class);
        try {
            transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus status) {
                    HashMap<String, OnmsAlarm> forwardAlarms = new HashMap<String, OnmsAlarm>();
                    for (OnmsAlarm alarm : alarmDao.findAll()) {
                        if (alarm.getAlarmType() == 2) {
                            if (forwardAlarms.containsKey(alarm.getClearKey())) {
                                OnmsAlarm raise = (OnmsAlarm)forwardAlarms.get(alarm.getClearKey());
                                if (!raise.getLastEventTime().before(alarm.getLastEventTime())) continue;
                                forwardAlarms.remove(alarm.getClearKey());
                                continue;
                            }
                            forwardAlarms.put(alarm.getClearKey(), alarm);
                            continue;
                        }
                        if (alarm.getAlarmType() == 1) {
                            if (forwardAlarms.containsKey(alarm.getReductionKey())) {
                                OnmsAlarm clear = (OnmsAlarm)forwardAlarms.get(alarm.getReductionKey());
                                if (!clear.getLastEventTime().before(alarm.getLastEventTime())) continue;
                                forwardAlarms.put(alarm.getReductionKey(), alarm);
                                continue;
                            }
                            forwardAlarms.put(alarm.getReductionKey(), alarm);
                            continue;
                        }
                        forwardAlarms.put(alarm.getReductionKey(), alarm);
                    }
                    for (OnmsAlarm alarm : forwardAlarms.values()) {
                        Event xmlEvent;
                        if (alarm.getAlarmType() == 2 || (xmlEvent = AlarmEventSynchronization.this.getXMLEvent(alarm)) == null) continue;
                        xmlevents.add(xmlEvent);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        return xmlevents;
    }
}

