/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.RTCConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.rtc.BroadcastEventProcessor;
import org.opennms.netmgt.rtc.DataManager;
import org.opennms.netmgt.rtc.DataSender;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RTCManager
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(RTCManager.class);
    private static final RTCManager m_singleton = new RTCManager();
    private static final String LOWT_TASK = "lowTtask";
    private static final String HIGHT_TASK = "highTtask";
    private static final String USERTIMER = "userTimer";
    private static final int NUM_UPDATERS = 5;
    private static long m_rollingWindow = -1L;
    private Timer m_timer;
    private TimerTask m_lowTtask;
    private long m_lowThresholdInterval = -1L;
    private TimerTask m_highTtask;
    private long m_highThresholdInterval = -1L;
    private TimerTask m_userTask;
    private long m_userRefreshInterval = -1L;
    private int m_counter = -1;
    private int MAX_EVENTS_BEFORE_RESEND = -1;
    private BroadcastEventProcessor m_eventReceiver;
    private ExecutorService m_updaterPool;
    private DataSender m_dataSender;
    private static DataManager m_dataMgr;

    private Logger log() {
        return LOG;
    }

    private synchronized void timerTaskComplete(RTCTimerTask tt) {
        LOG.debug("TimerTask '{}' complete, status: {}", (Object)tt.getID(), (Object)this.getStatus());
        if (tt.getID().equals(LOWT_TASK)) {
            boolean ret = this.m_userTask.cancel();
            LOG.debug("timerTaskComplete: {} cancelled: {}", (Object)USERTIMER, (Object)ret);
            if (this.m_highTtask != null) {
                ret = this.m_highTtask.cancel();
                LOG.debug("timerTaskComplete: {} cancelled: {}", (Object)HIGHT_TASK, (Object)ret);
                this.m_highTtask = null;
            }
            if (this.isRunning()) {
                this.m_dataSender.notifyToSend();
            }
            this.m_lowTtask = null;
            this.m_counter = -1;
            this.m_userTask = new RTCTimerTask(USERTIMER);
            this.m_timer.schedule(this.m_userTask, 0L, this.m_userRefreshInterval);
            LOG.debug("timerTaskComplete: {} scheduled", (Object)USERTIMER);
        } else if (tt.getID().equals(HIGHT_TASK)) {
            boolean ret = this.m_userTask.cancel();
            LOG.debug("timerTaskComplete: {} cancelled: {}", (Object)USERTIMER, (Object)ret);
            if (this.m_lowTtask != null) {
                ret = this.m_lowTtask.cancel();
                LOG.debug("timerTaskComplete: {} cancelled: {}", (Object)LOWT_TASK, (Object)ret);
                this.m_lowTtask = null;
            }
            if (this.isRunning()) {
                this.m_dataSender.notifyToSend();
            }
            this.m_highTtask = null;
            this.m_counter = -1;
            this.m_userTask = new RTCTimerTask(USERTIMER);
            this.m_timer.schedule(this.m_userTask, 0L, this.m_userRefreshInterval);
            LOG.debug("timerTaskComplete: {} scheduled", (Object)USERTIMER);
        } else if (tt.getID().equals(USERTIMER) && this.isRunning()) {
            this.m_dataSender.notifyToSend();
        }
    }

    public RTCManager() {
        super("rtc");
        Logging.putPrefix((String)"rtc");
    }

    public synchronized void checkTimerTasksOnEventReceipt() {
        LOG.debug("checkTimerTasksOnEventReceipt: Checking if timer tasks need to be reset or data needs to be sent out");
        boolean ret = this.m_userTask.cancel();
        LOG.debug("checkTimerTasksOnEventReceipt: {} cancelled: {}", (Object)USERTIMER, (Object)ret);
        if (this.m_counter == -1) {
            this.m_counter = 0;
            if (this.m_lowTtask == null) {
                try {
                    this.m_lowTtask = new RTCTimerTask(LOWT_TASK);
                    this.m_timer.schedule(this.m_lowTtask, this.m_lowThresholdInterval);
                    LOG.debug("checkTimerTasksOnEventReceipt: {} scheduled", (Object)LOWT_TASK);
                }
                catch (IllegalStateException isE) {
                    LOG.error("checkTimerTasksOnEventReceipt: Illegal State adding new RTCTimerTask", (Throwable)isE);
                }
            }
            if (this.m_highTtask == null) {
                try {
                    this.m_highTtask = new RTCTimerTask(HIGHT_TASK);
                    this.m_timer.schedule(this.m_highTtask, this.m_highThresholdInterval);
                    LOG.debug("checkTimerTasksOnEventReceipt: {} scheduled", (Object)HIGHT_TASK);
                }
                catch (IllegalStateException isE) {
                    LOG.error("checkTimerTasksOnEventReceipt: Illegal State adding new RTCTimerTask", (Throwable)isE);
                }
            }
        }
        if (this.MAX_EVENTS_BEFORE_RESEND > 0 && this.m_counter >= this.MAX_EVENTS_BEFORE_RESEND) {
            LOG.debug("checkTimerTasksOnEventReceipt: max events before resend limit reached, resetting timers");
            if (this.m_lowTtask != null) {
                ret = this.m_lowTtask.cancel();
                LOG.debug("checkTimerTasksOnEventReceipt: {} cancelled: {}", (Object)LOWT_TASK, (Object)ret);
                this.m_lowTtask = null;
            }
            if (this.m_highTtask != null) {
                ret = this.m_highTtask.cancel();
                LOG.debug("checkTimerTasksOnEventReceipt: {} cancelled: {}", (Object)HIGHT_TASK, (Object)ret);
                this.m_highTtask = null;
            }
            LOG.debug("checkTimerTasksOnEventReceipt: max events before resend limit reached, sending data to listeners");
            this.m_dataSender.notifyToSend();
            LOG.debug("checkTimerTasksOnEventReceipt: max events before resend limit reached, datasender notified to send data");
            this.m_counter = -1;
        } else if (this.m_counter != 0) {
            if (this.m_lowTtask != null) {
                ret = this.m_lowTtask.cancel();
                LOG.debug("checkTimerTasksOnEventReceipt: {} cancelled: {}", (Object)LOWT_TASK, (Object)ret);
                this.m_lowTtask = null;
            }
            try {
                this.m_lowTtask = new RTCTimerTask(LOWT_TASK);
                this.m_timer.schedule(this.m_lowTtask, this.m_lowThresholdInterval);
                LOG.debug("checkTimerTasksOnEventReceipt: {} scheduled", (Object)LOWT_TASK);
            }
            catch (IllegalStateException isE) {
                LOG.error("checkTimerTasksOnEventReceipt: Illegal State adding new RTCTimerTask", (Throwable)isE);
            }
        }
    }

    public synchronized void resetUserTimer() {
        if (this.m_userTask != null) {
            return;
        }
        try {
            this.m_userTask = new RTCTimerTask(USERTIMER);
            this.m_timer.schedule(this.m_userTask, 0L, this.m_userRefreshInterval);
            LOG.debug("resetUserTimer: {} scheduled", (Object)USERTIMER);
        }
        catch (IllegalStateException isE) {
            LOG.error("dataReceived: Illegal State adding new RTCTimerTask", (Throwable)isE);
        }
    }

    protected synchronized void onInit() {
        RTCConfigFactory rFactory = null;
        try {
            RTCConfigFactory.reload();
            rFactory = RTCConfigFactory.getInstance();
        }
        catch (IOException ex) {
            this.log().error("Failed to load rtc configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (MarshalException ex) {
            this.log().error("Failed to load rtc configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error("Failed to load rtc configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        m_rollingWindow = rFactory.getRollingWindow();
        this.MAX_EVENTS_BEFORE_RESEND = rFactory.getMaxEventsBeforeResend();
        this.m_lowThresholdInterval = rFactory.getLowThresholdInterval();
        this.m_highThresholdInterval = rFactory.getHighThresholdInterval();
        String ur = rFactory.getUserRefreshIntervalStr();
        if (ur != null) {
            try {
                this.m_userRefreshInterval = rFactory.getUserRefreshInterval();
            }
            catch (Throwable nfE) {
                this.log().warn("User refresh time has an incorrect format - using 1 minute instead");
                this.m_userRefreshInterval = 60000L;
            }
        } else {
            this.log().warn("User refresh time not specified - using 1 minute instead");
            this.m_userRefreshInterval = 60000L;
        }
        if (this.m_highThresholdInterval == this.m_lowThresholdInterval) {
            throw new RuntimeException("The values for the high and low threshold intervals CANNOT BE EQUAL");
        }
        if (this.m_highThresholdInterval < this.m_lowThresholdInterval) {
            this.log().warn("Swapping high and low threshold intervals..");
            long tmp = this.m_highThresholdInterval;
            this.m_highThresholdInterval = this.m_lowThresholdInterval;
            this.m_lowThresholdInterval = tmp;
        }
        this.log().info("Rolling Window: " + m_rollingWindow + "(milliseconds)");
        this.log().info("Low Threshold Refresh Interval: " + this.m_lowThresholdInterval + "(milliseconds)");
        this.log().info("High Threshold Refresh Interval: " + this.m_highThresholdInterval + "(milliseconds)");
        this.log().info("User Refresh Interval: " + this.m_userRefreshInterval + "(milliseconds)");
        try {
            m_dataMgr = new DataManager();
        }
        catch (Throwable ex) {
            throw new UndeclaredThrowableException(ex);
        }
        this.m_updaterPool = Executors.newFixedThreadPool(rFactory.getUpdaters(), (ThreadFactory)new LogPreservingThreadFactory(((Object)((Object)this)).getClass().getSimpleName(), rFactory.getUpdaters()));
        if (this.log().isDebugEnabled()) {
            this.log().debug("Created updater pool");
        }
        this.m_eventReceiver = new BroadcastEventProcessor(this.m_updaterPool);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Created event receiver");
        }
        this.m_dataSender = new DataSender(RTCManager.getCategories(), rFactory.getSenders());
        this.log().debug("Created DataSender");
        this.m_timer = new Timer();
        if (this.log().isDebugEnabled()) {
            this.log().debug("RTC ready to receive events");
        }
    }

    protected synchronized void onStart() {
        if (this.log().isDebugEnabled()) {
            this.log().debug("Starting data sender ");
        }
        this.m_dataSender.start();
        if (this.log().isDebugEnabled()) {
            this.log().debug("Updater threads and datasender started");
        }
        this.m_userTask = new RTCTimerTask(USERTIMER);
        this.m_timer.schedule(this.m_userTask, 0L, this.m_userRefreshInterval);
        if (this.log().isDebugEnabled()) {
            this.log().debug("userTimer scheduled");
        }
        try {
            this.m_eventReceiver.start();
        }
        catch (Throwable t) {
            this.m_dataSender.stop();
            if (this.log().isDebugEnabled()) {
                this.log().debug("DataSender shutdown");
            }
            this.m_updaterPool.shutdown();
            if (this.log().isDebugEnabled()) {
                this.log().debug("Updater pool shutdown");
            }
            this.m_timer.cancel();
            if (this.log().isDebugEnabled()) {
                this.log().debug("Timer cancelled");
            }
            throw new UndeclaredThrowableException(t);
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("RTC ready to receive events");
        }
    }

    protected synchronized void onStop() {
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug("Beginning shutdown process");
            }
            this.m_eventReceiver.close();
            if (this.log().isDebugEnabled()) {
                this.log().debug("Shutting down the data sender");
            }
            this.m_dataSender.stop();
            if (this.log().isDebugEnabled()) {
                this.log().debug("DataSender shutdown");
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("sending shutdown to updaters");
            }
            this.m_updaterPool.shutdown();
            if (this.log().isDebugEnabled()) {
                this.log().debug("RTC Updaters shutdown");
            }
            if (this.m_lowTtask != null) {
                this.m_lowTtask.cancel();
            }
            if (this.m_highTtask != null) {
                this.m_highTtask.cancel();
            }
            if (this.m_userTask != null) {
                this.m_userTask.cancel();
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("shutdown: Timer tasks Canceled");
            }
            this.m_timer.cancel();
            if (this.log().isDebugEnabled()) {
                this.log().debug("shutdown: Timer Canceled");
            }
        }
        catch (Throwable e) {
            this.log().error(e.getLocalizedMessage(), e);
        }
    }

    public synchronized void incrementCounter() {
        ++this.m_counter;
    }

    public DataSender getDataSender() {
        return this.m_dataSender;
    }

    public static Map<String, RTCCategory> getCategories() {
        return m_dataMgr.getCategories();
    }

    public static DataManager getDataManager() {
        return m_dataMgr;
    }

    public static void setDataManager(DataManager dataMgr) {
        m_dataMgr = dataMgr;
    }

    public static long getRollingWindow() {
        return m_rollingWindow;
    }

    public static RTCManager getInstance() {
        return m_singleton;
    }

    private class RTCTimerTask
    extends TimerTask {
        private String m_id;

        RTCTimerTask(String id) {
            this.m_id = id;
        }

        public String getID() {
            return this.m_id;
        }

        @Override
        public void run() {
            RTCManager.this.timerTaskComplete(this);
        }
    }
}

