/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.ssh;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.regex.Pattern;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.protocols.AbstractPoll;
import org.opennms.netmgt.protocols.InsufficientParametersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ssh
extends AbstractPoll {
    private static final Logger LOG = LoggerFactory.getLogger(Ssh.class);
    private static final Pattern SSH_IOEXCEPTION_PATTERN = Pattern.compile("^.*java.io.IOException.*$");
    private static final Pattern SSH_AUTHENTICATION_PATTERN = Pattern.compile("^.*Authentication:.*$");
    private static final Pattern SSH_NOROUTETOHOST_PATTERN = Pattern.compile("^.*java.net.NoRouteToHostException.*$");
    private static final Pattern SSH_SOCKETERROR_PATTERN = Pattern.compile("^.*(timeout: socket is not established|java.io.InterruptedIOException|java.net.SocketTimeoutException).*$");
    private static final Pattern SSH_CONNECTIONERROR_PATTERN = Pattern.compile("^.*(connection is closed by foreign host|java.net.ConnectException).*$");
    private static final Pattern SSH_NUMBERFORMAT_PATTERN = Pattern.compile("^.*NumberFormatException.*$");
    public static final int DEFAULT_PORT = 22;
    public static final String DEFAULT_CLIENT_BANNER = "SSH-1.99-OpenNMS_1.5";
    protected int m_port = 22;
    protected String m_username;
    protected String m_password;
    protected String m_banner = "SSH-1.99-OpenNMS_1.5";
    protected String m_serverBanner = "";
    protected InetAddress m_address;
    protected Throwable m_error;
    private Socket m_socket = null;
    private BufferedReader m_reader = null;
    private OutputStream m_writer = null;

    public Ssh() {
    }

    public Ssh(InetAddress address) {
        this.setAddress(address);
    }

    public Ssh(InetAddress address, int port) {
        this.setAddress(address);
        this.setPort(port);
    }

    public Ssh(InetAddress address, int port, int timeout) {
        this.setAddress(address);
        this.setPort(port);
        this.setTimeout(timeout);
    }

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        if (this.m_port == 0) {
            return 22;
        }
        return this.m_port;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setClientBanner(String banner) {
        this.m_banner = banner;
    }

    public String getClientBanner() {
        return this.m_banner;
    }

    public String getServerBanner() {
        return this.m_serverBanner;
    }

    protected void setError(Throwable t) {
        this.m_error = t;
    }

    protected Throwable getError() {
        return this.m_error;
    }

    protected boolean tryConnect() throws InsufficientParametersException {
        if (this.getAddress() == null) {
            throw new InsufficientParametersException("you must specify an address");
        }
        try {
            this.m_socket = new Socket();
            this.m_socket.setTcpNoDelay(true);
            this.m_socket.connect(new InetSocketAddress(this.getAddress(), this.getPort()), this.getTimeout());
            this.m_socket.setSoTimeout(this.getTimeout());
            this.m_reader = new BufferedReader(new InputStreamReader(this.m_socket.getInputStream()));
            this.m_writer = this.m_socket.getOutputStream();
            this.m_serverBanner = this.m_reader.readLine();
            this.m_writer.write((this.getClientBanner() + "\r\n").getBytes());
            this.disconnect();
            return true;
        }
        catch (NumberFormatException e) {
            LOG.debug("unable to parse server version", (Throwable)e);
            this.setError(e);
            this.disconnect();
        }
        catch (ConnectException e) {
            LOG.debug("connection failed: {}", (Object)e.getMessage());
            this.setError(e);
            this.disconnect();
        }
        catch (Throwable e) {
            LOG.debug("connection failed", e);
            this.setError(e);
            this.disconnect();
        }
        return false;
    }

    protected void disconnect() {
        if (this.m_writer != null) {
            try {
                this.m_writer.close();
            }
            catch (IOException e) {
                LOG.warn("error disconnecting output stream", (Throwable)e);
            }
        }
        if (this.m_reader != null) {
            try {
                this.m_reader.close();
            }
            catch (IOException e) {
                LOG.warn("error disconnecting input stream", (Throwable)e);
            }
        }
        if (this.m_socket != null) {
            try {
                this.m_socket.close();
            }
            catch (IOException e) {
                LOG.warn("error disconnecting socket", (Throwable)e);
            }
        }
    }

    @Override
    public PollStatus poll(TimeoutTracker tracker) throws InsufficientParametersException {
        String errorMessage;
        tracker.startAttempt();
        boolean isAvailable = this.tryConnect();
        double responseTime = tracker.elapsedTimeInMillis();
        PollStatus ps = PollStatus.unavailable();
        if (this.getError() != null) {
            errorMessage = this.getError().getMessage();
            ps.setReason(errorMessage);
        } else {
            errorMessage = "";
        }
        if (isAvailable) {
            ps = PollStatus.available((Double)responseTime);
        } else if (SSH_AUTHENTICATION_PATTERN.matcher(errorMessage).find()) {
            ps = PollStatus.unavailable((String)"authentication failed");
        } else if (SSH_NOROUTETOHOST_PATTERN.matcher(errorMessage).find()) {
            ps = PollStatus.unavailable((String)"no route to host");
        } else if (SSH_SOCKETERROR_PATTERN.matcher(errorMessage).find()) {
            ps = PollStatus.unavailable((String)"connection timed out");
        } else if (SSH_CONNECTIONERROR_PATTERN.matcher(errorMessage).find()) {
            ps = PollStatus.unavailable((String)"connection exception");
        } else if (SSH_NUMBERFORMAT_PATTERN.matcher(errorMessage).find()) {
            ps = PollStatus.unavailable((String)"an error occurred parsing the server version number");
        } else if (SSH_IOEXCEPTION_PATTERN.matcher(errorMessage).find()) {
            ps = PollStatus.unavailable((String)"I/O exception");
        }
        return ps;
    }
}

