/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.protocols.jmx.connectors.ConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public abstract class JMXMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(JMXMonitor.class);

    public abstract ConnectionWrapper getMBeanServerConnection(Map<String, Object> var1, InetAddress var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> map) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus serviceStatus = PollStatus.unavailable();
        String dsName = null;
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        try (ConnectionWrapper connection = null;){
            int retry = ParameterMap.getKeyedInteger(map, (String)"retry", (int)3);
            long t0 = 0L;
            for (int attempts = 0; attempts <= retry && !serviceStatus.isAvailable(); ++attempts) {
                LOG.debug("connecting to {} on node ID {}, attempt number {}", new Object[]{InetAddressUtils.str((InetAddress)ipv4Addr), svc.getNodeId(), attempts + 1});
                try {
                    t0 = System.nanoTime();
                    connection = this.getMBeanServerConnection(map, ipv4Addr);
                    if (connection == null) continue;
                    connection.getMBeanServer().getMBeanCount();
                    long nanoResponseTime = System.nanoTime() - t0;
                    serviceStatus = PollStatus.available((Double)((double)nanoResponseTime / 1000000.0));
                }
                catch (IOException e) {
                    String reason = dsName + ": IOException while polling address: " + ipv4Addr;
                    LOG.debug(reason);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                break;
            }
        }
        return serviceStatus;
    }
}

