/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.AnyRestriction;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.NullRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.events.api.EventConstants;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.poller.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryManagerDaoImpl
implements QueryManager {
    private static final Logger LOG = LoggerFactory.getLogger(QueryManagerDaoImpl.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private EventDao m_eventDao;
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;

    @Override
    public String getNodeLabel(int nodeId) {
        return ((OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId))).getLabel();
    }

    private static Date convertEventTimeToTimeStamp(String time) {
        try {
            return EventConstants.parseToDate((String)time);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid date format: " + time, e);
        }
    }

    @Override
    public void openOutage(String outageIdSQL, int nodeId, String ipAddr, String svcName, int serviceLostEventId, Date time) {
        this.openOutage(nodeId, ipAddr, svcName, serviceLostEventId, time);
    }

    private void openOutage(int nodeId, String ipAddr, String svcName, int serviceLostEventId, Date time) {
        OnmsEvent event = (OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(serviceLostEventId));
        OnmsMonitoredService service = this.m_monitoredServiceDao.get(Integer.valueOf(nodeId), InetAddressUtils.addr((String)ipAddr), svcName);
        OnmsOutage outage = new OnmsOutage((Date)new Timestamp(time.getTime()), event, service);
        this.m_outageDao.saveOrUpdate((Object)outage);
    }

    @Override
    public void resolveOutage(int nodeId, String ipAddr, String svcName, int regainedEventId, Date time) {
        LOG.info("resolving outage for {}:{}:{} with resolution {}:{}", new Object[]{nodeId, ipAddr, svcName, regainedEventId, time});
        int serviceId = this.m_serviceTypeDao.findByName(svcName).getId();
        OnmsEvent event = (OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(regainedEventId));
        OnmsMonitoredService service = this.m_monitoredServiceDao.get(Integer.valueOf(nodeId), InetAddressUtils.addr((String)ipAddr), Integer.valueOf(serviceId));
        OnmsOutage outage = this.m_outageDao.currentOutageForService(service);
        if (outage == null) {
            LOG.warn("Cannot find outage for service: {}", (Object)service);
        } else {
            outage.setServiceRegainedEvent(event);
            outage.setIfRegainedService((Date)new Timestamp(time.getTime()));
            this.m_outageDao.saveOrUpdate((Object)outage);
        }
    }

    @Override
    public void reparentOutages(String ipAddr, int oldNodeId, int newNodeId) {
        try {
            LOG.info("reparenting outages for {}:{} to new node {}", new Object[]{oldNodeId, ipAddr, newNodeId});
            Criteria criteria = new Criteria(OnmsOutage.class);
            criteria.setAliases(Arrays.asList(new Alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN)));
            criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)oldNodeId));
            criteria.addRestriction((Restriction)new EqRestriction("ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddr)));
            List outages = this.m_outageDao.findMatching(criteria);
            for (OnmsOutage outage : outages) {
                OnmsMonitoredService service = this.m_monitoredServiceDao.get(Integer.valueOf(newNodeId), InetAddressUtils.addr((String)ipAddr), outage.getServiceId());
                if (service == null) {
                    LOG.warn(" Cannot find monitored service to reparent outage from {}:{} to {}", new Object[]{oldNodeId, ipAddr, newNodeId});
                    continue;
                }
                outage.setMonitoredService(service);
                this.m_outageDao.save((Object)outage);
            }
        }
        catch (Throwable e) {
            LOG.error(" Error reparenting outage for {}:{} to {}", new Object[]{oldNodeId, ipAddr, newNodeId, e});
        }
    }

    @Override
    public List<String[]> getNodeServices(int nodeId) {
        LinkedList<String[]> servicemap = new LinkedList<String[]>();
        Criteria criteria = new Criteria(OnmsMonitoredService.class);
        criteria.setAliases(Arrays.asList(new Alias("ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeId));
        for (OnmsMonitoredService service : this.m_monitoredServiceDao.findMatching(criteria)) {
            servicemap.add(new String[]{service.getIpAddressAsString(), service.getServiceName()});
        }
        return servicemap;
    }

    @Override
    public void closeOutagesForUnmanagedServices() {
        Date closeDate = new Date();
        Criteria criteria = new Criteria(OnmsOutage.class);
        criteria.setAliases(Arrays.asList(new Alias("monitoredService", "monitoredService", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new AnyRestriction(new Restriction[]{new EqRestriction("monitoredService.status", (Object)"D"), new EqRestriction("monitoredService.status", (Object)"F"), new EqRestriction("monitoredService.status", (Object)"U")}));
        criteria.addRestriction((Restriction)new NullRestriction("ifRegainedService"));
        List outages = this.m_outageDao.findMatching(criteria);
        for (OnmsOutage outage : outages) {
            outage.setIfRegainedService(closeDate);
            this.m_outageDao.update((Object)outage);
        }
        criteria = new Criteria(OnmsOutage.class);
        criteria.setAliases(Arrays.asList(new Alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new AnyRestriction(new Restriction[]{new EqRestriction("ipInterface.isManaged", (Object)"F"), new EqRestriction("ipInterface.isManaged", (Object)"U")}));
        criteria.addRestriction((Restriction)new NullRestriction("ifRegainedService"));
        outages = this.m_outageDao.findMatching(criteria);
        for (OnmsOutage outage : outages) {
            outage.setIfRegainedService(closeDate);
            this.m_outageDao.update((Object)outage);
        }
    }

    @Override
    public void closeOutagesForNode(Date closeDate, int eventId, int nodeId) {
        Criteria criteria = new Criteria(OnmsOutage.class);
        criteria.setAliases(Arrays.asList(new Alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeId));
        criteria.addRestriction((Restriction)new NullRestriction("ifRegainedService"));
        List outages = this.m_outageDao.findMatching(criteria);
        for (OnmsOutage outage : outages) {
            outage.setIfRegainedService(closeDate);
            outage.setServiceRegainedEvent((OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(eventId)));
            this.m_outageDao.update((Object)outage);
        }
    }

    @Override
    public void closeOutagesForInterface(Date closeDate, int eventId, int nodeId, String ipAddr) {
        Criteria criteria = new Criteria(OnmsOutage.class);
        criteria.setAliases(Arrays.asList(new Alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeId));
        criteria.addRestriction((Restriction)new EqRestriction("ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddr)));
        criteria.addRestriction((Restriction)new NullRestriction("ifRegainedService"));
        List outages = this.m_outageDao.findMatching(criteria);
        for (OnmsOutage outage : outages) {
            outage.setIfRegainedService(closeDate);
            outage.setServiceRegainedEvent((OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(eventId)));
            this.m_outageDao.update((Object)outage);
        }
    }

    @Override
    public void closeOutagesForService(Date closeDate, int eventId, int nodeId, String ipAddr, String serviceName) {
        Criteria criteria = new Criteria(OnmsOutage.class);
        criteria.setAliases(Arrays.asList(new Alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("monitoredService.serviceType", "serviceType", Alias.JoinType.LEFT_JOIN), new Alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeId));
        criteria.addRestriction((Restriction)new EqRestriction("ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddr)));
        criteria.addRestriction((Restriction)new EqRestriction("serviceType.name", (Object)serviceName));
        criteria.addRestriction((Restriction)new NullRestriction("ifRegainedService"));
        List outages = this.m_outageDao.findMatching(criteria);
        for (OnmsOutage outage : outages) {
            outage.setIfRegainedService(closeDate);
            outage.setServiceRegainedEvent((OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(eventId)));
            this.m_outageDao.update((Object)outage);
            LOG.info("Calling closeOutagesForService: {}", (Object)outage);
        }
    }

    @Override
    public void updateServiceStatus(int nodeId, String ipAddr, String serviceName, String status) {
        Criteria criteria = new Criteria(OnmsMonitoredService.class);
        criteria.setAliases(Arrays.asList(new Alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("monitoredService.serviceType", "serviceType", Alias.JoinType.LEFT_JOIN), new Alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeId));
        criteria.addRestriction((Restriction)new EqRestriction("ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddr)));
        criteria.addRestriction((Restriction)new EqRestriction("serviceType.name", (Object)serviceName));
        criteria.addRestriction((Restriction)new NullRestriction("ifRegainedService"));
        List services = this.m_monitoredServiceDao.findMatching(criteria);
        for (OnmsMonitoredService service : services) {
            service.setStatus(status);
            this.m_monitoredServiceDao.save((Object)service);
        }
    }
}

