/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.MatchTable;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class HttpNotificationStrategy
implements NotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(HttpNotificationStrategy.class);
    private List<Argument> m_arguments;

    public int send(List<Argument> arguments) {
        this.m_arguments = arguments;
        String url = this.getUrl();
        if (url == null) {
            LOG.warn("send: url argument is null, HttpNotification requires a URL");
            return 1;
        }
        HttpClientWrapper clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(3000)).setSocketTimeout(Integer.valueOf(3000)).useSystemProxySettings();
        HttpGet method = null;
        List<NameValuePair> posts = this.getPostArguments();
        if (posts == null) {
            method = new HttpGet(url);
            LOG.info("send: No \"post-\" arguments..., continuing with an HTTP GET using URL: {}", (Object)url);
        } else {
            LOG.info("send: Found \"post-\" arguments..., continuing with an HTTP POST using URL: {}", (Object)url);
            for (NameValuePair post : posts) {
                LOG.debug("send: post argument: {} = {}", (Object)post.getValue(), (Object)post.getName());
            }
            method = new HttpPost(url);
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(posts, "UTF-8");
                ((HttpPost)method).setEntity((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        String contents = null;
        int statusCode = -1;
        try {
            CloseableHttpResponse response = clientWrapper.execute((HttpUriRequest)method);
            statusCode = response.getStatusLine().getStatusCode();
            contents = EntityUtils.toString((HttpEntity)response.getEntity());
            LOG.info("send: Contents is: {}", (Object)contents);
        }
        catch (IOException e) {
            LOG.error("send: IO problem with HTTP post/response: {}", (Throwable)e);
            throw new RuntimeException("Problem with HTTP post: " + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Closeable)clientWrapper);
        }
        this.doSql(contents);
        return statusCode;
    }

    private void doSql(String contents) {
        if (this.getSql() == null) {
            LOG.info("send: optional sql argument is null.");
            return;
        }
        if (contents == null) {
            LOG.info("doSql: HTTP reply is null");
            return;
        }
        LOG.debug("send: compiling expression: {}", (Object)this.getSwitchValue("result-match"));
        Pattern p = Pattern.compile(this.getSwitchValue("result-match"));
        Matcher m = p.matcher(contents);
        if (m.matches()) {
            LOG.debug("send: compiled expression ready to run sql: {}", (Object)this.getSql());
            MatchTable matches = new MatchTable(m);
            String sqlString = PropertiesUtils.substitute((String)this.getSql(), (PropertiesUtils.SymbolTable[])new PropertiesUtils.SymbolTable[]{matches});
            LOG.debug("send: running sql: {}", (Object)sqlString);
            JdbcTemplate template = new JdbcTemplate(DataSourceFactory.getInstance());
            template.execute(sqlString);
        } else {
            LOG.info("send: result didn't match, not running sql");
        }
    }

    private List<NameValuePair> getPostArguments() {
        List<Argument> args = this.getArgsByPrefix("post-");
        ArrayList<NameValuePair> retval = new ArrayList<NameValuePair>();
        for (Argument arg : args) {
            String argSwitch = arg.getSwitch().substring("post-".length());
            if (arg.getValue() == null) {
                arg.setValue("");
            }
            retval.add((NameValuePair)new BasicNameValuePair(argSwitch, this.getValue(arg.getValue())));
        }
        return retval;
    }

    private String getValue(String argValue) {
        if (argValue.equals("-d")) {
            return this.getNotificationValue("-d");
        }
        if (argValue.equals("-email")) {
            return this.getNotificationValue("-email");
        }
        if (argValue.equals("-hphone")) {
            return this.getNotificationValue("-hphone");
        }
        if (argValue.equals("-interface")) {
            return this.getNotificationValue("-interface");
        }
        if (argValue.equals("-ublog")) {
            return this.getNotificationValue("-ublog");
        }
        if (argValue.equals("-mphone")) {
            return this.getNotificationValue("-mphone");
        }
        if (argValue.equals("-nodeid")) {
            return this.getNotificationValue("-nodeid");
        }
        if (argValue.equals("-nm")) {
            return this.getNotificationValue("-nm");
        }
        if (argValue.equals("-np")) {
            return this.getNotificationValue("-np");
        }
        if (argValue.equals("-pemail")) {
            return this.getNotificationValue("-pemail");
        }
        if (argValue.equals("-r")) {
            return this.getNotificationValue("-r");
        }
        if (argValue.equals("-service")) {
            return this.getNotificationValue("-service");
        }
        if (argValue.equals("-subject")) {
            return this.getNotificationValue("-subject");
        }
        if (argValue.equals("-tm")) {
            return this.getNotificationValue("-tm");
        }
        if (argValue.equals("-tp")) {
            return this.getNotificationValue("-tp");
        }
        if (argValue.equals("-tuipin")) {
            return this.getNotificationValue("-tuipin");
        }
        if (argValue.equals("-t")) {
            return this.getNotificationValue("-t");
        }
        if (argValue.equals("-wphone")) {
            return this.getNotificationValue("-wphone");
        }
        if (argValue.equals("-xmpp")) {
            return this.getNotificationValue("-xmpp");
        }
        return argValue;
    }

    private String getNotificationValue(String notificationManagerParamString) {
        String message = "no notification text message defined for the \"" + notificationManagerParamString + "\" switch.";
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(notificationManagerParamString)) continue;
            message = arg.getValue();
        }
        LOG.debug("getNotificationValue: {}", (Object)message);
        return message;
    }

    private List<Argument> getArgsByPrefix(String argPrefix) {
        ArrayList<Argument> args = new ArrayList<Argument>();
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().startsWith(argPrefix)) continue;
            args.add(arg);
        }
        return args;
    }

    private String getSql() {
        return this.getSwitchValue("sql");
    }

    private String getUrl() {
        String url = this.getSwitchValue("url");
        if (url == null) {
            url = this.getUrlAsPrefix();
        }
        return url;
    }

    private String getUrlAsPrefix() {
        String url = null;
        for (Argument arg : this.getArgsByPrefix("url")) {
            LOG.debug("Found url switch: {} with value: {}", (Object)arg.getValue(), (Object)arg.getSwitch());
            url = arg.getValue();
        }
        return url;
    }

    private String getSwitchValue(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            value = arg.getValue();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }
}

