/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpNetToMediaTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(IpNetToMediaTableTracker.class);
    public static final SnmpObjId IPNETTOMEDIA_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.4.22.1");
    public static final SnmpObjId IPNETTOMEDIA_TABLE_IFINDEX = SnmpObjId.get((SnmpObjId)IPNETTOMEDIA_TABLE_ENTRY, (String)"1");
    public static final SnmpObjId IPNETTOMEDIA_TABLE_PHYSADDR = SnmpObjId.get((SnmpObjId)IPNETTOMEDIA_TABLE_ENTRY, (String)"2");
    public static final SnmpObjId IPNETTOMEDIA_TABLE_NETADDR = SnmpObjId.get((SnmpObjId)IPNETTOMEDIA_TABLE_ENTRY, (String)"3");
    public static final SnmpObjId IPNETTOMEDIA_TABLE_TYPE = SnmpObjId.get((SnmpObjId)IPNETTOMEDIA_TABLE_ENTRY, (String)"4");
    public static SnmpObjId[] ms_elemList = new SnmpObjId[]{IPNETTOMEDIA_TABLE_IFINDEX, IPNETTOMEDIA_TABLE_PHYSADDR, IPNETTOMEDIA_TABLE_NETADDR, IPNETTOMEDIA_TABLE_TYPE};

    public IpNetToMediaTableTracker() {
        super(ms_elemList);
    }

    public IpNetToMediaTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, ms_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new IpNetToMediaRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processIpNetToMediaRow((IpNetToMediaRow)row);
    }

    public void processIpNetToMediaRow(IpNetToMediaRow row) {
    }

    public static class IpNetToMediaRow
    extends SnmpRowResult {
        public IpNetToMediaRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public String getIpNetToMediaPhysAddress() {
            try {
                String hexString = this.getValue(IPNETTOMEDIA_TABLE_PHYSADDR).toHexString();
                if (hexString != null && hexString.length() == 12) {
                    return hexString;
                }
                return InetAddressUtils.normalizeMacAddress((String)this.getValue(IPNETTOMEDIA_TABLE_PHYSADDR).toDisplayString());
            }
            catch (IllegalArgumentException e) {
                LOG.warn("IllegalArgument on ipnettomediatable", (Throwable)e);
                return this.getValue(IPNETTOMEDIA_TABLE_PHYSADDR).toDisplayString();
            }
        }

        public InetAddress getIpNetToMediaNetAddress() {
            return this.getValue(IPNETTOMEDIA_TABLE_NETADDR).toInetAddress();
        }

        public Integer getIpNetToMediatype() {
            return this.getValue(IPNETTOMEDIA_TABLE_TYPE).toInt();
        }

        public Integer getIpNetToMediaIfIndex() {
            return this.getValue(IPNETTOMEDIA_TABLE_IFINDEX).toInt();
        }

        public IpNetToMedia getIpNetToMedia() {
            IpNetToMedia at = new IpNetToMedia();
            at.setSourceIfIndex(this.getIpNetToMediaIfIndex());
            at.setPhysAddress(this.getIpNetToMediaPhysAddress());
            at.setNetAddress(this.getIpNetToMediaNetAddress());
            at.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.get((Integer)this.getIpNetToMediatype()));
            return at;
        }
    }
}

