/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;

public class Dot1dTpFdbTableTracker
extends TableTracker {
    public static final int SNMP_DOT1D_FDB_STATUS_LEARNED = 3;
    public static final SnmpObjId DOT1D_TP_FDB_ADDRESS = SnmpObjId.get((String)".1.3.6.1.2.1.17.4.3.1.1");
    public static final SnmpObjId DOT1D_TP_FDB_PORT = SnmpObjId.get((String)".1.3.6.1.2.1.17.4.3.1.2");
    public static final SnmpObjId DOT1D_TP_FDB_STATUS = SnmpObjId.get((String)".1.3.6.1.2.1.17.4.3.1.3");
    public static final SnmpObjId[] ms_elemList = new SnmpObjId[]{DOT1D_TP_FDB_ADDRESS, DOT1D_TP_FDB_PORT, DOT1D_TP_FDB_STATUS};

    public Dot1dTpFdbTableTracker() {
        super(ms_elemList);
    }

    public Dot1dTpFdbTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, ms_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new Dot1dTpFdbRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processDot1dTpFdbRow((Dot1dTpFdbRow)row);
    }

    public void processDot1dTpFdbRow(Dot1dTpFdbRow row) {
    }

    public static class Dot1dTpFdbRow
    extends SnmpRowResult {
        public Dot1dTpFdbRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public String getDot1dTpFdbAddress() {
            if (this.getValue(DOT1D_TP_FDB_ADDRESS) != null) {
                return this.getValue(DOT1D_TP_FDB_ADDRESS).toHexString();
            }
            return null;
        }

        public Integer getDot1dTpFdbPort() {
            if (this.getValue(DOT1D_TP_FDB_PORT) != null) {
                return this.getValue(DOT1D_TP_FDB_PORT).toInt();
            }
            return null;
        }

        public Integer getDot1dTpFdbStatus() {
            if (this.getValue(DOT1D_TP_FDB_STATUS) != null) {
                return this.getValue(DOT1D_TP_FDB_STATUS).toInt();
            }
            return null;
        }

        public BridgeMacLink getLink() {
            BridgeMacLink link = new BridgeMacLink();
            link.setBridgePort(this.getDot1dTpFdbPort());
            link.setMacAddress(this.getDot1dTpFdbAddress());
            if (this.getDot1dTpFdbStatus() != null) {
                link.setBridgeDot1qTpFdbStatus(BridgeMacLink.BridgeDot1qTpFdbStatus.get((Integer)this.getDot1dTpFdbStatus()));
            }
            return link;
        }
    }
}

