/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.Date;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.CdpCacheTableTracker;
import org.opennms.netmgt.enlinkd.snmp.CdpGlobalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.CdpInterfacePortNameGetter;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.topology.LinkableSnmpNode;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryCdp
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryCdp.class);

    public NodeDiscoveryCdp(EnhancedLinkd linkd, LinkableSnmpNode node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        String trackerName = "cdpGlobalGroup";
        CdpGlobalGroupTracker cdpGlobalGroup = new CdpGlobalGroupTracker();
        LOG.debug("run: collecting : {}", (Object)this.getPeer());
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)cdpGlobalGroup);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Cdp Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Cdp Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Cdp Linkd collection interrupted, exiting", (Throwable)e);
            return;
        }
        if (cdpGlobalGroup.getCdpDeviceId() == null) {
            LOG.info("run: cdp mib not supported on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        CdpElement cdpElement = cdpGlobalGroup.getCdpElement();
        this.m_linkd.getQueryManager().store(this.getNodeId(), cdpElement);
        if (cdpElement.getCdpGlobalRun() == OspfElement.TruthValue.FALSE) {
            LOG.info("run: cdp disabled on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        final CdpInterfacePortNameGetter cdpInterfacePortNameGetter = new CdpInterfacePortNameGetter(this.getPeer());
        trackerName = "cdpCacheTable";
        CdpCacheTableTracker cdpCacheTable = new CdpCacheTableTracker(){

            @Override
            public void processCdpCacheRow(CdpCacheTableTracker.CdpCacheRow row) {
                NodeDiscoveryCdp.this.m_linkd.getQueryManager().store(NodeDiscoveryCdp.this.getNodeId(), row.getLink(cdpInterfacePortNameGetter));
            }
        };
        walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)cdpCacheTable);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Cdp Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Cdp Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Cdp Linkd collection interrupted, exiting", (Throwable)e);
            return;
        }
        this.m_linkd.getQueryManager().reconcileCdp(this.getNodeId(), now);
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable CdpLinkNodeDiscovery ip=" + InetAddressUtils.str((InetAddress)this.getTarget()) + " port=" + this.getPort() + " community=" + this.getReadCommunity() + " package=" + this.getPackageName();
    }

    @Override
    public String getName() {
        return "CdpLinksDiscovery";
    }
}

