/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpIfCollector
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpIfCollector.class);
    private Map<SnmpInstId, SNMPCollectorEntry> m_results = new TreeMap<SnmpInstId, SNMPCollectorEntry>();
    private String m_primaryIf;
    private List<SnmpAttributeType> m_objList;
    private SnmpCollectionSet m_collectionSet;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(((Object)((Object)this)).getClass().getName());
        buffer.append("@");
        buffer.append(Integer.toHexString(((Object)((Object)this)).hashCode()));
        buffer.append(": Primary Interface: " + this.m_primaryIf);
        buffer.append(", object list: " + this.m_objList);
        buffer.append(", CollectionSet: ");
        if (this.m_collectionSet == null) {
            buffer.append("(null)");
        } else {
            buffer.append(this.m_collectionSet.getClass().getName());
            buffer.append("@");
            buffer.append(Integer.toHexString(this.m_collectionSet.hashCode()));
        }
        return buffer.toString();
    }

    public SnmpIfCollector(InetAddress address, List<SnmpAttributeType> objList, SnmpCollectionSet collectionSet) {
        super(SnmpAttributeType.getCollectionTrackers(objList));
        LOG.debug("COLLECTING on list of {} items", (Object)objList.size());
        LOG.debug("List is {}", objList);
        this.m_primaryIf = InetAddressUtils.str((InetAddress)address);
        this.m_objList = objList;
        this.m_collectionSet = collectionSet;
    }

    public List<SNMPCollectorEntry> getEntries() {
        return new ArrayList<SNMPCollectorEntry>(this.m_results.values());
    }

    protected void reportGenErr(String msg) {
        LOG.warn("{} : genErr collecting ifData. {}", (Object)this.m_primaryIf, (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("{} : noSuchName collecting ifData. {}", (Object)this.m_primaryIf, (Object)msg);
    }

    protected void reportTooBigErr(String msg) {
        LOG.info("{} : request tooBig. {}", (Object)this.m_primaryIf, (Object)msg);
    }

    protected void storeResult(SnmpResult res) {
        if (res.getBase().toString().equals(".1.3.6.1.2.1.31.1.1.1.18") && (res.getValue().isNull() || res.getValue().toDisplayString() == null || res.getValue().toDisplayString().equals(""))) {
            LOG.debug("Skipping storeResult. Null or zero length ifAlias");
            return;
        }
        SNMPCollectorEntry entry = this.m_results.get(res.getInstance());
        if (entry == null) {
            LOG.debug("Creating new SNMPCollectorEntry entry");
            entry = new SNMPCollectorEntry(this.m_objList, this.m_collectionSet);
            this.m_results.put(res.getInstance(), entry);
        }
        entry.storeResult(res);
    }

    public boolean hasData() {
        return !this.m_results.isEmpty();
    }

    public CollectionSet getCollectionSet() {
        return this.m_collectionSet;
    }
}

