/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(WebPlugin.class);
    static Integer DEFAULT_TIMEOUT = 3000;
    static Integer DEFAULT_PORT = 80;
    static String DEFAULT_USER_AGENT = "OpenNMS WebMonitor";
    static String DEFAULT_PATH = "/";
    static String DEFAULT_USER = "admin";
    static String DEFAULT_PASSWORD = "admin";
    static String DEFAULT_HTTP_STATUS_RANGE = "100-399";
    static String DEFAULT_SCHEME = "http";

    @Override
    public String getProtocolName() {
        return null;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> map) {
        boolean retval = false;
        HttpClientWrapper clientWrapper = HttpClientWrapper.create();
        try {
            URIBuilder ub = new URIBuilder();
            ub.setScheme(ParameterMap.getKeyedString(map, (String)"scheme", (String)DEFAULT_SCHEME));
            ub.setHost(InetAddressUtils.str((InetAddress)address));
            ub.setPort(ParameterMap.getKeyedInteger(map, (String)"port", (int)DEFAULT_PORT));
            ub.setPath(ParameterMap.getKeyedString(map, (String)"path", (String)DEFAULT_PATH));
            HttpGet getMethod = new HttpGet(ub.build());
            clientWrapper.setConnectionTimeout(Integer.valueOf(ParameterMap.getKeyedInteger(map, (String)"timeout", (int)DEFAULT_TIMEOUT))).setSocketTimeout(Integer.valueOf(ParameterMap.getKeyedInteger(map, (String)"timeout", (int)DEFAULT_TIMEOUT))).setUserAgent(ParameterMap.getKeyedString(map, (String)"user-agent", (String)DEFAULT_USER_AGENT)).setVirtualHost(ParameterMap.getKeyedString(map, (String)"virtual-host", (String)InetAddressUtils.str((InetAddress)address)));
            if (ParameterMap.getKeyedBoolean(map, (String)"http-1.0", (boolean)false)) {
                getMethod.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
            }
            for (String okey : map.keySet()) {
                String key = okey.toString();
                if (!key.matches("header_[0-9]+$")) continue;
                String headerName = ParameterMap.getKeyedString(map, (String)key, null);
                String headerValue = ParameterMap.getKeyedString(map, (String)(key + "_value"), null);
                getMethod.setHeader(headerName, headerValue);
            }
            if (ParameterMap.getKeyedBoolean(map, (String)"auth-enabled", (boolean)false)) {
                clientWrapper.addBasicCredentials(ParameterMap.getKeyedString(map, (String)"auth-user", (String)DEFAULT_USER), ParameterMap.getKeyedString(map, (String)"auth-password", (String)DEFAULT_PASSWORD));
                if (ParameterMap.getKeyedBoolean(map, (String)"auth-preemptive", (boolean)true)) {
                    clientWrapper.usePreemptiveAuth();
                }
            }
            CloseableHttpResponse response = clientWrapper.execute((HttpUriRequest)getMethod);
            Integer statusCode = response.getStatusLine().getStatusCode();
            String expectedText = ParameterMap.getKeyedString(map, (String)"response-text", null);
            retval = this.inRange(ParameterMap.getKeyedString(map, (String)"response-range", (String)DEFAULT_HTTP_STATUS_RANGE), statusCode);
            if (expectedText != null) {
                String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                retval = expectedText.charAt(0) == '~' ? responseText.matches(expectedText.substring(1)) : responseText.equals(expectedText);
            }
        }
        catch (IOException e) {
            LOG.info(e.getMessage(), (Throwable)e);
            retval = false;
        }
        catch (URISyntaxException e) {
            LOG.info(e.getMessage(), (Throwable)e);
            retval = false;
        }
        finally {
            IOUtils.closeQuietly((Closeable)clientWrapper);
        }
        return retval;
    }

    private boolean inRange(String range, Integer val) {
        String[] boundries = range.split("-");
        return val >= Integer.valueOf(boundries[0]) && val <= Integer.valueOf(boundries[1]);
    }
}

