/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.opennms.core.logging.Logging;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.RescanProcessor;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.capsd.SuspectEventProcessorFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.events.api.StoppableEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class Capsd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Capsd.class);
    private static Object m_dbSyncLock = new Object();
    private static String m_address = null;
    @Autowired
    private Scheduler m_scheduler = null;
    private StoppableEventListener m_eventListener;
    private ExecutorService m_suspectRunner;
    private ExecutorService m_rescanRunner;
    @Autowired
    private SuspectEventProcessorFactory m_suspectEventProcessorFactory;
    @Autowired
    private CapsdDbSyncer m_capsdDbSyncer;

    public Capsd() {
        super("capsd");
    }

    protected void onStop() {
        this.m_eventListener.close();
        this.m_suspectRunner.shutdown();
        this.m_rescanRunner.shutdown();
        if (this.m_scheduler != null) {
            this.m_scheduler.stop();
        }
    }

    protected void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
        Assert.state((this.m_suspectRunner != null ? 1 : 0) != 0, (String)"must set the suspectRunner property");
        Assert.state((this.m_rescanRunner != null ? 1 : 0) != 0, (String)"must set the rescanRunner property");
        Assert.state((this.m_eventListener != null ? 1 : 0) != 0, (String)"must set the eventListener property");
        if (System.getProperty("org.opennms.provisiond.enableDiscovery", "true").equalsIgnoreCase("true")) {
            throw new IllegalStateException("Provisiond is configured to handle discovery events. Please disable Capsd in service-configuration.xml, or set org.opennms.provisiond.enableDiscovery=false in opennms.properties!");
        }
        LOG.debug("init: Loading services into database...");
        this.m_capsdDbSyncer.syncServices();
        LOG.debug("init: Syncing management state...");
        this.m_capsdDbSyncer.syncManagementState();
        LOG.debug("init: Syncing primary SNMP interface state...");
        this.m_capsdDbSyncer.syncSnmpPrimaryState();
    }

    protected void onStart() {
        SuspectEventProcessor.setQueuedSuspectsTracker(new HashSet<String>());
        RescanProcessor.setQueuedRescansTracker(new HashSet<Integer>());
        LOG.debug("start: Starting rescan scheduler");
        this.m_scheduler.start();
    }

    protected void onPause() {
    }

    protected void onResume() {
    }

    public static String getLocalHostAddress() {
        return m_address;
    }

    static Object getDbSyncLock() {
        return m_dbSyncLock;
    }

    public void scanSuspectInterface(final String ifAddr) throws UnknownHostException {
        Logging.withPrefix((String)this.getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                InetAddress addr = InetAddressUtils.addr((String)ifAddr);
                SuspectEventProcessor proc = Capsd.this.m_suspectEventProcessorFactory.createSuspectEventProcessor(InetAddressUtils.str((InetAddress)addr));
                proc.run();
            }
        });
    }

    public void rescanInterfaceParent(final Integer nodeId) {
        Logging.withPrefix((String)this.getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Capsd.this.m_scheduler.forceRescan(nodeId);
            }
        });
    }

    public void setSuspectRunner(ExecutorService suspectRunner) {
        this.m_suspectRunner = suspectRunner;
    }

    public void setRescanRunner(ExecutorService rescanRunner) {
        this.m_rescanRunner = rescanRunner;
    }

    public void setEventListener(StoppableEventListener eventListener) {
        this.m_eventListener = eventListener;
    }

    public ExecutorService getSuspectRunner() {
        return this.m_suspectRunner;
    }

    public ExecutorService getRescanRunner() {
        return this.m_rescanRunner;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    static {
        m_address = InetAddressUtils.getLocalHostAddressAsString();
    }
}

