/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.DbIfServiceEntry;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.capsd.FailedOperationException;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.capsd.RescanProcessor;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.capsd.SuspectEventProcessorFactory;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

@EventListener(name="Capsd:BroadcastEventProcessor", logPrefix="capsd")
public class BroadcastEventProcessor
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastEventProcessor.class);
    private static String SQL_ADD_INTERFACE_TO_SERVER = "INSERT INTO serverMap VALUES (?, ?)";
    private static String SQL_ADD_SERVICE_TO_MAPPING = "INSERT INTO serviceMap VALUES (?, ?)";
    private static String SQL_DELETE_ALL_SERVICES_INTERFACE_MAPPING = "DELETE FROM serviceMap WHERE ipaddr = ?";
    private static String SQL_DELETE_INTERFACE_ON_SERVER = "DELETE FROM serverMap WHERE ipaddr = ? AND servername = ?";
    private static String SQL_DELETE_SERVICE_INTERFACE_MAPPING = "DELETE FROM serviceMap WHERE ipaddr = ? AND servicemapname = ?";
    private static String SQL_QUERY_IPADDRESS_EXIST = "SELECT nodeid FROM ipinterface WHERE ipaddr = ? AND isManaged !='D'";
    private static String SQL_QUERY_IPINTERFACE_EXIST = "SELECT nodelabel, ipaddr FROM node, ipinterface WHERE node.nodeid = ipinterface.nodeid AND node.nodelabel = ? AND ipinterface.ipaddr = ? AND isManaged !='D' AND nodeType !='D'";
    private static String SQL_QUERY_NODE_EXIST = "SELECT nodeid, dpname FROM node WHERE nodelabel = ? AND nodeType !='D'";
    private static String SQL_QUERY_SERVICE_EXIST = "SELECT nodeid FROM ifservices, service WHERE ifservices.serviceid = service.serviceid AND ipaddr = ? AND servicename = ? AND status !='D'";
    private static String SQL_QUERY_SERVICE_MAPPING_EXIST = "SELECT * FROM serviceMap WHERE ipaddr = ? AND servicemapname = ?";
    private static String SQL_RETRIEVE_NODEID = "select nodeid from ipinterface where ipaddr=? and isManaged!='D'";
    private static String SQL_RETRIEVE_SERVICE_ID = "SELECT serviceid FROM service WHERE servicename = ?";
    private String m_localServer = null;
    private Scheduler m_scheduler;
    private ExecutorService m_suspectQ;
    private SuspectEventProcessorFactory m_suspectEventProcessorFactory;

    public static boolean isPropagationEnabled() {
        return CapsdConfigFactory.getInstance().getDeletePropagationEnabled();
    }

    public static boolean isXmlRpcEnabled() {
        return CapsdConfigFactory.getInstance().getXmlrpc().equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countOtherInterfacesOnNode(Connection dbConn, long nodeId, String ipAddr) throws SQLException {
        String DB_COUNT_OTHER_INTERFACES_ON_NODE = "SELECT count(*) FROM ipinterface WHERE nodeID=? and ipAddr != ? and isManaged != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ipinterface WHERE nodeID=? and ipAddr != ? and isManaged != 'D'");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            LOG.debug("countServicesForInterface: count services for interface {}/{}: found {}", new Object[]{nodeId, ipAddr, count});
            int n = count;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countOtherServicesOnInterface(Connection dbConn, long nodeId, String ipAddr, String service) throws SQLException {
        String DB_COUNT_OTHER_SERVICES_ON_IFACE = "SELECT count(*) FROM ifservices, service WHERE ifservices.serviceId = service.serviceId AND ifservices.status != 'D' AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.servicename != ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ifservices, service WHERE ifservices.serviceId = service.serviceId AND ifservices.status != 'D' AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.servicename != ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setString(3, service);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            LOG.debug("countServicesForInterface: count services for interface {}/{}: found {}", new Object[]{nodeId, ipAddr, count});
            int n = count;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countServicesOnOtherInterfaces(Connection dbConn, long nodeId, String ipAddr) throws SQLException {
        String DB_COUNT_SERVICES_ON_OTHER_INTERFACES = "SELECT count(*) FROM ifservices WHERE nodeID=? and ipAddr != ? and status != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ifservices WHERE nodeID=? and ipAddr != ? and status != 'D'");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            LOG.debug("countServicesOnOtherInterfaces: count services for node {}: found {}", (Object)nodeId, (Object)count);
            int n = count;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> createInterfaceOnNode(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_NODE_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, nodeLabel);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            while (rs.next()) {
                InetAddress ifaddr;
                LOG.debug("addInterfaceHandler:  add interface: {} to the database.", (Object)ipaddr);
                try {
                    ifaddr = InetAddressUtils.addr((String)ipaddr);
                }
                catch (IllegalArgumentException e) {
                    throw new FailedOperationException("unable to resolve host " + ipaddr + ": " + e.getMessage(), e);
                }
                int nodeId = rs.getInt(1);
                String dpName = rs.getString(2);
                DbIpInterfaceEntry ipInterface = DbIpInterfaceEntry.create(nodeId, ifaddr);
                ipInterface.setHostname(ifaddr.getHostName());
                ipInterface.setManagedState('M');
                ipInterface.setPrimaryState('N');
                ipInterface.store(dbConn);
                DbNodeEntry nodeEntry = DbNodeEntry.get(nodeId, dpName);
                Event newEvent = EventUtils.createNodeGainedInterfaceEvent(nodeEntry, ifaddr);
                eventsToSend.add(newEvent);
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> createNodeWithInterface(Connection conn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        InetAddress ifaddress;
        if (nodeLabel == null) {
            return Collections.emptyList();
        }
        LOG.debug("addNode:  Add a node {} to the database", (Object)nodeLabel);
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        DbNodeEntry node = DbNodeEntry.create();
        Date now = new Date();
        node.setCreationTime(now);
        node.setNodeType(OnmsNode.NodeType.ACTIVE);
        node.setLabel(nodeLabel);
        node.setLabelSource(OnmsNode.NodeLabelSource.USER);
        node.store(conn);
        Event newEvent = EventUtils.createNodeAddedEvent(node);
        eventsToSend.add(newEvent);
        if (ipaddr != null) {
            LOG.debug("addNode:  Add an IP Address {} to the database", (Object)ipaddr);
        }
        try {
            ifaddress = InetAddressUtils.addr((String)ipaddr);
        }
        catch (IllegalArgumentException e) {
            throw new FailedOperationException("unable to resolve host " + ipaddr + ": " + e.getMessage(), e);
        }
        DbIpInterfaceEntry ipInterface = DbIpInterfaceEntry.create(node.getNodeId(), ifaddress);
        ipInterface.setHostname(ifaddress.getHostName());
        ipInterface.setManagedState('M');
        ipInterface.setPrimaryState('N');
        ipInterface.store(conn);
        Event gainIfEvent = EventUtils.createNodeGainedInterfaceEvent(node, ifaddress);
        eventsToSend.add(gainIfEvent);
        return eventsToSend;
    }

    private List<Event> doAddInterface(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        List<Event> eventsToSend;
        if (this.interfaceExists(dbConn, nodeLabel, ipaddr)) {
            LOG.debug("addInterfaceHandler: node {} with IPAddress {} already exist in the database.", (Object)nodeLabel, (Object)ipaddr);
            eventsToSend = Collections.emptyList();
        } else {
            eventsToSend = this.nodeExists(dbConn, nodeLabel) ? this.createInterfaceOnNode(dbConn, nodeLabel, ipaddr) : this.createNodeWithInterface(dbConn, nodeLabel, ipaddr);
        }
        return eventsToSend;
    }

    private List<Event> doAddNode(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        List<Event> eventsToSend;
        if (!this.nodeExists(dbConn, nodeLabel)) {
            eventsToSend = this.createNodeWithInterface(dbConn, nodeLabel, ipaddr);
        } else {
            eventsToSend = Collections.emptyList();
            LOG.debug("doAddNode: node {} with IPAddress {} already exist in the database.", (Object)nodeLabel, (Object)ipaddr);
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doAddServiceMapping(Connection dbConn, String ipaddr, String serviceName, long txNo) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_ADD_SERVICE_TO_MAPPING);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            stmt.executeUpdate();
            LOG.debug("updateServiceHandler: add service {} to interface: {}", (Object)serviceName, (Object)ipaddr);
            List<Event> list = this.doChangeService(dbConn, ipaddr, serviceName, "ADD", txNo);
            return list;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doAddServiceToInterface(Connection dbConn, String ipaddr, String serviceName, int serviceId, long txNo) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_IPADDRESS_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            while (rs.next()) {
                InetAddress inetAddr;
                LOG.debug("changeServiceHandler: add service {} to interface: {}", (Object)serviceName, (Object)ipaddr);
                try {
                    inetAddr = InetAddressUtils.addr((String)ipaddr);
                }
                catch (IllegalArgumentException e) {
                    throw new FailedOperationException("unable to resolve host " + ipaddr + ": " + e.getMessage(), e);
                }
                int nodeId = rs.getInt(1);
                DbIfServiceEntry service = DbIfServiceEntry.create(nodeId, inetAddr, serviceId);
                service.setSource('P');
                service.setStatus('A');
                service.setNotify('Y');
                service.store(dbConn, true);
                DbNodeEntry nodeEntry = DbNodeEntry.get(nodeId);
                Event newEvent = EventUtils.createNodeGainedServiceEvent(nodeEntry, inetAddr, serviceName, txNo);
                eventsToSend.add(newEvent);
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> doChangeService(Connection dbConn, String ipaddr, String serviceName, String action, long txNo) throws SQLException, FailedOperationException {
        List<Object> eventsToSend = null;
        int serviceId = this.verifyServiceExists(dbConn, serviceName);
        if (action.equalsIgnoreCase("DELETE")) {
            eventsToSend = new LinkedList();
            int[] nodeIds = this.findNodeIdForServiceAndInterface(dbConn, ipaddr, serviceName);
            for (int i = 0; i < nodeIds.length; ++i) {
                int nodeId = nodeIds[i];
                eventsToSend.addAll(this.doDeleteService(dbConn, "OpenNMS.Capsd", nodeId, ipaddr, serviceName, txNo));
            }
        } else {
            eventsToSend = action.equalsIgnoreCase("ADD") ? this.doAddServiceToInterface(dbConn, ipaddr, serviceName, serviceId, txNo) : Collections.emptyList();
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doCreateInterfaceMappings(Connection dbConn, String nodeLabel, String ipaddr, String hostName, long txNo) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_ADD_INTERFACE_TO_SERVER);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            stmt.executeUpdate();
            LOG.debug("updateServerHandler: added interface {} into NMS server: {}", (Object)ipaddr, (Object)hostName);
            Event newEvent = EventUtils.createAddInterfaceEvent("OpenNMS.Capsd", nodeLabel, ipaddr, hostName, txNo);
            List<Event> list = Collections.singletonList(newEvent);
            return list;
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> doDeleteInterface(Connection dbConn, String source, long nodeid, String ipAddr, long txNo) throws SQLException {
        return this.doDeleteInterface(dbConn, source, nodeid, ipAddr, -1, txNo);
    }

    private List<Event> doDeleteInterface(Connection dbConn, String source, long nodeid, String ipAddr, int ifIndex, long txNo) throws SQLException {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        if (!EventUtils.isNonIpInterface(ipAddr) && BroadcastEventProcessor.isPropagationEnabled() && this.countOtherInterfacesOnNode(dbConn, nodeid, ipAddr) == 0) {
            eventsToSend = this.doDeleteNode(dbConn, source, nodeid, txNo);
        } else {
            if (!EventUtils.isNonIpInterface(ipAddr)) {
                eventsToSend.addAll(this.markAllServicesForInterfaceDeleted(dbConn, source, nodeid, ipAddr, txNo));
            }
            eventsToSend.addAll(this.markInterfaceDeleted(dbConn, source, nodeid, ipAddr, ifIndex, txNo));
        }
        this.deleteAlarmsForInterface(dbConn, nodeid, ipAddr);
        if (ifIndex > -1) {
            this.deleteAlarmsForSnmpInterface(dbConn, nodeid, ifIndex);
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doDeleteInterfaceMappings(Connection dbConn, String nodeLabel, String ipaddr, String hostName, long txNo) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            LOG.debug("updateServer: delete all services on the interface: {} in the interface/service mapping.", (Object)ipaddr);
            stmt = dbConn.prepareStatement(SQL_DELETE_ALL_SERVICES_INTERFACE_MAPPING);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.executeUpdate();
            LOG.debug("updateServer: delete interface: {} on NMS server: {}", (Object)ipaddr, (Object)hostName);
            stmt = dbConn.prepareStatement(SQL_DELETE_INTERFACE_ON_SERVER);
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            stmt.executeUpdate();
            long[] nodeIds = this.findNodeIdsForInterfaceAndLabel(dbConn, nodeLabel, ipaddr);
            for (int i = 0; i < nodeIds.length; ++i) {
                long nodeId = nodeIds[i];
                eventsToSend.addAll(this.doDeleteInterface(dbConn, "OpenNMS.Capsd", nodeId, ipaddr, txNo));
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> doDeleteNode(Connection dbConn, String source, long nodeid, long txNo) throws SQLException {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        eventsToSend.addAll(this.markInterfacesAndServicesDeleted(dbConn, source, nodeid, txNo));
        eventsToSend.addAll(this.markNodeDeleted(dbConn, source, nodeid, txNo));
        this.deleteAlarmsForNode(dbConn, nodeid);
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmsForNode(Connection dbConn, long nodeId) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("DELETE FROM alarms WHERE nodeid = ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            int count = stmt.executeUpdate();
            LOG.debug("deleteAlarmsForNode: deleted: {} alarms for node: {}", (Object)count, (Object)nodeId);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmsForInterface(Connection dbConn, long nodeId, String ipAddr) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("DELETE FROM alarms WHERE nodeid = ? AND ipaddr = ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            int count = stmt.executeUpdate();
            LOG.debug("deleteAlarmsForInterace: deleted: {} alarms for interface: {}", (Object)count, (Object)ipAddr);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmsForSnmpInterface(Connection dbConn, long nodeId, int ifIndex) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("DELETE FROM alarms WHERE nodeid = ? AND ifindex = ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setInt(2, ifIndex);
            int count = stmt.executeUpdate();
            LOG.debug("deleteAlarmsForSnmpInterace: deleted: {} alarms for node {} ifIndex: {}", new Object[]{count, nodeId, ifIndex});
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmsForService(Connection dbConn, long nodeId, String ipAddr, String service) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("DELETE FROM alarms WHERE nodeid = ?  AND ipaddr = ?  AND serviceid   IN (SELECT serviceid FROM service WHERE servicename = ?)");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setString(3, service);
            int count = stmt.executeUpdate();
            LOG.debug("deleteAlarmsForService: deleted: {} alarms for service: {}", (Object)count, (Object)service);
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> doDeleteService(Connection dbConn, String source, long nodeid, String ipAddr, String service, long txNo) throws SQLException {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        if (BroadcastEventProcessor.isPropagationEnabled()) {
            int otherSvcsOnIfCnt = this.countOtherServicesOnInterface(dbConn, nodeid, ipAddr, service);
            if (otherSvcsOnIfCnt == 0 && this.countServicesOnOtherInterfaces(dbConn, nodeid, ipAddr) == 0) {
                LOG.debug("Propagating service delete to node {}", (Object)nodeid);
                eventsToSend.addAll(this.doDeleteNode(dbConn, source, nodeid, txNo));
            } else if (otherSvcsOnIfCnt == 0) {
                LOG.debug("Propagting service delete to interface {}/{}", (Object)nodeid, (Object)ipAddr);
                eventsToSend.addAll(this.doDeleteInterface(dbConn, source, nodeid, ipAddr, txNo));
            } else {
                LOG.debug("No need to Propagate service delete {}/{}/{}", new Object[]{nodeid, ipAddr, service});
                eventsToSend.addAll(this.markServiceDeleted(dbConn, source, nodeid, ipAddr, service, txNo));
            }
        } else {
            LOG.debug("Propagation disabled:  deleting only service {}/{}/{}", new Object[]{nodeid, ipAddr, service});
            eventsToSend.addAll(this.markServiceDeleted(dbConn, source, nodeid, ipAddr, service, txNo));
        }
        this.deleteAlarmsForService(dbConn, nodeid, ipAddr, service);
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doDeleteServiceMapping(Connection dbConn, String ipaddr, String serviceName, long txNo) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            LOG.debug("handleUpdateService: delete service: {} on IPAddress: {}", (Object)serviceName, (Object)ipaddr);
            stmt = dbConn.prepareStatement(SQL_DELETE_SERVICE_INTERFACE_MAPPING);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            stmt.executeUpdate();
            List<Event> list = this.doChangeService(dbConn, ipaddr, serviceName, "DELETE", txNo);
            return list;
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> doUpdateServer(Connection dbConn, String nodeLabel, String ipaddr, String action, String hostName, long txNo) throws SQLException, FailedOperationException {
        boolean exists = this.existsInServerMap(dbConn, hostName, ipaddr);
        if ("DELETE".equalsIgnoreCase(action)) {
            return this.doDeleteInterfaceMappings(dbConn, nodeLabel, ipaddr, hostName, txNo);
        }
        if ("ADD".equalsIgnoreCase(action)) {
            if (exists) {
                throw new FailedOperationException("Could not add interface " + ipaddr + " to NMS server: " + hostName + " because it already exists!");
            }
            return this.doCreateInterfaceMappings(dbConn, nodeLabel, ipaddr, hostName, txNo);
        }
        LOG.error("updateServerHandler: could not process interface: {} on NMS server: {}: action {} unknown", new Object[]{ipaddr, hostName, action});
        throw new FailedOperationException("Undefined operation " + action + " for updateServer event!");
    }

    private List<Event> doUpdateService(Connection dbConn, String nodeLabel, String ipaddr, String serviceName, String action, long txNo) throws SQLException, FailedOperationException {
        this.verifyServiceExists(dbConn, serviceName);
        this.verifyInterfaceExists(dbConn, nodeLabel, ipaddr);
        boolean mapExists = this.serviceMappingExists(dbConn, ipaddr, serviceName);
        List<Event> eventsToSend = mapExists && "DELETE".equalsIgnoreCase(action) ? this.doDeleteServiceMapping(dbConn, ipaddr, serviceName, txNo) : (!mapExists && "ADD".equalsIgnoreCase(action) ? this.doAddServiceMapping(dbConn, ipaddr, serviceName, txNo) : Collections.emptyList());
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsInServerMap(Connection dbConn, String hostName, String ipaddr) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            String SQL_QUERY_INTERFACE_ON_SERVER = "SELECT count(*)  FROM serverMap WHERE ipaddr = ? AND servername = ?";
            stmt = dbConn.prepareStatement("SELECT count(*)  FROM serverMap WHERE ipaddr = ? AND servername = ?");
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            ResultSet rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            boolean bl = count > 0;
            return bl;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] findNodeIdForServiceAndInterface(Connection dbConn, String ipaddr, String serviceName) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_SERVICE_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            LinkedList<Integer> nodeIdList = new LinkedList<Integer>();
            while (rs.next()) {
                LOG.debug("changeService: service {} on IPAddress {} already exists in the database.", (Object)serviceName, (Object)ipaddr);
                int nodeId = rs.getInt(1);
                nodeIdList.add(nodeId);
            }
            int[] nodeIds = new int[nodeIdList.size()];
            int i = 0;
            for (Integer n : nodeIdList) {
                nodeIds[i++] = n;
            }
            int[] nArray = nodeIds;
            return nArray;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] findNodeIdsForInterfaceAndLabel(Connection dbConn, String nodeLabel, String ipAddr) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("SELECT node.nodeid FROM node, ipinterface WHERE node.nodeid = ipinterface.nodeid AND node.nodelabel = ? AND ipinterface.ipaddr = ? AND isManaged !='D' AND nodeType !='D'");
            d.watch((Object)stmt);
            stmt.setString(1, nodeLabel);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            LinkedList<Long> nodeIdList = new LinkedList<Long>();
            while (rs.next()) {
                nodeIdList.add(rs.getLong(1));
            }
            long[] nodeIds = new long[nodeIdList.size()];
            int i = 0;
            for (Long nodeId : nodeIdList) {
                nodeIds[i++] = nodeId;
            }
            long[] lArray = nodeIds;
            return lArray;
        }
        finally {
            d.cleanUp();
        }
    }

    public String getName() {
        return "Capsd:BroadcastEventProcessor";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/addInterface")
    public void handleAddInterface(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkInterface(event);
        EventUtils.requireParm(event, "nodelabel");
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        LOG.debug("addInterfaceHandler:  processing addInterface event for {}", (Object)event.getInterface());
        String nodeLabel = EventUtils.getParm(event, "nodelabel");
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        Connection dbConn = null;
        List<Event> eventsToSend = null;
        try {
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doAddInterface(dbConn, nodeLabel, event.getInterface());
            if (dbConn == null) return;
        }
        catch (SQLException sqlE) {
            try {
                LOG.error("addInterfaceHandler: SQLException during add node and ipaddress to the database.", (Throwable)sqlE);
                throw new FailedOperationException("Database error: " + sqlE.getMessage(), sqlE);
            }
            catch (Throwable throwable) {
                if (dbConn == null) throw throwable;
                try {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        Iterator i$ = eventsToSend.iterator();
                        while (i$.hasNext()) {
                            Event e = (Event)i$.next();
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        throw throwable;
                    }
                    dbConn.rollback();
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.error("handleAddInterface: Threw Exception during commit: ", (Throwable)ex);
                    throw new FailedOperationException("Database error: " + ex.getMessage(), ex);
                }
                finally {
                    if (dbConn != null) {
                        try {
                            dbConn.setAutoCommit(true);
                            dbConn.close();
                        }
                        catch (SQLException ex) {
                            LOG.error("handleAddInterface: Threw Exception during close: ", (Throwable)ex);
                        }
                    }
                }
            }
        }
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator<Event> i$ = eventsToSend.iterator();
                while (i$.hasNext()) {
                    Event e = i$.next();
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            LOG.error("handleAddInterface: Threw Exception during commit: ", (Throwable)ex);
            throw new FailedOperationException("Database error: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.setAutoCommit(true);
                    dbConn.close();
                }
                catch (SQLException ex) {
                    LOG.error("handleAddInterface: Threw Exception during close: ", (Throwable)ex);
                }
            }
        }
    }

    private Connection getConnection() throws SQLException {
        return DataSourceFactory.getInstance().getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/addNode")
    public void handleAddNode(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.requireParm(event, "nodelabel");
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        String ipaddr = event.getInterface();
        String nodeLabel = EventUtils.getParm(event, "nodelabel");
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        LOG.debug("addNodeHandler:  processing addNode event for {}", (Object)ipaddr);
        Connection dbConn = null;
        List<Event> eventsToSend = null;
        try {
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doAddNode(dbConn, nodeLabel, ipaddr);
            if (dbConn == null) return;
        }
        catch (SQLException sqlE) {
            try {
                LOG.error("addNodeHandler: SQLException during add node and ipaddress to tables", (Throwable)sqlE);
                throw new FailedOperationException("database error: " + sqlE.getMessage(), sqlE);
            }
            catch (Throwable throwable) {
                if (dbConn == null) throw throwable;
                try {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        Iterator i$ = eventsToSend.iterator();
                        while (i$.hasNext()) {
                            Event e = (Event)i$.next();
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        throw throwable;
                    }
                    dbConn.rollback();
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.error("handleAddNode: Threw Exception during commit: ", (Throwable)ex);
                    throw new FailedOperationException("database error: " + ex.getMessage(), ex);
                }
                finally {
                    if (dbConn != null) {
                        try {
                            dbConn.close();
                        }
                        catch (SQLException ex) {
                            LOG.error("handleAddNode: Threw Exception during close: ", (Throwable)ex);
                        }
                    }
                }
            }
        }
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator<Event> i$ = eventsToSend.iterator();
                while (i$.hasNext()) {
                    Event e = i$.next();
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            LOG.error("handleAddNode: Threw Exception during commit: ", (Throwable)ex);
            throw new FailedOperationException("database error: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    LOG.error("handleAddNode: Threw Exception during close: ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/changeService")
    public void handleChangeService(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkInterface(event);
        EventUtils.checkService(event);
        EventUtils.requireParm(event, "action");
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        String action = EventUtils.getParm(event, "action");
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        LOG.debug("changeServiceHandler:  processing changeService event on: {}", (Object)event.getInterface());
        Connection dbConn = null;
        List<Event> eventsToSend = null;
        try {
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doChangeService(dbConn, event.getInterface(), event.getService(), action, txNo);
            if (dbConn == null) return;
        }
        catch (SQLException sqlE) {
            try {
                LOG.error("SQLException during changeService on database.", (Throwable)sqlE);
                throw new FailedOperationException("exeption processing changeService: " + sqlE.getMessage(), sqlE);
            }
            catch (Throwable throwable) {
                if (dbConn == null) throw throwable;
                try {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        Iterator i$ = eventsToSend.iterator();
                        while (i$.hasNext()) {
                            Event e = (Event)i$.next();
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        throw throwable;
                    }
                    dbConn.rollback();
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.error("handleChangeService: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException("exeption processing changeService: " + ex.getMessage(), ex);
                }
                finally {
                    if (dbConn != null) {
                        try {
                            dbConn.close();
                        }
                        catch (SQLException ex) {
                            LOG.error("handleChangeService: Exception thrown closing connection: {}", (Throwable)ex);
                        }
                    }
                }
            }
        }
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator<Event> i$ = eventsToSend.iterator();
                while (i$.hasNext()) {
                    Event e = i$.next();
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            LOG.error("handleChangeService: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException("exeption processing changeService: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    LOG.error("handleChangeService: Exception thrown closing connection: {}", (Throwable)ex);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteInterface")
    public void handleDeleteInterface(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkEventId(event);
        EventUtils.checkInterfaceOrIfIndex(event);
        EventUtils.checkNodeId(event);
        int ifIndex = -1;
        if (event.hasIfIndex()) {
            ifIndex = event.getIfIndex();
        }
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        LOG.debug("handleDeleteInterface: Event\nuei\t\t{}\neventid\t\t{}\nnodeId\t\t{}\nipaddr\t\t{}\nifIndex\t\t{}\neventtime\t{}", new Object[]{event.getUei(), event.getDbid(), event.getNodeid(), event.getInterface() != null ? event.getInterface() : "N/A", ifIndex > -1 ? Integer.valueOf(ifIndex) : "N/A", event.getTime() != null ? event.getTime() : "<null>"});
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        Connection dbConn = null;
        List<Event> eventsToSend = null;
        try {
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            String source = event.getSource() == null ? "OpenNMS.Capsd" : event.getSource();
            eventsToSend = this.doDeleteInterface(dbConn, source, event.getNodeid(), event.getInterface(), ifIndex, txNo);
            if (dbConn == null) return;
        }
        catch (SQLException ex) {
            try {
                LOG.error("handleDeleteInterface:  Database error deleting interface on node {} with ip address {} and ifIndex {}", new Object[]{event.getNodeid(), event.getInterface() != null ? event.getInterface() : "null", event.hasIfIndex() ? event.getIfIndex() : "null", ex});
                throw new FailedOperationException("database error: " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                if (dbConn == null) throw throwable;
                try {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        Iterator i$ = eventsToSend.iterator();
                        while (i$.hasNext()) {
                            Event e = (Event)i$.next();
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        throw throwable;
                    }
                    dbConn.rollback();
                    throw throwable;
                }
                catch (SQLException ex2) {
                    LOG.error("handleDeleteInterface: Exception thrown during commit/rollback: ", (Throwable)ex2);
                    throw new FailedOperationException("exeption processing delete interface: " + ex2.getMessage(), ex2);
                }
                finally {
                    if (dbConn != null) {
                        try {
                            dbConn.close();
                        }
                        catch (SQLException ex3) {
                            LOG.error("handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex3);
                        }
                    }
                }
            }
        }
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator<Event> i$ = eventsToSend.iterator();
                while (i$.hasNext()) {
                    Event e = i$.next();
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            LOG.error("handleDeleteInterface: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException("exeption processing delete interface: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    LOG.error("handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteNode")
    public void handleDeleteNode(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkEventId(event);
        EventUtils.checkNodeId(event);
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        long nodeid = event.getNodeid();
        LOG.debug("handleDeleteNode: Event\nuei\t\t{}\neventid\t\t{}\nnodeId\t\t{}\neventtime\t{}", new Object[]{event.getUei(), event.getDbid(), nodeid, event.getTime() != null ? event.getTime() : "<null>"});
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        Connection dbConn = null;
        List<Event> eventsToSend = null;
        try {
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            String source = event.getSource() == null ? "OpenNMS.Capsd" : event.getSource();
            eventsToSend = this.doDeleteNode(dbConn, source, nodeid, txNo);
            if (dbConn == null) return;
        }
        catch (SQLException ex) {
            try {
                LOG.error("handleDeleteService:  Database error deleting service {} on ipAddr {} for node {}", new Object[]{event.getService(), event.getInterface(), nodeid, ex});
                throw new FailedOperationException("database error: " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                if (dbConn == null) throw throwable;
                try {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        Iterator i$ = eventsToSend.iterator();
                        while (i$.hasNext()) {
                            Event e = (Event)i$.next();
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        throw throwable;
                    }
                    dbConn.rollback();
                    throw throwable;
                }
                catch (SQLException ex2) {
                    LOG.error("handleDeleteNode: Exception thrown during commit/rollback: ", (Throwable)ex2);
                    throw new FailedOperationException("exeption processing deleteNode: " + ex2.getMessage(), ex2);
                }
                finally {
                    if (dbConn != null) {
                        try {
                            dbConn.close();
                        }
                        catch (SQLException ex3) {
                            LOG.error("handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex3);
                        }
                    }
                }
            }
        }
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator<Event> i$ = eventsToSend.iterator();
                while (i$.hasNext()) {
                    Event e = i$.next();
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            LOG.error("handleDeleteNode: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException("exeption processing deleteNode: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    LOG.error("handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(uei="uei.opennms.org/nodes/deleteService")
    public void handleDeleteService(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkEventId(event);
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        EventUtils.checkService(event);
        LOG.debug("handleDeleteService: Event\nuei\t\t{}\neventid\t\t{}\nnodeid\t\t{}\nipaddr\t\t{}\nservice\t\t{}\neventtime\t{}", new Object[]{event.getUei(), event.getDbid(), event.getNodeid(), event.getInterface(), event.getService(), event.getTime() != null ? event.getTime() : "<null>"});
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        Connection dbConn = null;
        List<Event> eventsToSend = null;
        try {
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            String source = event.getSource() == null ? "OpenNMS.Capsd" : event.getSource();
            eventsToSend = this.doDeleteService(dbConn, source, event.getNodeid(), event.getInterface(), event.getService(), txNo);
            if (dbConn == null) return;
        }
        catch (SQLException ex) {
            try {
                LOG.error("handleDeleteService:  Database error deleting service {} on ipAddr {} for node {}", new Object[]{event.getService(), event.getInterface(), event.getNodeid(), ex});
                throw new FailedOperationException("database error: " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                if (dbConn == null) throw throwable;
                try {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        Iterator i$ = eventsToSend.iterator();
                        while (i$.hasNext()) {
                            Event e = (Event)i$.next();
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        throw throwable;
                    }
                    dbConn.rollback();
                    throw throwable;
                }
                catch (SQLException ex2) {
                    LOG.error("handleDeleteService: Exception thrown during commit/rollback: ", (Throwable)ex2);
                    throw new FailedOperationException("exeption processing deleteService: " + ex2.getMessage(), ex2);
                }
                finally {
                    if (dbConn != null) {
                        try {
                            dbConn.close();
                        }
                        catch (SQLException ex3) {
                            LOG.error("handleDeleteService: Exception thrown closing connection: ", (Throwable)ex3);
                        }
                    }
                }
            }
        }
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator<Event> i$ = eventsToSend.iterator();
                while (i$.hasNext()) {
                    Event e = i$.next();
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            LOG.error("handleDeleteService: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException("exeption processing deleteService: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    LOG.error("handleDeleteService: Exception thrown closing connection: ", (Throwable)ex);
                }
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/duplicateNodeDeleted")
    public void handleDupNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_scheduler.unscheduleNode(event.getNodeid().intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/forceRescan")
    public void handleForceRescan(Event event) throws InsufficientInformationException {
        Long nodeid = -1L;
        if (event.hasNodeid()) {
            nodeid = event.getNodeid();
        } else {
            EventUtils.checkInterface(event);
            Connection dbc = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            DBUtils d = new DBUtils(this.getClass());
            try {
                dbc = this.getConnection();
                d.watch((Object)dbc);
                stmt = dbc.prepareStatement(SQL_RETRIEVE_NODEID);
                d.watch((Object)stmt);
                stmt.setString(1, event.getInterface());
                rs = stmt.executeQuery();
                d.watch((Object)rs);
                if (rs.next()) {
                    nodeid = rs.getLong(1);
                }
            }
            catch (SQLException sqlE) {
                LOG.error("handleForceRescan: Database error during nodeid retrieval for interface {}", (Object)event.getInterface(), (Object)sqlE);
            }
            finally {
                d.cleanUp();
            }
        }
        if (nodeid == null || nodeid == -1L) {
            LOG.error("handleForceRescan: Nodeid retrieval for interface {} failed.  Unable to perform rescan.", (Object)event.getInterface());
            return;
        }
        if (RescanProcessor.isRescanQueuedForNode(nodeid.intValue())) {
            LOG.info("Ignoring forceRescan event for node {} because a forceRescan for that node already exists in the queue", (Object)nodeid);
            return;
        }
        this.m_scheduler.forceRescan(nodeid.intValue());
    }

    @EventHandler(uei="uei.opennms.org/internal/discovery/newSuspect")
    public void handleNewSuspect(Event event) throws InsufficientInformationException {
        EventUtils.checkInterface(event);
        String interfaceValue = event.getInterface();
        if (SuspectEventProcessor.isScanQueuedForAddress(interfaceValue)) {
            LOG.info("Ignoring newSuspect event for interface {} because a newSuspect scan for that interface already exists in the queue", (Object)interfaceValue);
            return;
        }
        try {
            LOG.debug("onMessage: Adding interface to suspectInterface Q: {}", (Object)interfaceValue);
            this.m_suspectQ.execute(this.m_suspectEventProcessorFactory.createSuspectEventProcessor(interfaceValue));
        }
        catch (Throwable ex) {
            LOG.error("onMessage: Failed to add interface to suspect queue", ex);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeAdded")
    public void handleNodeAdded(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        try {
            this.m_scheduler.scheduleNode(event.getNodeid().intValue());
        }
        catch (SQLException sqlE) {
            LOG.error("onMessage: SQL exception while attempting to schedule node {}", (Object)event.getNodeid(), (Object)sqlE);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void handleNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_scheduler.unscheduleNode(event.getNodeid().intValue());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/updateServer")
    public void handleUpdateServer(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkInterface(event);
        EventUtils.checkHost(event);
        EventUtils.requireParm(event, "action");
        EventUtils.requireParm(event, "nodelabel");
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        String action = EventUtils.getParm(event, "action");
        String nodeLabel = EventUtils.getParm(event, "nodelabel");
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        LOG.debug("updateServerHandler:  processing updateServer event for: {} on OpenNMS server: {}", (Object)event.getInterface(), (Object)this.m_localServer);
        Connection dbConn = null;
        List<Event> eventsToSend = null;
        try {
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doUpdateServer(dbConn, nodeLabel, event.getInterface(), action, this.m_localServer, txNo);
            if (dbConn == null) return;
        }
        catch (SQLException sqlE) {
            try {
                LOG.error("SQLException during updateServer on database.", (Throwable)sqlE);
                throw new FailedOperationException("SQLException during updateServer on database.", sqlE);
            }
            catch (Throwable throwable) {
                if (dbConn == null) throw throwable;
                try {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        Iterator i$ = eventsToSend.iterator();
                        while (i$.hasNext()) {
                            Event e = (Event)i$.next();
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        throw throwable;
                    }
                    dbConn.rollback();
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.error("handleUpdateServer: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException("SQLException during updateServer on database.", ex);
                }
                finally {
                    if (dbConn != null) {
                        try {
                            dbConn.close();
                        }
                        catch (SQLException ex) {
                            LOG.error("handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex);
                        }
                    }
                }
            }
        }
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator<Event> i$ = eventsToSend.iterator();
                while (i$.hasNext()) {
                    Event e = i$.next();
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            LOG.error("handleUpdateServer: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException("SQLException during updateServer on database.", ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    LOG.error("handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/updateService")
    public void handleUpdateService(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkInterface(event);
        EventUtils.checkService(event);
        EventUtils.requireParm(event, "nodelabel");
        EventUtils.requireParm(event, "action");
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        String action = EventUtils.getParm(event, "action");
        String nodeLabel = EventUtils.getParm(event, "nodelabel");
        LOG.debug("handleUpdateService:  processing updateService event for : {} on : {}", (Object)event.getService(), (Object)event.getInterface());
        List<Event> eventsToSend = null;
        Connection dbConn = null;
        try {
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doUpdateService(dbConn, nodeLabel, event.getInterface(), event.getService(), action, txNo);
            if (dbConn == null) return;
        }
        catch (SQLException sqlE) {
            try {
                LOG.error("SQLException during handleUpdateService on database.", (Throwable)sqlE);
                throw new FailedOperationException(sqlE.getMessage());
            }
            catch (Throwable throwable) {
                if (dbConn == null) throw throwable;
                try {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        Iterator i$ = eventsToSend.iterator();
                        while (i$.hasNext()) {
                            Event e = (Event)i$.next();
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        throw throwable;
                    }
                    dbConn.rollback();
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.error("handleUpdateService: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException(ex.getMessage());
                }
                finally {
                    if (dbConn != null) {
                        try {
                            dbConn.close();
                        }
                        catch (SQLException ex) {
                            LOG.error("handleUpdateService: Exception thrown during close: ", (Throwable)ex);
                        }
                    }
                }
            }
        }
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator<Event> i$ = eventsToSend.iterator();
                while (i$.hasNext()) {
                    Event e = i$.next();
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            LOG.error("handleUpdateService: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException(ex.getMessage());
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    LOG.error("handleUpdateService: Exception thrown during close: ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean interfaceExists(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_IPINTERFACE_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, nodeLabel);
            stmt.setString(2, ipaddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            boolean bl = rs.next();
            return bl;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markAllServicesForInterfaceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, long txNo) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            String DB_FIND_SERVICES_FOR_INTERFACE = "SELECT DISTINCT service.serviceName FROM ifservices as ifservices, service as service WHERE ifservices.nodeID = ? and ifservices.ipAddr = ? and ifservices.status != 'D' and ifservices.serviceID = service.serviceID";
            stmt = dbConn.prepareStatement("SELECT DISTINCT service.serviceName FROM ifservices as ifservices, service as service WHERE ifservices.nodeID = ? and ifservices.ipAddr = ? and ifservices.status != 'D' and ifservices.serviceID = service.serviceID");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            HashSet<String> services = new HashSet<String>();
            while (rs.next()) {
                String serviceName = rs.getString(1);
                LOG.debug("found service {} for ipAddr {} node {}", new Object[]{serviceName, ipAddr, nodeId});
                services.add(serviceName);
            }
            String DB_MARK_SERVICES_FOR_INTERFACE = "UPDATE ifservices SET status = 'D' where ifservices.nodeID = ? and ifservices.ipAddr = ?";
            stmt = dbConn.prepareStatement("UPDATE ifservices SET status = 'D' where ifservices.nodeID = ? and ifservices.ipAddr = ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.executeUpdate();
            for (String serviceName : services) {
                LOG.debug("creating event for service {} for ipAddr {} node {}", new Object[]{serviceName, ipAddr, nodeId});
                eventsToSend.add(EventUtils.createServiceDeletedEvent(source, nodeId, ipAddr, serviceName, txNo));
            }
            LOG.debug("markServicesDeleted: marked service deleted: {}/{}", (Object)nodeId, (Object)ipAddr);
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> markInterfaceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, long txNo) throws SQLException {
        return this.markInterfaceDeleted(dbConn, source, nodeId, ipAddr, -1, txNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markInterfaceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, int ifIndex, long txNo) throws SQLException {
        String DB_FIND_INTERFACE = "UPDATE ipinterface SET isManaged = 'D' WHERE nodeid = ? and ipAddr = ? and isManaged != 'D'";
        String DB_FIND_SNMPINTERFACE = "UPDATE snmpinterface SET snmpcollect = 'D' WHERE nodeid = ? and snmpifindex = ? and snmpcollect != 'D'";
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        int countip = 0;
        int countsnmp = 0;
        try {
            if (!EventUtils.isNonIpInterface(ipAddr)) {
                stmt = dbConn.prepareStatement("UPDATE ipinterface SET isManaged = 'D' WHERE nodeid = ? and ipAddr = ? and isManaged != 'D'");
                d.watch((Object)stmt);
                stmt.setLong(1, nodeId);
                stmt.setString(2, ipAddr);
                countip = stmt.executeUpdate();
            }
            if (ifIndex > -1) {
                stmt = dbConn.prepareStatement("UPDATE snmpinterface SET snmpcollect = 'D' WHERE nodeid = ? and snmpifindex = ? and snmpcollect != 'D'");
                d.watch((Object)stmt);
                stmt.setLong(1, nodeId);
                stmt.setInt(2, ifIndex);
                countsnmp = stmt.executeUpdate();
            }
            if (countip > 0) {
                LOG.debug("markInterfaceDeleted: marked ip interface deleted: node = {}, IP address = {}", (Object)nodeId, (Object)ipAddr);
            }
            if (countsnmp > 0) {
                LOG.debug("markInterfaceDeleted: marked snmp interface deleted: node = {}, ifIndex = {}", (Object)nodeId, (Object)ifIndex);
            }
            if (countip > 0 || countsnmp > 0) {
                List<Event> list = Collections.singletonList(EventUtils.createInterfaceDeletedEvent(source, nodeId, ipAddr, ifIndex, txNo));
                return list;
            }
            LOG.debug("markInterfaceDeleted: Interface not found: node = {}, with ip address {}, and ifIndex {}", new Object[]{nodeId, ipAddr != null ? ipAddr : "null", ifIndex > -1 ? Integer.valueOf(ifIndex) : "N/A"});
            List<Event> list = Collections.emptyList();
            return list;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markInterfacesAndServicesDeleted(Connection dbConn, String source, long nodeId, long txNo) throws SQLException {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        String DB_FIND_IFS_FOR_NODE = "SELECT ipinterface.ipaddr FROM ipinterface WHERE ipinterface.nodeid = ? and ipinterface.ismanaged != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("SELECT ipinterface.ipaddr FROM ipinterface WHERE ipinterface.nodeid = ? and ipinterface.ismanaged != 'D'");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            HashSet<String> ipAddrs = new HashSet<String>();
            while (rs.next()) {
                String ipAddr = rs.getString(1);
                LOG.debug("found interface {} for node {}", (Object)ipAddr, (Object)nodeId);
                ipAddrs.add(ipAddr);
            }
            for (String ipAddr : ipAddrs) {
                LOG.debug("deleting interface {} for node {}", (Object)ipAddr, (Object)nodeId);
                eventsToSend.addAll(this.markAllServicesForInterfaceDeleted(dbConn, source, nodeId, ipAddr, txNo));
                eventsToSend.addAll(this.markInterfaceDeleted(dbConn, source, nodeId, ipAddr, txNo));
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markNodeDeleted(Connection dbConn, String source, long nodeId, long txNo) throws SQLException {
        String DB_FIND_INTERFACE = "UPDATE node SET nodeType = 'D' WHERE nodeid = ? and nodeType != 'D'";
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("UPDATE node SET nodeType = 'D' WHERE nodeid = ? and nodeType != 'D'");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            int count = stmt.executeUpdate();
            LOG.debug("markServicesDeleted: marked service deleted: {}", (Object)nodeId);
            if (count > 0) {
                List<Event> list = Collections.singletonList(EventUtils.createNodeDeletedEvent(source, nodeId, txNo));
                return list;
            }
            List<Event> list = Collections.emptyList();
            return list;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markServiceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, String service, long txNo) throws SQLException {
        PreparedStatement stmt = null;
        String DB_MARK_SERVICE_DELETED = "UPDATE ifservices SET status='D' FROM service WHERE ifservices.serviceID = service.serviceID AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.serviceName=?";
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("UPDATE ifservices SET status='D' FROM service WHERE ifservices.serviceID = service.serviceID AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.serviceName=?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setString(3, service);
            int count = stmt.executeUpdate();
            LOG.debug("markServiceDeleted: marked service deleted: {}/{}/{}", new Object[]{nodeId, ipAddr, service});
            if (count > 0) {
                List<Event> list = Collections.singletonList(EventUtils.createServiceDeletedEvent(source, nodeId, ipAddr, service, txNo));
                return list;
            }
            List<Event> list = Collections.emptyList();
            return list;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nodeExists(Connection dbConn, String nodeLabel) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_NODE_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, nodeLabel);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            boolean bl = rs.next();
            return bl;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean serviceMappingExists(Connection dbConn, String ipaddr, String serviceName) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            boolean mapExists;
            stmt = dbConn.prepareStatement(SQL_QUERY_SERVICE_MAPPING_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            boolean bl = mapExists = rs.next();
            return bl;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int verifyServiceExists(Connection dbConn, String serviceName) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_RETRIEVE_SERVICE_ID);
            d.watch((Object)stmt);
            stmt.setString(1, serviceName);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            int serviceId = -1;
            while (rs.next()) {
                LOG.debug("verifyServiceExists: retrieve serviceid for service {}", (Object)serviceName);
                serviceId = rs.getInt(1);
            }
            if (serviceId < 0) {
                LOG.debug("verifyServiceExists: the specified service: {} does not exist in the database.", (Object)serviceName);
                throw new FailedOperationException("Invalid service: " + serviceName);
            }
            int n = serviceId;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    private void verifyInterfaceExists(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        if (!this.interfaceExists(dbConn, nodeLabel, ipaddr)) {
            throw new FailedOperationException("Interface " + ipaddr + " does not exist on a node with nodeLabel " + nodeLabel);
        }
    }

    public void setSuspectEventProcessorFactory(SuspectEventProcessorFactory suspectEventProcessorFactory) {
        this.m_suspectEventProcessorFactory = suspectEventProcessorFactory;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void setSuspectQueue(ExecutorService suspectQ) {
        this.m_suspectQ = suspectQ;
    }

    public void setLocalServer(String localServer) {
        this.m_localServer = localServer;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_suspectEventProcessorFactory != null ? 1 : 0) != 0, (String)"The suspectEventProcessor must be set");
        Assert.state((this.m_scheduler != null ? 1 : 0) != 0, (String)"The schedule must be set");
        Assert.state((this.m_suspectQ != null ? 1 : 0) != 0, (String)"The suspectQueue must be set");
        Assert.state((this.m_localServer != null ? 1 : 0) != 0, (String)"The localServer must be set");
    }
}

