/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.jmx.connectors;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.protocols.jmx.MBeanServerProxy;
import org.opennms.protocols.jmx.connectors.IsolatingClassLoader;
import org.opennms.protocols.jmx.connectors.JBossConnectionWrapper;

public class JBossConnectionFactory {
    static ThreadCategory log = ThreadCategory.getInstance(JBossConnectionFactory.class);
    static String[] packages = new String[]{"org.jboss.naming.*", "org.jboss.interfaces.*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static JBossConnectionWrapper getMBeanServerConnection(Map propertiesMap, InetAddress address) {
        ClassLoader originalLoader;
        JBossConnectionWrapper wrapper;
        block31: {
            InitialContext ctx;
            String port;
            String timeout;
            String connectionType;
            block32: {
                wrapper = null;
                IsolatingClassLoader icl = null;
                originalLoader = Thread.currentThread().getContextClassLoader();
                connectionType = ParameterMap.getKeyedString((Map)propertiesMap, (String)"factory", (String)"RMI");
                timeout = ParameterMap.getKeyedString((Map)propertiesMap, (String)"timeout", (String)"3000");
                String jbossVersion = ParameterMap.getKeyedString((Map)propertiesMap, (String)"version", (String)"4");
                port = ParameterMap.getKeyedString((Map)propertiesMap, (String)"port", (String)"1099");
                if (connectionType == null) {
                    log.error("factory property is not set, check the configuration files.");
                    return null;
                }
                if (jbossVersion == null || jbossVersion.startsWith("4")) {
                    try {
                        icl = new IsolatingClassLoader("jboss", new URL[]{new File(System.getProperty("opennms.home") + "/lib/jboss/jbossall-client.jar").toURI().toURL()}, originalLoader, packages, true);
                    }
                    catch (MalformedURLException e) {
                        log.error("JBossConnectionWrapper MalformedURLException", (Throwable)e);
                    }
                    catch (IsolatingClassLoader.InvalidContextClassLoaderException e) {
                        log.error("JBossConnectionWrapper InvalidContextClassLoaderException", (Throwable)e);
                    }
                } else if (jbossVersion.startsWith("3")) {
                    PrivilegedAction<IsolatingClassLoader> action = new PrivilegedAction<IsolatingClassLoader>(){

                        @Override
                        public IsolatingClassLoader run() {
                            try {
                                return new IsolatingClassLoader("jboss", new URL[]{new File(System.getProperty("opennms.home") + "/lib/jboss/jbossall-client32.jar").toURI().toURL()}, originalLoader, packages, true);
                            }
                            catch (MalformedURLException e) {
                                log.error("JBossConnectionWrapper MalformedURLException", (Throwable)e);
                            }
                            catch (IsolatingClassLoader.InvalidContextClassLoaderException e) {
                                log.error("JBossConnectionWrapper InvalidContextClassLoaderException", (Throwable)e);
                            }
                            return null;
                        }
                    };
                    AccessController.doPrivileged(action);
                }
                if (icl == null) {
                    return null;
                }
                Thread.currentThread().setContextClassLoader(icl);
                if (!connectionType.equals("RMI")) break block32;
                ctx = null;
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("java.naming.factory.initial", "org.jboss.naming.NamingContextFactory");
                props.put("java.naming.provider.url", "jnp://" + address.getHostAddress() + ":" + port);
                props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                props.put("jnp.sotimeout", timeout);
                ctx = new InitialContext(props);
                Object rmiAdaptor = ctx.lookup("jmx/rmi/RMIAdaptor");
                wrapper = new JBossConnectionWrapper(MBeanServerProxy.buildServerProxy(rmiAdaptor));
                Object var13_18 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block31;
                }
                catch (Throwable e1) {
                    log.debug("JBossConnectionFactory error closing initial context");
                }
                break block31;
                {
                    catch (Throwable e) {
                        log.debug("JBossConnectionFactory - unable to get MBeanServer using RMI on " + address.getHostAddress() + ":" + port);
                        Object var13_19 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                            break block31;
                        }
                        catch (Throwable e1) {
                            log.debug("JBossConnectionFactory error closing initial context");
                        }
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_20 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (Throwable e1) {
                        log.debug("JBossConnectionFactory error closing initial context");
                    }
                    throw throwable;
                }
            }
            if (connectionType.equals("HTTP")) {
                ctx = null;
                String invokerSuffix = null;
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("java.naming.factory.initial", "org.jboss.naming.HttpNamingContextFactory");
                props.put("java.naming.provider.url", "http://" + address.getHostAddress() + ":" + port + "/invoker/JNDIFactory");
                props.put("jnp.sotimeout", timeout);
                ctx = new InitialContext(props);
                Object rmiAdaptor = ctx.lookup("jmx/rmi/RMIAdaptor");
                wrapper = new JBossConnectionWrapper(MBeanServerProxy.buildServerProxy(rmiAdaptor));
                Object var16_26 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block31;
                }
                catch (NamingException e1) {
                    log.debug("JBossConnectionFactory error closing initial context");
                }
                break block31;
                {
                    catch (Exception e) {
                        log.debug("JBossConnectionFactory - unable to get MBeanServer using HTTP on " + address.getHostAddress() + invokerSuffix);
                        Object var16_27 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                            break block31;
                        }
                        catch (NamingException e1) {
                            log.debug("JBossConnectionFactory error closing initial context");
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var16_28 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e1) {
                        log.debug("JBossConnectionFactory error closing initial context");
                    }
                    throw throwable;
                }
            }
        }
        Thread.currentThread().setContextClassLoader(originalLoader);
        return wrapper;
    }
}

