/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vulnscand;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.VulnscandConfigFactory;
import org.opennms.netmgt.config.vulnscand.ScanLevel;
import org.opennms.netmgt.config.vulnscand.VulnscandConfiguration;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.vulnscand.BroadcastEventProcessor;
import org.opennms.netmgt.vulnscand.NessusScanConfiguration;
import org.opennms.netmgt.vulnscand.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vulnscand
extends AbstractServiceDaemon {
    private static final String LOG4J_CATEGORY = "OpenNMS.Vulnscand";
    private static final Vulnscand m_singleton = new Vulnscand();
    private static Object m_dbSyncLock = new Object();
    private static String m_address = null;
    private Scheduler m_scheduler = null;
    private BroadcastEventProcessor m_receiver;
    private RunnableConsumerThreadPool m_specificScanRunner;
    private RunnableConsumerThreadPool m_scheduledScanRunner;
    static final String SQL_GET_LAST_POLL_TIME = "SELECT lastAttemptTime FROM vulnerabilities WHERE ipaddr=? ORDER BY lastAttemptTime DESC";
    static final String SQL_DB_RETRIEVE_IP_INTERFACE = "SELECT ipaddr FROM ipinterface WHERE ipaddr!='0.0.0.0' AND isManaged!='D' AND isManaged!='F'";

    public Vulnscand() {
        super(LOG4J_CATEGORY);
    }

    protected void onStop() {
        this.m_receiver.close();
        this.m_specificScanRunner.stop();
        this.m_scheduledScanRunner.stop();
    }

    protected void onStart() {
        try {
            VulnscandConfigFactory.reload();
        }
        catch (MarshalException ex) {
            this.log().error("Failed to load Vulnscand configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error("Failed to load Vulnscand configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().error("Failed to load Vulnscand configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            DataSourceFactory.init();
        }
        catch (IOException ie) {
            this.log().fatal("IOException loading database config", (Throwable)ie);
            throw new UndeclaredThrowableException(ie);
        }
        catch (MarshalException me) {
            this.log().fatal("Marshall Exception loading database config", (Throwable)me);
            throw new UndeclaredThrowableException(me);
        }
        catch (ValidationException ve) {
            this.log().fatal("Validation Exception loading database config", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        catch (ClassNotFoundException ce) {
            this.log().fatal("Class lookup failure loading database config", (Throwable)ce);
            throw new UndeclaredThrowableException(ce);
        }
        catch (PropertyVetoException e) {
            this.log().fatal("Property Veto Exception loading database config", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.log().fatal("SQL Exception loading database config", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        this.m_specificScanRunner = new RunnableConsumerThreadPool("Vulnscand Scan Pool", 0.6f, 1.0f, VulnscandConfigFactory.getInstance().getMaxSuspectThreadPoolSize());
        this.m_scheduledScanRunner = new RunnableConsumerThreadPool("Vulnscand Rescan Pool", 0.6f, 1.0f, VulnscandConfigFactory.getInstance().getMaxRescanThreadPoolSize());
        if (this.log().isDebugEnabled()) {
            this.log().debug("start: Starting runnable thread pools...");
        }
        this.m_specificScanRunner.start();
        this.m_scheduledScanRunner.start();
        if (this.log().isDebugEnabled()) {
            this.log().debug("start: Creating rescan scheduler");
        }
        try {
            this.m_scheduler = new Scheduler(this.m_scheduledScanRunner.getRunQueue());
            this.initialize();
        }
        catch (SQLException sqlE) {
            this.log().error("Failed to initialize the rescan scheduler.", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (Throwable t) {
            this.log().error("Failed to initialize the rescan scheduler.", t);
        }
        this.m_scheduler.start();
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug("start: Creating event broadcast event receiver");
            }
            this.m_receiver = new BroadcastEventProcessor((FifoQueue<Runnable>)this.m_specificScanRunner.getRunQueue(), this.m_scheduler);
        }
        catch (Throwable t) {
            this.log().error("Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
    }

    public static String getLocalHostAddress() {
        return m_address;
    }

    public static Vulnscand getInstance() {
        return m_singleton;
    }

    static Object getDbSyncLock() {
        return m_dbSyncLock;
    }

    protected void onInit() {
    }

    void setInitialScheduleSleep() {
        this.m_scheduler.setInitialSleep(VulnscandConfigFactory.getInstance().getInitialSleepTime());
        if (this.log().isDebugEnabled()) {
            this.log().debug("Scheduler: initial rescan sleep time(millis): " + this.m_scheduler.getInitialSleep());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToKnownAddresses(InetAddress address, int scanLevel) throws SQLException {
        Connection db = null;
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            db = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)db);
            PreparedStatement ifStmt = db.prepareStatement(SQL_GET_LAST_POLL_TIME);
            d.watch((Object)ifStmt);
            ifStmt.setString(1, address.getHostAddress());
            ResultSet rset = ifStmt.executeQuery();
            d.watch((Object)rset);
            ThreadCategory log = this.log();
            if (rset.next()) {
                Timestamp lastPolled = rset.getTimestamp(1);
                if (lastPolled != null && !rset.wasNull()) {
                    if (log.isDebugEnabled()) {
                        log.debug("scheduleAddress: adding node " + address + " with last poll time " + lastPolled);
                    }
                    this.m_scheduler.schedule(address, new NessusScanConfiguration(address, scanLevel, lastPolled, this.getInterval()));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("scheduleAddress: adding ipAddr " + address + " with no previous poll");
                }
                this.m_scheduler.schedule(address, new NessusScanConfiguration(address, scanLevel, new Timestamp(0L), this.getInterval()));
            }
        }
        finally {
            d.cleanUp();
        }
    }

    private long getInterval() {
        return VulnscandConfigFactory.getInstance().getRescanFrequency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    Set<String> getAllManagedInterfaces() {
        TreeSet<String> retval = new TreeSet<String>();
        String addressString = null;
        Connection connection = null;
        Statement selectInterfaces = null;
        ResultSet interfaces = null;
        try {
            connection = DataSourceFactory.getInstance().getConnection();
            selectInterfaces = connection.createStatement();
            interfaces = selectInterfaces.executeQuery(SQL_DB_RETRIEVE_IP_INTERFACE);
            int i = 0;
            while (interfaces.next()) {
                addressString = interfaces.getString(1);
                if (addressString != null) {
                    retval.add(addressString);
                    this.m_scheduler.log().debug("JOHAN: " + addressString);
                } else {
                    this.m_scheduler.log().warn("UNEXPECTED CONDITION: NULL string in the results of the query for managed interfaces from the ipinterface table.");
                }
                ++i;
            }
            this.m_scheduler.log().info("Loaded " + i + " managed interfaces from the database.");
        }
        catch (SQLException ex) {
            this.m_scheduler.log().error(ex.getLocalizedMessage(), (Throwable)ex);
        }
        finally {
            block44: {
                block43: {
                    if (interfaces != null) {
                        interfaces.close();
                    }
                    if (selectInterfaces == null) break block43;
                    selectInterfaces.close();
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    break block44;
                }
                catch (Exception e) {}
                break block44;
                catch (Exception ex) {
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e) {}
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                connection.close();
                            }
                        }
                        catch (Exception e) {}
                        throw throwable;
                    }
                }
            }
        }
        return retval;
    }

    void scheduleExistingInterfaces() throws SQLException {
        VulnscandConfigFactory configFactory = VulnscandConfigFactory.getInstance();
        VulnscandConfiguration config = VulnscandConfigFactory.getConfiguration();
        if (config.getStatus()) {
            Enumeration scanLevels = config.enumerateScanLevel();
            while (scanLevels.hasMoreElements()) {
                ScanLevel scanLevel = (ScanLevel)scanLevels.nextElement();
                int level = scanLevel.getLevel();
                TreeSet<String> levelAddresses = new TreeSet<String>();
                if (configFactory.getManagedInterfacesStatus() && configFactory.getManagedInterfacesScanLevel() == level) {
                    levelAddresses.addAll(this.getAllManagedInterfaces());
                    this.log().info("Scheduled the managed interfaces at scan level " + level + ".");
                }
                levelAddresses.removeAll(configFactory.getAllExcludes());
                this.log().info("Adding " + levelAddresses.size() + " addresses to the vulnerability scan scheduler.");
                for (Object e : levelAddresses) {
                    String nextAddress = null;
                    if (e instanceof String) {
                        nextAddress = (String)e;
                        this.log().debug("JOHAN LevelAddresses : " + nextAddress);
                    }
                    try {
                        InetAddress frump = InetAddress.getByName(nextAddress);
                        this.addToKnownAddresses(frump, level);
                    }
                    catch (UnknownHostException ex) {
                        this.log().error("Could not add invalid address to schedule: " + nextAddress, (Throwable)ex);
                    }
                }
            }
        } else {
            this.log().info("Vulnerability scanning is DISABLED.");
        }
    }

    public void initialize() throws SQLException {
        this.setInitialScheduleSleep();
        this.scheduleExistingInterfaces();
    }

    static {
        try {
            m_address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhE) {
            m_address = "localhost";
            ThreadCategory.getInstance((String)LOG4J_CATEGORY).warn("Could not lookup the host name for the local host machine, address set to \"localhost\"", (Throwable)uhE);
        }
    }
}

