/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import org.exolab.castor.xml.Marshaller;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;

public final class TcpEventProxy
implements EventProxy {
    public static final int DEFAULT_PORT = 5817;
    public static final int DEFAULT_TIMEOUT = 2000;
    private InetSocketAddress m_address;
    private int m_timeout = 2000;

    public TcpEventProxy() throws UnknownHostException {
        this(new InetSocketAddress(InetAddress.getByName("127.0.0.1"), 5817));
    }

    public TcpEventProxy(InetSocketAddress address) {
        this.m_address = address;
    }

    public TcpEventProxy(InetSocketAddress address, int timeout) {
        this(address);
        this.m_timeout = timeout;
    }

    public void send(Event event) throws EventProxyException {
        Log elog = new Log();
        Events events = new Events();
        events.addEvent(event);
        elog.setEvents(events);
        this.send(elog);
    }

    public void send(Log eventLog) throws EventProxyException {
        Connection connection = null;
        try {
            try {
                connection = new Connection();
                Writer writer = connection.getWriter();
                Marshaller.marshal((Object)eventLog, (Writer)writer);
                writer.flush();
            }
            catch (ConnectException e) {
                throw new EventProxyException("Could not connect to event daemon " + this.m_address + " to send event: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new EventProxyException("Unknown exception while sending event: " + e, (Throwable)e);
            }
            Object var5_6 = null;
            if (connection != null) {
                connection.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (connection != null) {
                connection.close();
            }
            throw throwable;
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private class Connection {
        private Socket m_sock = new Socket();
        private Writer m_writer;
        private InputStream m_input;
        private Thread m_rdrThread;

        public Connection() throws IOException {
            this.m_sock.connect(TcpEventProxy.this.m_address, TcpEventProxy.this.m_timeout);
            this.m_sock.setSoTimeout(500);
            TcpEventProxy.this.log().debug("Default Charset:" + Charset.defaultCharset().displayName());
            TcpEventProxy.this.log().debug("Setting Charset: UTF-8");
            this.m_writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.m_sock.getOutputStream()), Charset.forName("UTF-8"));
            this.m_input = this.m_sock.getInputStream();
            this.m_rdrThread = new Thread("TcpEventProxy Input Discarder"){

                public void run() {
                    int ch = 0;
                    while (ch != -1) {
                        try {
                            ch = Connection.this.m_input.read();
                        }
                        catch (InterruptedIOException e) {
                            ch = 0;
                        }
                        catch (IOException e) {
                            ch = -1;
                        }
                    }
                }
            };
            this.m_rdrThread.setDaemon(true);
            this.m_rdrThread.start();
        }

        public Writer getWriter() {
            return this.m_writer;
        }

        public void close() {
            if (this.m_sock != null) {
                try {
                    this.m_sock.close();
                }
                catch (IOException e) {
                    TcpEventProxy.this.log().warn("Error closing socket " + this.m_sock + ": " + e, (Throwable)e);
                }
            }
            this.m_sock = null;
            if (this.m_rdrThread.isAlive()) {
                this.m_rdrThread.interrupt();
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

