/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionSetVisitor;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.threshd.CollectorThresholdingSet;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdingEventProxy;
import org.opennms.netmgt.threshd.ThresholdingEventProxyFactory;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdingVisitor
extends AbstractCollectionSetVisitor {
    CollectorThresholdingSet m_thresholdingSet;
    Map<String, CollectionAttribute> m_attributesMap;

    public static ThresholdingVisitor create(int nodeId, String hostAddress, String serviceName, RrdRepository repo, Map<String, String> params, long interval) {
        ThreadCategory log = ThreadCategory.getInstance(ThresholdingVisitor.class);
        String enabled = params.get("thresholding-enabled");
        if (enabled != null && !"true".equals(enabled)) {
            log.info("create: Thresholds processing is not enabled. Check thresholding-enabled param on collectd package");
            return null;
        }
        CollectorThresholdingSet thresholdingSet = new CollectorThresholdingSet(nodeId, hostAddress, serviceName, repo, interval);
        if (thresholdingSet.hasThresholds()) {
            return new ThresholdingVisitor(thresholdingSet);
        }
        log.warn("create: Can't create ThresholdingVisitor for " + hostAddress + "/" + serviceName);
        return null;
    }

    protected ThresholdingVisitor(CollectorThresholdingSet thresholdingSet) {
        this.m_thresholdingSet = thresholdingSet;
    }

    public List<ThresholdGroup> getThresholdGroups() {
        return this.m_thresholdingSet.m_thresholdGroups;
    }

    public void reload() {
        this.m_thresholdingSet.reinitialize();
    }

    @Override
    public void visitResource(CollectionResource resource) {
        this.m_attributesMap = new HashMap<String, CollectionAttribute>();
    }

    @Override
    public void visitAttribute(CollectionAttribute attribute) {
        if (this.m_thresholdingSet.hasThresholds(attribute)) {
            String name = attribute.getName();
            this.m_attributesMap.put(name, attribute);
            if (this.log().isDebugEnabled()) {
                String value = attribute.getNumericValue();
                if (value == null) {
                    value = attribute.getStringValue();
                }
                this.log().debug("visitAttribute: storing value " + value + " for attribute named " + name);
            }
        }
    }

    @Override
    public void completeResource(CollectionResource resource) {
        List<Event> eventList = this.m_thresholdingSet.applyThresholds(resource, this.m_attributesMap);
        ThresholdingEventProxy proxy = ThresholdingEventProxyFactory.getFactory().getProxy();
        proxy.add(eventList);
        proxy.sendAllEvents();
    }

    public String toString() {
        return "ThresholdingVisitor for " + this.m_thresholdingSet;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

