/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdExpressionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionConfigWrapper
extends BaseThresholdDefConfigWrapper {
    private final Expression m_expression;
    private final Collection<String> m_datasources;
    private final JexlEngine m_parser;

    public ExpressionConfigWrapper(Expression expression) throws ThresholdExpressionException {
        super((Basethresholddef)expression);
        this.m_expression = expression;
        this.m_parser = new JexlEngine();
        BindingsSniffer sniffer = new BindingsSniffer();
        sniffer.put("math", new MathBinding());
        try {
            this.m_parser.createExpression(this.m_expression.getExpression()).evaluate((JexlContext)sniffer);
        }
        catch (Throwable e) {
            throw new ThresholdExpressionException("Could not parse threshold expression:" + e.getMessage(), e);
        }
        this.m_datasources = sniffer.getSniffedKeys();
    }

    @Override
    public String getDatasourceExpression() {
        return this.m_expression.getExpression();
    }

    @Override
    public Collection<String> getRequiredDatasources() {
        return this.m_datasources;
    }

    @Override
    public double evaluate(Map<String, Double> values) throws ThresholdExpressionException {
        BindingsSniffer context = new BindingsSniffer();
        context.putAll(values);
        context.put("math", new MathBinding());
        double result = Double.NaN;
        try {
            result = (Double)this.m_parser.createExpression(this.m_expression.getExpression()).evaluate((JexlContext)context);
        }
        catch (Throwable e) {
            throw new ThresholdExpressionException("Error while evaluating expression " + this.m_expression.getExpression() + ": " + e.getMessage(), e);
        }
        return result;
    }

    public static class MathBinding {
        public double abs(double a) {
            return Math.abs(a);
        }

        public float abs(float a) {
            return Math.abs(a);
        }

        public int abs(int a) {
            return Math.abs(a);
        }

        public long abs(long a) {
            return Math.abs(a);
        }

        public double acos(double a) {
            return Math.acos(a);
        }

        public double asin(double a) {
            return Math.asin(a);
        }

        public double atan(double a) {
            return Math.atan(a);
        }

        public double atan2(double a, double b) {
            return Math.atan2(a, b);
        }

        public double cbrt(double a) {
            return Math.cbrt(a);
        }

        public double ceil(double a) {
            return Math.ceil(a);
        }

        public double cos(double a) {
            return Math.cos(a);
        }

        public double cosh(double a) {
            return Math.cosh(a);
        }

        public double exp(double a) {
            return Math.exp(a);
        }

        public double expm1(double a) {
            return Math.expm1(a);
        }

        public double floor(double a) {
            return Math.floor(a);
        }

        public double hypot(double a, double b) {
            return Math.hypot(a, b);
        }

        public double IEEEremainder(double a, double b) {
            return Math.IEEEremainder(a, b);
        }

        public double log(double a) {
            return Math.log(a);
        }

        public double log10(double a) {
            return Math.log10(a);
        }

        public double log1p(double a) {
            return Math.log1p(a);
        }

        public double max(double a, double b) {
            return Math.max(a, b);
        }

        public float max(float a, float b) {
            return Math.max(a, b);
        }

        public int max(int a, int b) {
            return Math.max(a, b);
        }

        public long max(long a, long b) {
            return Math.max(a, b);
        }

        public double min(double a, double b) {
            return Math.min(a, b);
        }

        public float min(float a, float b) {
            return Math.min(a, b);
        }

        public int min(int a, int b) {
            return Math.min(a, b);
        }

        public long min(long a, long b) {
            return Math.min(a, b);
        }

        public double pow(double a, double b) {
            return Math.pow(a, b);
        }

        public double random() {
            return Math.random();
        }

        public double rint(double a) {
            return Math.rint(a);
        }

        public long round(double a) {
            return Math.round(a);
        }

        public int round(float a) {
            return Math.round(a);
        }

        public double signum(double a) {
            return Math.signum(a);
        }

        public float signum(float a) {
            return Math.signum(a);
        }

        public double sin(double a) {
            return Math.sin(a);
        }

        public double sinh(double a) {
            return Math.sinh(a);
        }

        public double sqrt(double a) {
            return Math.sqrt(a);
        }

        public double tan(double a) {
            return Math.tan(a);
        }

        public double tanh(double a) {
            return Math.tanh(a);
        }

        public double toDegrees(double a) {
            return Math.toDegrees(a);
        }

        public double toRadians(double a) {
            return Math.toRadians(a);
        }

        public double ulp(double a) {
            return Math.ulp(a);
        }

        public float ulp(float a) {
            return Math.ulp(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BindingsSniffer
    extends HashMap<String, Object>
    implements JexlContext {
        private static final long serialVersionUID = 5595028572061424206L;
        private final Set<String> m_sniffedKeys = new HashSet<String>();
        private final String[] ignoreTheseKeys = new String[]{"math"};

        private BindingsSniffer() {
        }

        public Object get(String key) {
            LogUtils.tracef((Object)this, (String)"Bindings.get(%s)", (Object[])new Object[]{key});
            this.m_sniffedKeys.add(key);
            return super.get(key);
        }

        public boolean has(String key) {
            LogUtils.tracef((Object)this, (String)"Bindings.containsKey(%s)", (Object[])new Object[]{key});
            this.m_sniffedKeys.add(key);
            return super.containsKey(key);
        }

        public void set(String key, Object value) {
            LogUtils.tracef((Object)this, (String)"Bindings.set(%s, %s)", (Object[])new Object[]{key, value.toString()});
            this.m_sniffedKeys.add(key);
            super.put(key, value);
        }

        public Set<String> getSniffedKeys() {
            LogUtils.tracef((Object)this, (String)"Bindings.getSniffedKeys(%s)", (Object[])new Object[0]);
            this.m_sniffedKeys.removeAll(Arrays.asList(this.ignoreTheseKeys));
            return Collections.unmodifiableSet(this.m_sniffedKeys);
        }
    }
}

