/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.queued;

import java.util.Set;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Queued
extends AbstractServiceDaemon
implements EventListener {
    private volatile EventIpcManager m_eventMgr;
    private volatile RrdStrategy m_rrdStrategy;

    public Queued() {
        super("OpenNMS.Queued");
    }

    public void setEventIpcManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public RrdStrategy getRrdStrategy() {
        return this.m_rrdStrategy;
    }

    public void setRrdStrategy(RrdStrategy rrdStrategy) {
        this.m_rrdStrategy = rrdStrategy;
    }

    protected void onInit() {
        Assert.state((this.m_eventMgr != null ? 1 : 0) != 0, (String)"setEventIpcManager must be set");
        Assert.state((this.m_rrdStrategy != null ? 1 : 0) != 0, (String)"rrdStrategy must be set");
        this.m_eventMgr.addEventListener(this, "uei.opennms.org/internal/promoteQueueData");
    }

    public void onEvent(Event e) {
        String fileList = EventUtils.getParm((Event)e, (String)"filesToPromote");
        Set<String> files = this.commaDelimitedListToSet(fileList);
        this.logFilePromotion(files);
        this.m_rrdStrategy.promoteEnqueuedFiles(files);
    }

    private Set<String> commaDelimitedListToSet(String fileList) {
        return StringUtils.commaDelimitedListToSet((String)fileList);
    }

    private void logFilePromotion(Set<String> files) {
        if (!this.log().isDebugEnabled()) {
            return;
        }
        for (String file : files) {
            this.debugf("Promoting file: %s", new Object[]{file});
        }
    }
}

