/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.support.EmptyPollerConfiguration;
import org.springframework.remoting.RemoteAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUnreachableAdaptor
implements PollerBackEnd {
    private String m_monitorName;
    private PollerBackEnd m_remoteBackEnd;
    private boolean m_serverUnresponsive = false;

    public void setRemoteBackEnd(PollerBackEnd remoteBackEnd) {
        this.m_remoteBackEnd = remoteBackEnd;
    }

    @Override
    public void checkForDisconnectedMonitors() {
    }

    @Override
    public void configurationUpdated() {
    }

    @Override
    public Collection<OnmsMonitoringLocationDefinition> getMonitoringLocations() {
        return this.m_remoteBackEnd.getMonitoringLocations();
    }

    @Override
    public PollerConfiguration getPollerConfiguration(int locationMonitorId) {
        if (this.m_serverUnresponsive) {
            return new EmptyPollerConfiguration();
        }
        try {
            PollerConfiguration config = this.m_remoteBackEnd.getPollerConfiguration(locationMonitorId);
            this.m_serverUnresponsive = false;
            return config;
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Server is unable to respond due to the following exception.", (Object[])new Object[0]);
            return new EmptyPollerConfiguration();
        }
    }

    @Override
    public OnmsLocationMonitor.MonitorStatus pollerCheckingIn(int locationMonitorId, Date currentConfigurationVersion) {
        try {
            OnmsLocationMonitor.MonitorStatus result = this.m_remoteBackEnd.pollerCheckingIn(locationMonitorId, currentConfigurationVersion);
            this.m_serverUnresponsive = false;
            return result;
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Server is unable to respond due to the following exception.", (Object[])new Object[0]);
            return OnmsLocationMonitor.MonitorStatus.DISCONNECTED;
        }
    }

    @Override
    public boolean pollerStarting(int locationMonitorId, Map<String, String> pollerDetails) {
        try {
            boolean pollerStarting = this.m_remoteBackEnd.pollerStarting(locationMonitorId, pollerDetails);
            if (pollerStarting) {
                this.m_monitorName = this.m_remoteBackEnd.getMonitorName(locationMonitorId);
            }
            this.m_serverUnresponsive = false;
            return pollerStarting;
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Server is unable to respond due to the following exception.", (Object[])new Object[0]);
            return true;
        }
    }

    @Override
    public void pollerStopping(int locationMonitorId) {
        this.m_remoteBackEnd.pollerStopping(locationMonitorId);
    }

    @Override
    public int registerLocationMonitor(String monitoringLocationId) {
        return this.m_remoteBackEnd.registerLocationMonitor(monitoringLocationId);
    }

    @Override
    public void reportResult(int locationMonitorID, int serviceId, PollStatus status) {
        if (!this.m_serverUnresponsive) {
            try {
                this.m_remoteBackEnd.reportResult(locationMonitorID, serviceId, status);
            }
            catch (RemoteAccessException e) {
                this.m_serverUnresponsive = true;
                LogUtils.warnf((Object)this, (Throwable)e, (String)"Server is unable to respond due to the following exception.", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        try {
            return this.m_remoteBackEnd.getServiceMonitorLocators(context);
        }
        catch (RemoteAccessException e) {
            this.m_serverUnresponsive = true;
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Server is unable to respond due to the following exception.", (Object[])new Object[0]);
            return Collections.emptyList();
        }
    }

    @Override
    public String getMonitorName(int locationMonitorId) {
        try {
            return this.m_remoteBackEnd.getMonitorName(locationMonitorId);
        }
        catch (RemoteAccessException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Server is unable to respond due to the following exception.", (Object[])new Object[0]);
            return this.m_monitorName == null ? "" + locationMonitorId : this.m_monitorName;
        }
    }
}

