/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.TimeKeeper;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.remote.OnmsPollModel;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.support.EmptyPollerConfiguration;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional
public class DefaultPollerBackEnd
implements PollerBackEnd,
SpringServiceDaemon {
    private LocationMonitorDao m_locMonDao;
    private MonitoredServiceDao m_monSvcDao;
    private EventIpcManager m_eventIpcManager;
    private PollerConfig m_pollerConfig;
    private TimeKeeper m_timeKeeper;
    private int m_disconnectedTimeout;
    private Date m_configurationTimestamp = null;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_locMonDao, (String)"The LocationMonitorDao must be set");
        Assert.notNull((Object)this.m_monSvcDao, (String)"The MonitoredServiceDao must be set");
        Assert.notNull((Object)this.m_pollerConfig, (String)"The PollerConfig must be set");
        Assert.notNull((Object)this.m_timeKeeper, (String)"The timeKeeper must be set");
        Assert.notNull((Object)this.m_eventIpcManager, (String)"The eventIpcManager must be set");
        Assert.state((this.m_disconnectedTimeout > 0 ? 1 : 0) != 0, (String)"the disconnectedTimeout property must be set");
        this.m_configurationTimestamp = this.m_timeKeeper.getCurrentDate();
    }

    public void start() throws Exception {
    }

    @Override
    public void checkForDisconnectedMonitors() {
        LogUtils.debugf((Object)this, (String)"Checking for disconnected monitors: disconnectedTimeout = %d", (Object[])new Object[]{this.m_disconnectedTimeout});
        try {
            Date now = this.m_timeKeeper.getCurrentDate();
            Date earliestAcceptable = new Date(now.getTime() - (long)this.m_disconnectedTimeout);
            List monitors = this.m_locMonDao.findAll();
            LogUtils.debugf((Object)this, (String)"Found %d monitors", (Object[])new Object[]{monitors.size()});
            for (OnmsLocationMonitor monitor : monitors) {
                if (monitor.getStatus() == OnmsLocationMonitor.MonitorStatus.STARTED && monitor.getLastCheckInTime() != null && monitor.getLastCheckInTime().before(earliestAcceptable)) {
                    LogUtils.debugf((Object)this, (String)"Monitor %s has stopped responding", (Object[])new Object[]{monitor.getName()});
                    monitor.setStatus(OnmsLocationMonitor.MonitorStatus.DISCONNECTED);
                    this.m_locMonDao.update((Object)monitor);
                    this.sendDisconnectedEvent(monitor);
                    continue;
                }
                LogUtils.debugf((Object)this, (String)"Monitor %s (%s) last responded at %s", (Object[])new Object[]{monitor.getName(), monitor.getStatus(), monitor.getLastCheckInTime()});
            }
        }
        catch (Exception e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"An error occurred checking for disconnected monitors.", (Object[])new Object[0]);
        }
    }

    private OnmsLocationMonitor.MonitorStatus checkForGlobalConfigChange(Date currentConfigurationVersion) {
        if (this.m_configurationTimestamp.after(currentConfigurationVersion)) {
            return OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED;
        }
        return OnmsLocationMonitor.MonitorStatus.STARTED;
    }

    @Override
    public void configurationUpdated() {
        this.m_configurationTimestamp = this.m_timeKeeper.getCurrentDate();
    }

    private EventBuilder createEventBuilder(OnmsLocationMonitor mon, String uei) {
        EventBuilder eventBuilder = new EventBuilder(uei, "PollerBackEnd").addParam("locationMonitorId", mon.getId().intValue()).addParam("location", mon.getDefinitionName());
        return eventBuilder;
    }

    private boolean databaseStatusChanged(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        return currentStatus == null || !currentStatus.getPollResult().equals((Object)newStatus.getPollResult());
    }

    private Date getConfigurationTimestamp() {
        return this.m_configurationTimestamp;
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<OnmsMonitoringLocationDefinition> getMonitoringLocations() {
        return this.m_locMonDao.findAllMonitoringLocationDefinitions();
    }

    @Override
    @Transactional(readOnly=true)
    public String getMonitorName(int locationMonitorId) {
        OnmsLocationMonitor locationMonitor = (OnmsLocationMonitor)this.m_locMonDao.load((Serializable)Integer.valueOf(locationMonitorId));
        return locationMonitor.getName();
    }

    private Map<String, Object> getParameterMap(Service serviceConfig) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Enumeration serviceParms = serviceConfig.enumerateParameter();
        while (serviceParms.hasMoreElements()) {
            Parameter serviceParm = (Parameter)serviceParms.nextElement();
            String value = serviceParm.getValue();
            if (value == null) {
                value = serviceParm.getAnyObject() == null ? "" : serviceParm.getAnyObject().toString();
            }
            paramMap.put(serviceParm.getKey(), value);
        }
        return paramMap;
    }

    @Override
    @Transactional(readOnly=true)
    public PollerConfiguration getPollerConfiguration(int locationMonitorId) {
        try {
            OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
            if (mon == null) {
                return new EmptyPollerConfiguration();
            }
            Package pkg = this.getPollingPackageForMonitor(mon);
            ServiceSelector selector = this.m_pollerConfig.getServiceSelectorForPackage(pkg);
            Collection services = this.m_monSvcDao.findMatchingServices(selector);
            ArrayList<PolledService> configs = new ArrayList<PolledService>(services.size());
            LogUtils.debugf((Object)this, (String)"found %d services", (Object[])new Object[]{services.size()});
            for (OnmsMonitoredService monSvc : services) {
                Service serviceConfig = this.m_pollerConfig.getServiceInPackage(monSvc.getServiceName(), pkg);
                long interval = serviceConfig.getInterval();
                Map<String, Object> parameters = this.getParameterMap(serviceConfig);
                configs.add(new PolledService(monSvc, parameters, new OnmsPollModel(interval)));
            }
            Collections.sort(configs);
            return new SimplePollerConfiguration(this.getConfigurationTimestamp(), configs.toArray(new PolledService[configs.size()]));
        }
        catch (Exception e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"An error occurred retrieving the poller configuration for location monitor ID %d", (Object[])new Object[]{locationMonitorId});
            return new EmptyPollerConfiguration();
        }
    }

    private Package getPollingPackageForMonitor(OnmsLocationMonitor mon) {
        OnmsMonitoringLocationDefinition def = this.m_locMonDao.findMonitoringLocationDefinition(mon.getDefinitionName());
        if (def == null) {
            throw new IllegalStateException("Location definition '" + mon.getDefinitionName() + "' could not be found for location monitor ID " + mon.getId());
        }
        String pollingPackageName = def.getPollingPackageName();
        Package pkg = this.m_pollerConfig.getPackage(pollingPackageName);
        if (pkg == null) {
            throw new IllegalStateException("Package " + pollingPackageName + " does not exist as defined for monitoring location " + mon.getDefinitionName());
        }
        return pkg;
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        try {
            Collection<ServiceMonitorLocator> locators = this.m_pollerConfig.getServiceMonitorLocators(context);
            LogUtils.debugf((Object)this, (String)"getServiceMonitorLocators: Returning %d locators", (Object[])new Object[]{locators.size()});
            return locators;
        }
        catch (Exception e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"An error occurred getting the service monitor locators for distribution context: %s", (Object[])new Object[]{context});
            return Collections.emptyList();
        }
    }

    private boolean logicalStatusChanged(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        return currentStatus != null || !newStatus.getPollResult().isAvailable();
    }

    @Override
    public OnmsLocationMonitor.MonitorStatus pollerCheckingIn(int locationMonitorId, Date currentConfigurationVersion) {
        try {
            OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
            if (mon == null) {
                LogUtils.debugf((Object)this, (String)"Deleted monitor checked in with ID %d", (Object[])new Object[]{locationMonitorId});
                return OnmsLocationMonitor.MonitorStatus.DELETED;
            }
            return this.updateMonitorState(mon, currentConfigurationVersion);
        }
        catch (Exception e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"An error occurred while checking in.", (Object[])new Object[0]);
            return OnmsLocationMonitor.MonitorStatus.DISCONNECTED;
        }
    }

    @Override
    public boolean pollerStarting(int locationMonitorId, Map<String, String> pollerDetails) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        if (mon == null) {
            return false;
        }
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
        mon.setDetails(pollerDetails);
        this.m_locMonDao.update((Object)mon);
        this.sendMonitorStartedEvent(mon);
        return true;
    }

    @Override
    public void pollerStopping(int locationMonitorId) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        if (mon == null) {
            LogUtils.infof((Object)this, (String)"pollerStopping was called for location monitor ID %d which does not exist", (Object[])new Object[]{locationMonitorId});
            return;
        }
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STOPPED);
        mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
        this.m_locMonDao.update((Object)mon);
        this.sendMonitorStoppedEvent(mon);
    }

    private void processStatusChange(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        if (this.databaseStatusChanged(currentStatus, newStatus)) {
            this.m_locMonDao.saveStatusChange(newStatus);
            PollStatus pollResult = newStatus.getPollResult();
            if (this.logicalStatusChanged(currentStatus, newStatus)) {
                this.sendRegainedOrLostServiceEvent(newStatus, pollResult);
            }
        }
    }

    @Override
    public int registerLocationMonitor(String monitoringLocationId) {
        OnmsMonitoringLocationDefinition def = this.m_locMonDao.findMonitoringLocationDefinition(monitoringLocationId);
        if (def == null) {
            throw new ObjectRetrievalFailureException(OnmsMonitoringLocationDefinition.class, (Object)monitoringLocationId, "Location monitor definition with the id '" + monitoringLocationId + "' not found", null);
        }
        OnmsLocationMonitor mon = new OnmsLocationMonitor();
        mon.setDefinitionName(def.getName());
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.REGISTERED);
        this.m_locMonDao.save((Object)mon);
        this.sendMonitorRegisteredEvent(mon);
        return mon.getId();
    }

    @Override
    public void reportResult(int locationMonitorId, int serviceId, PollStatus pollResult) {
        OnmsMonitoredService monSvc;
        OnmsLocationMonitor locationMonitor;
        try {
            locationMonitor = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        }
        catch (Exception e) {
            LogUtils.infof((Object)this, (Throwable)e, (String)"Unable to report result for location monitor ID %d: Location monitor does not exist.", (Object[])new Object[]{locationMonitorId});
            return;
        }
        if (locationMonitor == null) {
            LogUtils.infof((Object)this, (String)"Unable to report result for location monitor ID %d: Location monitor does not exist.", (Object[])new Object[]{locationMonitorId});
            return;
        }
        try {
            monSvc = (OnmsMonitoredService)this.m_monSvcDao.get((Serializable)Integer.valueOf(serviceId));
        }
        catch (Exception e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to report result for location monitor ID %d, monitored service ID %d: Monitored service does not exist.", (Object[])new Object[]{locationMonitorId, serviceId});
            return;
        }
        if (monSvc == null) {
            LogUtils.warnf((Object)this, (String)"Unable to report result for location monitor ID %d, monitored service ID %d: Monitored service does not exist.", (Object[])new Object[]{locationMonitorId, serviceId});
            return;
        }
        if (pollResult == null) {
            LogUtils.warnf((Object)this, (String)"Unable to report result for location monitor ID %d, monitored service ID %d: Poll result is null!", (Object[])new Object[]{locationMonitorId, serviceId});
            return;
        }
        OnmsLocationSpecificStatus newStatus = new OnmsLocationSpecificStatus(locationMonitor, monSvc, pollResult);
        try {
            if (newStatus.getPollResult().getResponseTime() != null) {
                Package pkg = this.getPollingPackageForMonitor(locationMonitor);
                this.m_pollerConfig.saveResponseTimeData(Integer.toString(locationMonitorId), monSvc, newStatus.getPollResult().getResponseTime(), pkg);
            }
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Unable to save response time data for location monitor ID %d, monitored service ID %d.", (Object[])new Object[]{locationMonitorId, serviceId});
        }
        try {
            OnmsLocationSpecificStatus currentStatus = this.m_locMonDao.getMostRecentStatusChange(locationMonitor, monSvc);
            this.processStatusChange(currentStatus, newStatus);
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Unable to save result for location monitor ID %d, monitored service ID %d.", (Object[])new Object[]{locationMonitorId, serviceId});
        }
    }

    private void sendMonitorRegisteredEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorRegistered");
    }

    private void sendDisconnectedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorDisconnected");
    }

    private void sendEvent(OnmsLocationMonitor mon, String uei) {
        this.m_eventIpcManager.sendNow(this.createEventBuilder(mon, uei).getEvent());
    }

    private void sendMonitorStartedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorStarted");
    }

    private void sendMonitorStoppedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorStopped");
    }

    private void sendReconnectedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorReconnected");
    }

    private void sendRegainedOrLostServiceEvent(OnmsLocationSpecificStatus newStatus, PollStatus pollResult) {
        String uei = pollResult.isAvailable() ? "uei.opennms.org/remote/nodes/nodeRegainedService" : "uei.opennms.org/remote/nodes/nodeLostService";
        EventBuilder builder = this.createEventBuilder(newStatus.getLocationMonitor(), uei).setMonitoredService(newStatus.getMonitoredService());
        if (!pollResult.isAvailable() && pollResult.getReason() != null) {
            builder.addParam("eventReason", pollResult.getReason());
        }
        this.m_eventIpcManager.sendNow(builder.getEvent());
    }

    public void setDisconnectedTimeout(int disconnectedTimeout) {
        this.m_disconnectedTimeout = disconnectedTimeout;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void setLocationMonitorDao(LocationMonitorDao locMonDao) {
        this.m_locMonDao = locMonDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monSvcDao) {
        this.m_monSvcDao = monSvcDao;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OnmsLocationMonitor.MonitorStatus updateMonitorState(OnmsLocationMonitor mon, Date currentConfigurationVersion) {
        OnmsLocationMonitor.MonitorStatus monitorStatus;
        block11: {
            OnmsLocationMonitor.MonitorStatus monitorStatus2;
            block10: {
                OnmsLocationMonitor.MonitorStatus monitorStatus3;
                block9: {
                    OnmsLocationMonitor.MonitorStatus monitorStatus4;
                    try {
                        switch (mon.getStatus()) {
                            case DISCONNECTED: {
                                this.sendReconnectedEvent(mon);
                                mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                                monitorStatus4 = this.checkForGlobalConfigChange(currentConfigurationVersion);
                                Object var5_7 = null;
                                break;
                            }
                            case STARTED: {
                                mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                                monitorStatus3 = this.checkForGlobalConfigChange(currentConfigurationVersion);
                                break block9;
                            }
                            case PAUSED: {
                                mon.setStatus(OnmsLocationMonitor.MonitorStatus.PAUSED);
                                monitorStatus2 = OnmsLocationMonitor.MonitorStatus.PAUSED;
                                break block10;
                            }
                            case CONFIG_CHANGED: {
                                mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                                monitorStatus = OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED;
                                break block11;
                            }
                            default: {
                                LogUtils.errorf((Object)this, (String)"Unexpected monitor state for monitor: %s", (Object[])new Object[]{mon});
                                throw new IllegalStateException("Unexpected monitor state for monitor: " + mon);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_11 = null;
                        mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
                        this.m_locMonDao.update((Object)mon);
                        throw throwable;
                    }
                    mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
                    this.m_locMonDao.update((Object)mon);
                    return monitorStatus4;
                }
                Object var5_8 = null;
                mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
                this.m_locMonDao.update((Object)mon);
                return monitorStatus3;
            }
            Object var5_9 = null;
            mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
            this.m_locMonDao.update((Object)mon);
            return monitorStatus2;
        }
        Object var5_10 = null;
        mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
        this.m_locMonDao.update((Object)mon);
        return monitorStatus;
    }

    private static class SimplePollerConfiguration
    implements PollerConfiguration,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Date m_timestamp;
        private PolledService[] m_polledServices;

        SimplePollerConfiguration(Date timestamp, PolledService[] polledSvcs) {
            this.m_timestamp = timestamp;
            this.m_polledServices = polledSvcs;
        }

        public Date getConfigurationTimestamp() {
            return this.m_timestamp;
        }

        public PolledService[] getPolledServices() {
            return this.m_polledServices;
        }
    }
}

