/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

@Distributable
public class WebMonitor
extends IPv4Monitor {
    static Integer DEFAULT_TIMEOUT = 3000;
    static Integer DEFAULT_PORT = 80;
    static String DEFAULT_USER_AGENT = "OpenNMS WebMonitor";
    static String DEFAULT_PATH = "/";
    static String DEFAULT_USER = "admin";
    static String DEFAULT_PASSWORD = "admin";
    static String DEFAULT_HTTP_STATUS_RANGE = "100-399";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map map) {
        PollStatus pollStatus;
        block12: {
            pollStatus = PollStatus.unresponsive();
            DefaultHttpClient httpClient = new DefaultHttpClient();
            try {
                block11: {
                    try {
                        HttpGet getMethod = new HttpGet(new URI(null, null, svc.getAddress().getHostAddress(), ParameterMap.getKeyedInteger((Map)map, (String)"port", (int)DEFAULT_PORT), ParameterMap.getKeyedString((Map)map, (String)"path", (String)DEFAULT_PATH), null, null));
                        httpClient.getParams().setIntParameter("http.connection.timeout", ParameterMap.getKeyedInteger((Map)map, (String)"timeout", (int)DEFAULT_TIMEOUT));
                        httpClient.getParams().setIntParameter("http.socket.timeout", ParameterMap.getKeyedInteger((Map)map, (String)"timeout", (int)DEFAULT_TIMEOUT));
                        httpClient.getParams().setParameter("http.useragent", (Object)ParameterMap.getKeyedString((Map)map, (String)"user-agent", (String)DEFAULT_USER_AGENT));
                        httpClient.getParams().setParameter("http.virtual-host", (Object)new HttpHost(ParameterMap.getKeyedString((Map)map, (String)"virtual-host", null), ParameterMap.getKeyedInteger((Map)map, (String)"port", (int)DEFAULT_PORT)));
                        if (ParameterMap.getKeyedBoolean((Map)map, (String)"http-1.0", (boolean)false)) {
                            httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
                        }
                        for (Object okey : map.keySet()) {
                            String key = okey.toString();
                            if (!key.matches("header_[0-9]+$")) continue;
                            String headerName = ParameterMap.getKeyedString((Map)map, (String)key, null);
                            String headerValue = ParameterMap.getKeyedString((Map)map, (String)(key + "_value"), null);
                            getMethod.setHeader(headerName, headerValue);
                        }
                        if (ParameterMap.getKeyedBoolean((Map)map, (String)"auth-enabled", (boolean)false)) {
                            httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(ParameterMap.getKeyedString((Map)map, (String)"auth-user", (String)DEFAULT_USER), ParameterMap.getKeyedString((Map)map, (String)"auth-password", (String)DEFAULT_PASSWORD)));
                            if (ParameterMap.getKeyedBoolean((Map)map, (String)"auth-preemptive", (boolean)true)) {
                                HttpRequestInterceptor preemptiveAuth = new HttpRequestInterceptor(){

                                    public void process(HttpRequest request, HttpContext context) throws IOException {
                                        AuthScope authScope;
                                        Credentials creds;
                                        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                                        CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                                        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                                        if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                                            authState.setAuthScheme((AuthScheme)new BasicScheme());
                                            authState.setCredentials(creds);
                                        }
                                    }
                                };
                                httpClient.addRequestInterceptor(preemptiveAuth, 0);
                            }
                        }
                        this.log().debug("httpClient request with the following parameters: " + httpClient);
                        this.log().debug("getMethod parameters: " + getMethod);
                        HttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
                        int statusCode = response.getStatusLine().getStatusCode();
                        String statusText = response.getStatusLine().getReasonPhrase();
                        String expectedText = ParameterMap.getKeyedString((Map)map, (String)"response-text", null);
                        this.log().debug("returned results are:");
                        pollStatus = !this.inRange(ParameterMap.getKeyedString((Map)map, (String)"response-range", (String)DEFAULT_HTTP_STATUS_RANGE), statusCode) ? PollStatus.unavailable((String)statusText) : PollStatus.available();
                        if (expectedText == null) break block11;
                        String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                        if (expectedText.charAt(0) == '~') {
                            pollStatus = !responseText.matches(expectedText.substring(1)) ? PollStatus.unavailable((String)"Regex Failed") : PollStatus.available();
                            break block11;
                        }
                        if (expectedText.equals(responseText)) {
                            pollStatus = PollStatus.available();
                            break block11;
                        }
                        pollStatus = PollStatus.unavailable((String)"Did not find expected Text");
                    }
                    catch (IOException e) {
                        this.log().info(e.getMessage());
                        Object var12_15 = null;
                        break block12;
                    }
                    catch (URISyntaxException e) {
                        this.log().info(e.getMessage());
                        Object var12_16 = null;
                    }
                }
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                throw throwable;
            }
        }
        return pollStatus;
    }

    private boolean inRange(String range, Integer val) {
        String[] boundries = range.split("-");
        return val >= new Integer(boundries[0]) && val <= new Integer(boundries[1]);
    }
}

