/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.MatchTable;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.pagesequence.Page;
import org.opennms.netmgt.config.pagesequence.PageSequence;
import org.opennms.netmgt.config.pagesequence.Parameter;
import org.opennms.netmgt.config.pagesequence.SessionVariable;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public class PageSequenceMonitor
extends IPv4Monitor {
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_RETRY = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameterMap) {
        DefaultHttpClient client = null;
        PollStatus serviceStatus = PollStatus.unavailable((String)"Poll not completed yet");
        LinkedHashMap<String, Double> responseTimes = new LinkedHashMap<String, Double>();
        try {
            try {
                PageSequenceMonitorParameters parms = PageSequenceMonitorParameters.get(parameterMap);
                client = parms.createHttpClient();
                long startTime = System.nanoTime();
                responseTimes.put("response-time", Double.NaN);
                parms.getPageSequence().execute(client, svc, responseTimes);
                long endTime = System.nanoTime();
                double responseTime = (double)(endTime - startTime) / 1000000.0;
                serviceStatus = PollStatus.available();
                responseTimes.put("response-time", responseTime);
                serviceStatus.setProperties(responseTimes);
                return serviceStatus;
            }
            catch (PageSequenceMonitorException e) {
                serviceStatus = PollStatus.unavailable((String)e.getMessage());
                serviceStatus.setProperties(responseTimes);
                return serviceStatus;
            }
            catch (IllegalArgumentException e) {
                this.log().error("Invalid parameters to monitor: " + e, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)("Invalid parameter to monitor: " + e.getMessage() + ".  See log for details."));
                serviceStatus.setProperties(responseTimes);
                return serviceStatus;
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageSequenceMonitorParameters {
        public static final String KEY = PageSequenceMonitorParameters.class.getName();
        private Map<String, String> m_parameterMap;
        private HttpParams m_clientParams;
        private HttpPageSequence m_pageSequence;

        static synchronized PageSequenceMonitorParameters get(Map paramterMap) {
            PageSequenceMonitorParameters parms = (PageSequenceMonitorParameters)paramterMap.get(KEY);
            if (parms == null) {
                parms = new PageSequenceMonitorParameters(paramterMap);
                paramterMap.put(KEY, parms);
            }
            return parms;
        }

        PageSequenceMonitorParameters(Map<String, String> parameterMap) {
            this.m_parameterMap = parameterMap;
            String pageSequence = this.getStringParm("page-sequence", null);
            if (pageSequence == null) {
                throw new IllegalArgumentException("page-sequence must be set in monitor parameters");
            }
            PageSequence sequence = this.parsePageSequence(pageSequence);
            this.m_pageSequence = new HttpPageSequence(sequence);
            this.m_pageSequence.setParameters(parameterMap);
            this.m_clientParams = this.createClientParams();
        }

        Map<String, String> getParameterMap() {
            return this.m_parameterMap;
        }

        HttpPageSequence getPageSequence() {
            return this.m_pageSequence;
        }

        PageSequence parsePageSequence(String sequenceString) {
            try {
                return (PageSequence)CastorUtils.unmarshal(PageSequence.class, (Reader)new StringReader(sequenceString));
            }
            catch (MarshalException e) {
                throw new IllegalArgumentException("Unable to parse page-sequence for HttpMonitor: " + (Object)((Object)e) + "\nConfig: " + sequenceString, e);
            }
            catch (ValidationException e) {
                throw new IllegalArgumentException("Unable to validate page-sequence for HttpMonitor: " + (Object)((Object)e) + "\nConfig: " + sequenceString, e);
            }
        }

        private String getStringParm(String key, String deflt) {
            return ParameterMap.getKeyedString(this.getParameterMap(), (String)key, (String)deflt);
        }

        private int getIntParm(String key, int defValue) {
            return ParameterMap.getKeyedInteger(this.getParameterMap(), (String)key, (int)defValue);
        }

        private HttpParams createClientParams() {
            BasicHttpParams clientParams = new BasicHttpParams();
            clientParams.setIntParameter("http.connection.timeout", this.getTimeout());
            clientParams.setIntParameter("http.socket.timeout", this.getTimeout());
            clientParams.setParameter("http.protocol.cookie-policy", (Object)"compatibility");
            clientParams.setBooleanParameter("http.protocol.single-cookie-header", true);
            return clientParams;
        }

        public int getRetries() {
            return this.getIntParm("retry", 0);
        }

        public int getTimeout() {
            return this.getIntParm("timeout", 3000);
        }

        public HttpParams getClientParams() {
            return this.m_clientParams;
        }

        DefaultHttpClient createHttpClient() {
            DefaultHttpClient client = new DefaultHttpClient(this.getClientParams());
            client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.getRetries(), false));
            return client;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HttpPage {
        private final Page m_page;
        private final HttpResponseRange m_range;
        private final Pattern m_successPattern;
        private final Pattern m_failurePattern;
        private final Pattern m_locationPattern;
        private final HttpPageSequence m_parentSequence;
        private double m_responseTime;
        private final List<NameValuePair> m_parms = new ArrayList<NameValuePair>();

        HttpPage(HttpPageSequence parent, Page page) {
            this.m_page = page;
            this.m_range = new HttpResponseRange(page.getResponseRange());
            this.m_successPattern = page.getSuccessMatch() == null ? null : Pattern.compile(page.getSuccessMatch());
            this.m_failurePattern = page.getFailureMatch() == null ? null : Pattern.compile(page.getFailureMatch());
            this.m_locationPattern = page.getLocationMatch() == null ? null : Pattern.compile(page.getLocationMatch());
            this.m_parentSequence = parent;
            for (Parameter parm : this.m_page.getParameter()) {
                this.m_parms.add((NameValuePair)new BasicNameValuePair(parm.getKey(), parm.getValue()));
            }
        }

        public String toString() {
            StringBuffer retval = new StringBuffer();
            retval.append("HttpPage { ");
            retval.append("page.host => ").append(this.m_page.getHost()).append(", ");
            retval.append("page.port => ").append(this.m_page.getPort()).append(", ");
            retval.append("page.path => ").append(this.m_page.getPath()).append(", ");
            retval.append("page.successMatch => '").append(this.m_page.getSuccessMatch()).append("', ");
            retval.append("page.failureMatch => '").append(this.m_page.getFailureMatch()).append("', ");
            retval.append("page.locationMatch => '").append(this.m_page.getLocationMatch()).append("'");
            retval.append(" }");
            return retval.toString();
        }

        void execute(DefaultHttpClient client, MonitoredService svc, Properties sequenceProperties) {
            try {
                Matcher matcher;
                URI uri = this.getURI(svc);
                PageSequenceHttpUriRequest method = this.getMethod(uri);
                if (this.getVirtualHost(svc) != null) {
                    method.getParams().setParameter("http.virtual-host", (Object)new HttpHost(this.getVirtualHost(svc), uri.getPort()));
                }
                if (this.getUserAgent() != null) {
                    method.getParams().setParameter("http.useragent", (Object)this.getUserAgent());
                } else {
                    method.getParams().setParameter("http.useragent", (Object)("OpenNMS PageSequenceMonitor (Service name: " + svc.getSvcName() + ")"));
                }
                String disableVerification = this.m_page.getDisableHostVerification();
                if (Boolean.parseBoolean(disableVerification)) {
                    ((SSLSocketFactory)client.getConnectionManager().getSchemeRegistry().getScheme("https").getSocketFactory()).setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                } else if (!"https".equals(uri.getScheme())) {
                    this.log().warn("disable-host-verification is enabled on a non-SSL URI (which has no effect): " + uri.toString());
                }
                if (this.m_parms.size() > 0) {
                    method.setQueryParameters(this.expandParms(svc));
                }
                if (this.m_page.getUserInfo() != null) {
                    String userInfo = this.m_page.getUserInfo();
                    String[] streetCred = userInfo.split(":", 2);
                    if (streetCred.length == 2) {
                        client.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(streetCred[0], streetCred[1]));
                    } else {
                        this.log().warn("Illegal value found for username/password HTTP credentials: " + userInfo);
                    }
                }
                long startTime = System.nanoTime();
                HttpResponse response = client.execute((HttpUriRequest)method);
                long endTime = System.nanoTime();
                this.m_responseTime = (double)(endTime - startTime) / 1000000.0;
                int code = response.getStatusLine().getStatusCode();
                if (!this.getRange().contains(code)) {
                    throw new PageSequenceMonitorException("response code out of range for uri:" + uri + ".  Expected " + this.getRange() + " but received " + code);
                }
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                if (this.getLocationPattern() != null) {
                    Header locationHeader = response.getFirstHeader("location");
                    if (locationHeader == null) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("locationMatch was set, but no Location: header was returned at " + uri, (Throwable)new Exception());
                        }
                        throw new PageSequenceMonitorException("locationMatch was set, but no Location: header was returned at " + uri);
                    }
                    Matcher matcher2 = this.getLocationPattern().matcher(locationHeader.getValue());
                    if (!matcher2.find()) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("failed to find '" + this.getLocationPattern() + "' in Location: header at " + uri + ":\n" + locationHeader.getValue(), (Throwable)new Exception());
                        }
                        throw new PageSequenceMonitorException("failed to find '" + this.getLocationPattern() + "' in Location: header at " + uri);
                    }
                }
                if (this.getFailurePattern() != null && (matcher = this.getFailurePattern().matcher(responseString)).find()) {
                    throw new PageSequenceMonitorException(this.getResolvedFailureMessage(matcher));
                }
                if (this.getSuccessPattern() != null) {
                    matcher = this.getSuccessPattern().matcher(responseString);
                    if (!matcher.find()) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("failed to find '" + this.getSuccessPattern() + "' in page content at " + uri + ":\n" + responseString.trim(), (Throwable)new Exception());
                        }
                        throw new PageSequenceMonitorException("failed to find '" + this.getSuccessPattern() + "' in page content at " + uri);
                    }
                    this.updateSequenceProperties(sequenceProperties, matcher);
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("unable to construct URL for page: " + e, e);
            }
            catch (IOException e) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("I/O Error " + e, (Throwable)e);
                }
                throw new PageSequenceMonitorException("I/O Error " + e, e);
            }
        }

        private List<NameValuePair> expandParms(MonitoredService svc) {
            Properties seqProps;
            ArrayList<NameValuePair> expandedParms = new ArrayList<NameValuePair>();
            Properties svcProps = this.getServiceProperties(svc);
            if (svcProps != null && this.log().isDebugEnabled()) {
                this.log().debug("I have " + svcProps.size() + " service properties.");
            }
            if ((seqProps = this.getSequenceProperties()) != null && this.log().isDebugEnabled()) {
                this.log().debug("I have " + seqProps.size() + " sequence properties.");
            }
            for (NameValuePair nvp : this.m_parms) {
                String value = PropertiesUtils.substitute((String)nvp.getValue(), (Properties[])new Properties[]{this.getServiceProperties(svc), this.getSequenceProperties()});
                expandedParms.add((NameValuePair)new BasicNameValuePair(nvp.getName(), value));
                if (!this.log().isDebugEnabled() || nvp.getValue().equals(value)) continue;
                this.log().debug("Expanded parm with name '" + nvp.getName() + "' from '" + nvp.getValue() + "' to '" + value + "'");
            }
            return expandedParms;
        }

        private void updateSequenceProperties(Properties props, Matcher matcher) {
            for (SessionVariable varBinding : this.m_page.getSessionVariableCollection()) {
                String vbName = varBinding.getName();
                String vbValue = matcher.group(varBinding.getMatchGroup());
                if (vbValue == null) {
                    vbValue = "";
                }
                props.put(vbName, vbValue);
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug("Just set session variable '" + vbName + "' to '" + vbValue + "'");
            }
            this.setSequenceProperties(props);
        }

        private String getUserAgent() {
            return this.m_page.getUserAgent();
        }

        private String getVirtualHost(MonitoredService svc) {
            return PropertiesUtils.substitute((String)this.m_page.getVirtualHost(), (Properties[])new Properties[]{this.getServiceProperties(svc), this.getSequenceProperties()});
        }

        private URI getURI(MonitoredService svc) throws URISyntaxException {
            Properties svcProps = this.getServiceProperties(svc);
            Properties seqProps = this.getSequenceProperties();
            return new URI(this.getScheme(), this.getUserInfo(), this.getHost(seqProps, svcProps), this.getPort(new Properties[0]), this.getPath(seqProps, svcProps), this.getQuery(seqProps, svcProps), this.getFragment(seqProps, svcProps));
        }

        private String getFragment(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getFragment(), (Properties[])p);
        }

        private String getQuery(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getQuery(), (Properties[])p);
        }

        private String getPath(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getPath(), (Properties[])p);
        }

        private int getPort(Properties ... p) {
            return Integer.valueOf(PropertiesUtils.substitute((String)String.valueOf(this.m_page.getPort()), (Properties[])p));
        }

        private String getHost(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getHost(), (Properties[])p);
        }

        private Properties getServiceProperties(MonitoredService svc) {
            Properties properties = new Properties();
            properties.put("ipaddr", svc.getIpAddr());
            properties.put("nodeid", (Object)svc.getNodeId());
            properties.put("nodelabel", svc.getNodeLabel());
            properties.put("svcname", svc.getSvcName());
            return properties;
        }

        private String getUserInfo() {
            return this.m_page.getUserInfo();
        }

        private String getScheme() {
            return this.m_page.getScheme();
        }

        private PageSequenceHttpUriRequest getMethod(URI uri) {
            String method = this.m_page.getMethod();
            return "GET".equalsIgnoreCase(method) ? new PageSequenceHttpGet(uri) : new PageSequenceHttpPost(uri);
        }

        private HttpResponseRange getRange() {
            return this.m_range;
        }

        private Pattern getSuccessPattern() {
            return this.m_successPattern;
        }

        private Pattern getLocationPattern() {
            return this.m_locationPattern;
        }

        private Pattern getFailurePattern() {
            return this.m_failurePattern;
        }

        private String getFailureMessage() {
            return this.m_page.getFailureMessage();
        }

        private String getResolvedFailureMessage(Matcher matcher) {
            return PropertiesUtils.substitute((String)this.getFailureMessage(), (PropertiesUtils.SymbolTable[])new PropertiesUtils.SymbolTable[]{new MatchTable(matcher)});
        }

        private Properties getSequenceProperties() {
            return this.m_parentSequence.getSequenceProperties();
        }

        private void setSequenceProperties(Properties props) {
            this.m_parentSequence.setSequenceProperties(props);
        }

        public Number getResponseTime() {
            return this.m_responseTime;
        }

        public String getDsName() {
            return this.m_page.getDsName();
        }

        private ThreadCategory log() {
            return ThreadCategory.getInstance(this.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageSequenceHttpGet
    extends HttpGet
    implements PageSequenceHttpUriRequest {
        public PageSequenceHttpGet(URI uri) {
            super(uri);
        }

        @Override
        public void setQueryParameters(List<NameValuePair> parms) {
            URI uri = this.getURI();
            URI uriWithQueryString = null;
            try {
                String query = URLEncodedUtils.format(parms, (String)"UTF-8");
                uriWithQueryString = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
            }
            catch (URISyntaxException e) {
                ThreadCategory.getInstance(this.getClass()).warn(e.getMessage(), (Throwable)e);
            }
            this.setURI(uriWithQueryString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageSequenceHttpPost
    extends HttpPost
    implements PageSequenceHttpUriRequest {
        public PageSequenceHttpPost(URI uri) {
            super(uri);
        }

        @Override
        public void setQueryParameters(List<NameValuePair> parms) {
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parms, "UTF-8");
                this.setEntity((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PageSequenceHttpUriRequest
    extends HttpUriRequest {
        public void setQueryParameters(List<NameValuePair> var1);
    }

    public static class HttpResponseRange {
        private static final Pattern RANGE_PATTERN = Pattern.compile("([1-5][0-9][0-9])(?:-([1-5][0-9][0-9]))?");
        private int m_begin;
        private int m_end;

        HttpResponseRange(String rangeSpec) {
            Matcher matcher = RANGE_PATTERN.matcher(rangeSpec);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid range spec: " + rangeSpec);
            }
            String beginSpec = matcher.group(1);
            String endSpec = matcher.group(2);
            this.m_begin = Integer.parseInt(beginSpec);
            this.m_end = endSpec == null ? this.m_begin : Integer.parseInt(endSpec);
        }

        public boolean contains(int responseCode) {
            return this.m_begin <= responseCode && responseCode <= this.m_end;
        }

        public String toString() {
            if (this.m_begin == this.m_end) {
                return Integer.toString(this.m_begin);
            }
            return Integer.toString(this.m_begin) + '-' + Integer.toString(this.m_end);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HttpPageSequence {
        PageSequence m_sequence;
        List<HttpPage> m_pages;
        Properties m_sequenceProperties;
        Map<String, String> m_parameters = new HashMap<String, String>();

        HttpPageSequence(PageSequence sequence) {
            this.m_sequence = sequence;
            this.m_pages = new ArrayList<HttpPage>(this.m_sequence.getPageCount());
            for (Page page : this.m_sequence.getPage()) {
                this.m_pages.add(new HttpPage(this, page));
            }
            this.m_sequenceProperties = new Properties();
        }

        public Map<String, String> getParameters() {
            return this.m_parameters;
        }

        public void setParameters(Map<String, String> parameters) {
            this.m_parameters = parameters;
        }

        List<HttpPage> getPages() {
            return this.m_pages;
        }

        private void execute(DefaultHttpClient client, MonitoredService svc, Map<String, Number> responseTimes) {
            this.clearSequenceProperties();
            for (HttpPage page : this.getPages()) {
                if (page.getDsName() == null) continue;
                responseTimes.put(page.getDsName(), Double.NaN);
            }
            for (HttpPage page : this.getPages()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Executing HttpPage: " + page.toString());
                }
                page.execute(client, svc, this.m_sequenceProperties);
                if (page.getDsName() == null) continue;
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Recording response time " + page.getResponseTime() + " for ds " + page.getDsName());
                }
                responseTimes.put(page.getDsName(), page.getResponseTime());
            }
        }

        protected Properties getSequenceProperties() {
            return this.m_sequenceProperties;
        }

        protected void setSequenceProperties(Properties newProps) {
            this.m_sequenceProperties = newProps;
        }

        protected void clearSequenceProperties() {
            this.m_sequenceProperties.clear();
        }

        private ThreadCategory log() {
            return ThreadCategory.getInstance(this.getClass());
        }
    }

    public static class PageSequenceMonitorException
    extends RuntimeException {
        private static final long serialVersionUID = 1346757238604080088L;

        public PageSequenceMonitorException(String message) {
            super(message);
        }

        public PageSequenceMonitorException(Throwable cause) {
            super(cause);
        }

        public PageSequenceMonitorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

