/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.passive;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.config.PassiveStatusKey;
import org.opennms.netmgt.config.PassiveStatusValue;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.xml.event.Event;

public class PassiveStatusKeeper
extends AbstractServiceDaemon
implements EventListener {
    private static PassiveStatusKeeper s_instance = new PassiveStatusKeeper();
    private static final String PASSIVE_STATUS_UEI = "uei.opennms.org/services/passiveServiceStatus";
    private volatile Map<PassiveStatusKey, PollStatus> m_statusTable = null;
    private volatile EventIpcManager m_eventMgr;
    private volatile boolean m_initialized = false;
    private DataSource m_dataSource;

    public PassiveStatusKeeper() {
        super("OpenNMS.PassiveStatusKeeper");
    }

    public PassiveStatusKeeper(EventIpcManager eventMgr) {
        this();
        this.setEventManager(eventMgr);
    }

    public static synchronized void setInstance(PassiveStatusKeeper psk) {
        s_instance = psk;
    }

    public static synchronized PassiveStatusKeeper getInstance() {
        return s_instance;
    }

    protected void onInit() {
        if (this.m_initialized) {
            return;
        }
        this.checkPreRequisites();
        this.createMessageSelectorAndSubscribe();
        this.m_statusTable = new HashMap<PassiveStatusKey, PollStatus>();
        String sql = "select node.nodeLabel AS nodeLabel, outages.ipAddr AS ipAddr, service.serviceName AS serviceName FROM outages JOIN node ON outages.nodeId = node.nodeId JOIN service ON outages.serviceId = service.serviceId WHERE outages.ifRegainedService is NULL";
        Querier querier = new Querier(this.m_dataSource, sql){

            public void processRow(ResultSet rs) throws SQLException {
                PassiveStatusKey key = new PassiveStatusKey(rs.getString("nodeLabel"), rs.getString("ipAddr"), rs.getString("serviceName"));
                PassiveStatusKeeper.this.m_statusTable.put(key, PollStatus.down());
            }
        };
        querier.execute(new Object[0]);
        this.m_initialized = true;
    }

    private void checkPreRequisites() {
        if (this.m_eventMgr == null) {
            throw new IllegalStateException("eventManager has not been set");
        }
        if (this.m_dataSource == null) {
            throw new IllegalStateException("dataSource has not been set");
        }
    }

    protected void onStop() {
        this.m_initialized = false;
        this.m_eventMgr = null;
        this.m_statusTable = null;
    }

    public void setStatus(String nodeLabel, String ipAddr, String svcName, PollStatus pollStatus) {
        this.checkInit();
        this.setStatus(new PassiveStatusKey(nodeLabel, ipAddr, svcName), pollStatus);
    }

    public void setStatus(PassiveStatusKey key, PollStatus pollStatus) {
        this.checkInit();
        this.m_statusTable.put(key, pollStatus);
    }

    private void checkInit() {
        if (!this.m_initialized) {
            throw new IllegalStateException("the service has not been intialized");
        }
    }

    public PollStatus getStatus(String nodeLabel, String ipAddr, String svcName) {
        PollStatus status = this.m_statusTable == null ? PollStatus.unknown() : this.m_statusTable.get(new PassiveStatusKey(nodeLabel, ipAddr, svcName));
        return status == null ? PollStatus.up() : status;
    }

    private void createMessageSelectorAndSubscribe() {
        this.getEventManager().addEventListener(this, PASSIVE_STATUS_UEI);
    }

    public void onEvent(Event e) {
        if (this.isPassiveStatusEvent(e)) {
            this.log().debug("onEvent: received valid registered passive status event: \n" + EventUtils.toString(e));
            PassiveStatusValue statusValue = this.getPassiveStatusValue(e);
            this.setStatus(statusValue.getKey(), statusValue.getStatus());
            this.log().debug("onEvent: passive status for: " + statusValue.getKey() + "is: " + this.m_statusTable.get(statusValue.getKey()));
        }
        if (!this.isPassiveStatusEvent(e)) {
            this.log().debug("onEvent: received Invalid registered passive status event: \n" + EventUtils.toString(e));
        }
    }

    private PassiveStatusValue getPassiveStatusValue(Event e) {
        return new PassiveStatusValue(EventUtils.getParm(e, "passiveNodeLabel"), EventUtils.getParm(e, "passiveIpAddr"), EventUtils.getParm(e, "passiveServiceName"), PollStatus.decode((String)EventUtils.getParm(e, "passiveStatus"), (String)EventUtils.getParm(e, "passiveReasonCode")));
    }

    boolean isPassiveStatusEvent(Event e) {
        return PASSIVE_STATUS_UEI.equals(e.getUei()) && EventUtils.getParm(e, "passiveNodeLabel") != null && EventUtils.getParm(e, "passiveIpAddr") != null && EventUtils.getParm(e, "passiveServiceName") != null && EventUtils.getParm(e, "passiveStatus") != null;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public DataSource getDbConnectoinFactory() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }
}

