/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.util.List;
import org.opennms.core.utils.Argument;
import org.opennms.netmgt.notifd.MicroblogNotificationStrategy;
import org.springframework.core.io.Resource;
import twitter4j.DirectMessage;
import twitter4j.Twitter;
import twitter4j.TwitterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroblogDMNotificationStrategy
extends MicroblogNotificationStrategy {
    public MicroblogDMNotificationStrategy() throws IOException {
    }

    public MicroblogDMNotificationStrategy(Resource configResource) {
        super(configResource);
    }

    @Override
    public int send(List<Argument> arguments) {
        DirectMessage response;
        Twitter svc = this.buildUblogService(arguments);
        String destUser = this.findDestName(arguments);
        if (destUser == null || "".equals(destUser)) {
            this.log().error("Cannot send a microblog DM notice to a user with no microblog username set. Either set a microblog username for this OpenNMS user or use the MicroblogUpdateNotificationStrategy instead.");
            return 1;
        }
        if (destUser.startsWith("@")) {
            destUser = destUser.substring(1);
        }
        String fullMessage = this.buildMessageBody(arguments);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Dispatching microblog DM notification for user '" + svc.getUserId() + "' at base URL '" + svc.getBaseURL() + "' with destination user '" + destUser + "' and message '" + fullMessage + "'");
        }
        try {
            response = svc.sendDirectMessage(destUser, fullMessage);
        }
        catch (TwitterException e) {
            this.log().error("Microblog notification failed");
            this.log().info("Failed to send DM for user '" + svc.getUserId() + "' at service URL '" + svc.getBaseURL() + "' to destination user '" + destUser + "', caught exception: " + e.getMessage());
            return 1;
        }
        this.log().info("Microblog DM notification succeeded: DM sent with ID " + response.getId());
        return 0;
    }
}

