/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.MatchTable;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.notifd.NotificationStrategy;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpNotificationStrategy
implements NotificationStrategy {
    private List<Argument> m_arguments;

    @Override
    public int send(List<Argument> arguments) {
        this.m_arguments = arguments;
        String url = this.getUrl();
        if (url == null) {
            this.log().warn("send: url argument is null, HttpNotification requires a URL");
            return 1;
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet method = null;
        List<NameValuePair> posts = this.getPostArguments();
        if (posts == null) {
            method = new HttpGet(url);
            this.log().info("send: No \"post-\" arguments..., continuing with an HTTP GET using URL: " + url);
        } else {
            this.log().info("send: Found \"post-\" arguments..., continuing with an HTTP POST using URL: " + url);
            for (Argument arg : this.m_arguments) {
                this.log().debug("send: post argument: " + arg.getSwitch() + " = " + arg.getValue());
            }
            method = new HttpPost(url);
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(posts, "UTF-8");
                ((HttpPost)method).setEntity((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        String contents = null;
        int statusCode = -1;
        try {
            try {
                HttpResponse response = client.execute((HttpUriRequest)method);
                statusCode = response.getStatusLine().getStatusCode();
                contents = EntityUtils.toString((HttpEntity)response.getEntity());
                this.log().info("send: Contents is: " + contents);
            }
            catch (IOException e) {
                this.log().error("send: IO problem with HTTP post/response: " + e);
                throw new RuntimeException("Problem with HTTP post: " + e.getMessage());
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            throw throwable;
        }
        this.doSql(contents);
        return statusCode;
    }

    private void doSql(String contents) {
        if (this.getSql() == null) {
            this.log().info("send: optional sql argument is null.");
            return;
        }
        if (contents == null) {
            this.log().info("doSql: HTTP reply is null");
            return;
        }
        this.log().debug("send: compiling expression: " + this.getSwitchValue("result-match"));
        Pattern p = Pattern.compile(this.getSwitchValue("result-match"));
        Matcher m = p.matcher(contents);
        if (m.matches()) {
            this.log().debug("send: compiled expression ready to run sql: " + this.getSql());
            MatchTable matches = new MatchTable(m);
            String sqlString = PropertiesUtils.substitute((String)this.getSql(), (PropertiesUtils.SymbolTable[])new PropertiesUtils.SymbolTable[]{matches});
            this.log().debug("send: running sql: " + sqlString);
            JdbcTemplate template = new JdbcTemplate(DataSourceFactory.getInstance());
            template.execute(sqlString);
        } else {
            this.log().info("send: result didn't match, not running sql");
        }
    }

    private List<NameValuePair> getPostArguments() {
        List<Argument> args = this.getArgsByPrefix("post-");
        ArrayList<NameValuePair> retval = new ArrayList<NameValuePair>();
        for (Argument arg : args) {
            String argSwitch = arg.getSwitch().substring("post-".length());
            if (arg.getValue() == null) {
                arg.setValue("");
            }
            retval.add((NameValuePair)new BasicNameValuePair(argSwitch, arg.getValue().equals("-tm") ? this.getMessage() : arg.getValue()));
        }
        return retval;
    }

    private String getMessage() {
        String message = "no notification text message defined for the \"-tm\" switch.";
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals("-tm")) continue;
            message = arg.getValue();
        }
        this.log().debug("getMessage: " + message);
        return message;
    }

    private List<Argument> getArgsByPrefix(String argPrefix) {
        ArrayList<Argument> args = new ArrayList<Argument>();
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().startsWith(argPrefix)) continue;
            args.add(arg);
        }
        return args;
    }

    private String getSql() {
        return this.getSwitchValue("sql");
    }

    private String getUrl() {
        return this.getSwitchValue("url");
    }

    private String getSwitchValue(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            value = arg.getValue();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

