/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.notifd.ExecutorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandExecutor
implements ExecutorStrategy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(String commandLine, List<Argument> arguments) {
        int returnCode = 0;
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(commandLine);
        StringBuffer streamBuffer = new StringBuffer();
        boolean streamed = false;
        for (Argument curArg : arguments) {
            if (!curArg.isStreamed()) {
                if (curArg.getSubstitution() != null && !curArg.getSubstitution().trim().equals("")) {
                    commandList.add(curArg.getSubstitution());
                }
                if (curArg.getValue() == null || curArg.getValue().trim().equals("")) continue;
                commandList.add(curArg.getValue());
                continue;
            }
            streamed = true;
            log.debug("streamed argument found");
            if (curArg.getSubstitution() != null && !curArg.getSubstitution().trim().equals("")) {
                streamBuffer.append(curArg.getSubstitution());
            }
            if (curArg.getValue().trim().equals("")) continue;
            streamBuffer.append(curArg.getValue());
            if (!log.isDebugEnabled()) continue;
            log.debug("Streamed argument value: " + curArg.getValue());
        }
        try {
            String[] commandArray = new String[commandList.size()];
            commandArray = commandList.toArray(commandArray);
            if (log.isDebugEnabled()) {
                StringBuffer list = new StringBuffer();
                list.append("{ ");
                for (int i = 0; i < commandArray.length; ++i) {
                    if (i != 0) {
                        list.append(", ");
                    }
                    list.append(commandArray[i]);
                }
                list.append(" }");
                log.debug(list.toString());
            }
            Process command = Runtime.getRuntime().exec(commandArray);
            if (streamed) {
                BufferedWriter processInput = new BufferedWriter(new OutputStreamWriter(command.getOutputStream(), "UTF-8"));
                if (log.isDebugEnabled()) {
                    log.debug("Streamed arguments: " + streamBuffer.toString());
                }
                processInput.write(streamBuffer.toString());
                processInput.flush();
                processInput.close();
            }
            long timeout = 30000L;
            long start = System.currentTimeMillis();
            String commandResult = "Command timed out (30 seconds)";
            while (System.currentTimeMillis() - start < timeout) {
                try {
                    returnCode = command.exitValue();
                    commandResult = "Command-line binary completed with return code " + returnCode;
                    break;
                }
                catch (IllegalThreadStateException e) {
                    CommandExecutor commandExecutor = this;
                    synchronized (commandExecutor) {
                        this.wait(1000L);
                    }
                }
            }
            log.debug(commandResult);
        }
        catch (IOException e) {
            log.error("Error executing command-line binary: " + commandLine, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("Error executing command-line binary: " + commandLine, (Throwable)e);
        }
        return returnCode;
    }
}

