/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.ArrayList;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.linkd.EventUtils;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

final class LinkdEventProcessor
implements EventListener,
InitializingBean {
    private EventIpcManager m_eventMgr;

    LinkdEventProcessor() {
    }

    public void close() {
        this.getEventMgr().removeEventListener(this);
    }

    private void createMessageSelectorAndSubscribe() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/nodeLostService");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/nodeRegainedService");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        this.getEventMgr().addEventListener(this, ueiList);
    }

    public String getName() {
        return "Linkd:LinkdEventProcessor";
    }

    private Linkd getLinkd() {
        return Linkd.getInstance();
    }

    private void handleNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.getLinkd().deleteNode((int)event.getNodeid());
    }

    private void handleInterfaceDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterfaceOrIfIndex(event);
        int ifIndex = -1;
        if (event.hasIfIndex()) {
            ifIndex = event.getIfIndex();
        }
        this.getLinkd().deleteInterface((int)event.getNodeid(), event.getInterface(), ifIndex);
    }

    private void handleNodeGainedService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.getLinkd().scheduleNodeCollection((int)event.getNodeid());
    }

    private void handleNodeLostService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.getLinkd().suspendNodeCollection((int)event.getNodeid());
    }

    private void handleRegainedService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.getLinkd().wakeUpNodeCollection((int)event.getNodeid());
    }

    public void onEvent(Event event) {
        try {
            int eventid = event.getDbid();
            String eventUei = event.getUei();
            if (eventUei == null) {
                return;
            }
            LogUtils.infof((Object)this, (String)"onEvent: Received event %s UEI %s", (Object[])new Object[]{eventid, eventUei});
            if (eventUei.equals("uei.opennms.org/nodes/nodeDeleted")) {
                LogUtils.infof((Object)this, (String)"onEvent: calling handleNodeDeleted for event %s", (Object[])new Object[]{eventid});
                this.handleNodeDeleted(event);
            } else if (eventUei.equals("uei.opennms.org/nodes/interfaceDeleted")) {
                LogUtils.infof((Object)this, (String)"onEvent: calling handleInterfaceDeleted for event %s", (Object[])new Object[]{eventid});
                this.handleInterfaceDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeLostService") && event.getService().equals("SNMP")) {
                LogUtils.infof((Object)this, (String)"onEvent: calling handleNodeLostService for event %s", (Object[])new Object[]{eventid});
                this.handleNodeLostService(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeRegainedService") && event.getService().equals("SNMP")) {
                LogUtils.infof((Object)this, (String)"onEvent: calling handleRegainedService for event %s", (Object[])new Object[]{eventid});
                this.handleRegainedService(event);
            } else if (eventUei.equals("uei.opennms.org/nodes/nodeGainedService") && event.getService().equals("SNMP")) {
                LogUtils.infof((Object)this, (String)"onEvent: calling handleNodeGainedService for event %s", (Object[])new Object[]{eventid});
                this.handleNodeGainedService(event);
            }
        }
        catch (InsufficientInformationException ex) {
            LogUtils.infof((Object)this, (Throwable)ex, (String)"onEvent: insufficient information in event, discarding it.", (Object[])new Object[0]);
        }
        catch (Throwable t) {
            LogUtils.warnf((Object)this, (Throwable)t, (String)"onEvent: operation failed for event: %s, discarding it.", (Object[])new Object[]{event.getUei()});
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_eventMgr != null ? 1 : 0) != 0, (String)"must set the eventMgr property");
        this.createMessageSelectorAndSubscribe();
    }

    public EventIpcManager getEventMgr() {
        return this.m_eventMgr;
    }

    public void setEventMgr(EventIpcManager mgr) {
        this.m_eventMgr = mgr;
    }
}

