/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.NotifdConfigManager;

public class NotifdConfigFactory
extends NotifdConfigManager {
    private static NotifdConfigFactory instance;
    private static boolean initialized;
    private File m_notifdConfFile;
    private long m_lastModified;

    private NotifdConfigFactory() {
    }

    public static synchronized NotifdConfigFactory getInstance() {
        if (!initialized) {
            throw new IllegalStateException("init() not called.");
        }
        return instance;
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (!initialized) {
            instance = new NotifdConfigFactory();
            instance.reload();
            initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        this.m_notifdConfFile = ConfigFileConstants.getFile((int)ConfigFileConstants.NOTIFD_CONFIG_FILE_NAME);
        FileInputStream configIn = null;
        try {
            configIn = new FileInputStream(this.m_notifdConfFile);
            this.m_lastModified = this.m_notifdConfFile.lastModified();
            this.parseXml(configIn);
        }
        finally {
            if (configIn != null) {
                IOUtils.closeQuietly((InputStream)configIn);
            }
        }
    }

    public static String getPrettyStatus() throws IOException, MarshalException, ValidationException {
        if (!initialized) {
            return "Unknown";
        }
        String status = "Unknown";
        status = NotifdConfigFactory.getInstance().getNotificationStatus();
        if (status.equals("on")) {
            status = "On";
        } else if (status.equals("off")) {
            status = "Off";
        }
        return status;
    }

    public void turnNotifdOn() throws MarshalException, ValidationException, IOException {
        this.sendEvent("uei.opennms.org/internal/notificationsTurnedOn");
        this.configuration.setStatus("on");
        this.saveCurrent();
    }

    public void turnNotifdOff() throws MarshalException, ValidationException, IOException {
        this.sendEvent("uei.opennms.org/internal/notificationsTurnedOff");
        this.configuration.setStatus("off");
        this.saveCurrent();
    }

    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_notifdConfFile), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
    }

    protected synchronized void update() throws IOException, MarshalException, ValidationException {
        if (this.m_lastModified != this.m_notifdConfFile.lastModified()) {
            NotifdConfigFactory.getInstance().reload();
        }
    }

    static {
        initialized = false;
    }
}

