/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.Serializable;
import java.util.Map;
import org.opennms.netmgt.dao.CastorObjectRetrievalFailureException;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceMonitorLocator
implements ServiceMonitorLocator,
Serializable {
    private static final long serialVersionUID = 1L;
    String m_serviceName;
    Class<? extends ServiceMonitor> m_serviceClass;

    public DefaultServiceMonitorLocator(String serviceName, Class<? extends ServiceMonitor> serviceClass) {
        this.m_serviceName = serviceName;
        this.m_serviceClass = serviceClass;
    }

    @Override
    public ServiceMonitor getServiceMonitor() {
        try {
            ServiceMonitor mon = this.m_serviceClass.newInstance();
            mon.initialize((Map)null);
            return mon;
        }
        catch (InstantiationException e) {
            throw new CastorObjectRetrievalFailureException("Unable to instantiate monitor for service " + this.m_serviceName + " with class-name " + this.m_serviceClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CastorObjectRetrievalFailureException("Illegal access trying to instantiate monitor for service " + this.m_serviceName + " with class-name " + this.m_serviceClass.getName(), (Throwable)e);
        }
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public String getServiceLocatorKey() {
        return this.m_serviceClass.getName();
    }
}

