/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionAttribute;
import org.opennms.netmgt.collectd.AbstractCollectionResource;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.collectd.CollectionAttributeType;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.Persister;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.NSClientDataCollectionConfigFactory;
import org.opennms.netmgt.config.NSClientPeerFactory;
import org.opennms.netmgt.config.nsclient.Attrib;
import org.opennms.netmgt.config.nsclient.NsclientCollection;
import org.opennms.netmgt.config.nsclient.Wpm;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.poller.nsclient.NSClientAgentConfig;
import org.opennms.netmgt.poller.nsclient.NsclientCheckParams;
import org.opennms.netmgt.poller.nsclient.NsclientException;
import org.opennms.netmgt.poller.nsclient.NsclientManager;
import org.opennms.netmgt.poller.nsclient.NsclientPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSClientCollector
implements ServiceCollector {
    private final HashMap<Integer, NSClientAgentState> m_scheduledNodes = new HashMap();

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, String> parameters) {
        String collectionName = parameters.get("collection");
        if (collectionName == null) {
            collectionName = parameters.get("nsclient-collection");
        }
        NsclientCollection collection = NSClientDataCollectionConfigFactory.getInstance().getNSClientCollection(collectionName);
        NSClientAgentState agentState = this.m_scheduledNodes.get(agent.getNodeId());
        NSClientCollectionSet collectionSet = new NSClientCollectionSet(agent);
        NSClientCollectionResource collectionResource = collectionSet.getResource();
        for (Wpm wpm : collection.getWpms().getWpm()) {
            NsclientManager manager;
            AttributeGroupType attribGroupType = new AttributeGroupType(wpm.getName(), "all");
            if (agentState.shouldCheckAvailability(wpm.getName(), wpm.getRecheckInterval())) {
                Object var19_23;
                this.log().debug("Checking availability of group " + wpm.getName());
                manager = null;
                try {
                    try {
                        manager = agentState.getManager();
                        manager.init();
                        NsclientCheckParams params = new NsclientCheckParams(wpm.getKeyvalue());
                        NsclientPacket result = manager.processCheckCommand("8", params);
                        manager.close();
                        boolean isAvailable = result.getResultCode() == 0;
                        agentState.setGroupIsAvailable(wpm.getName(), isAvailable);
                        this.log().debug("Group " + wpm.getName() + " is " + (isAvailable ? "" : "not") + "available ");
                    }
                    catch (NsclientException e) {
                        throw new NSClientCollectorException("Error checking group (" + wpm.getName() + ") availability", e);
                    }
                    var19_23 = null;
                    if (manager != null) {
                        manager.close();
                    }
                }
                catch (Throwable throwable) {
                    var19_23 = null;
                    if (manager != null) {
                        manager.close();
                    }
                    throw throwable;
                }
            }
            if (!agentState.groupIsAvailable(wpm.getName())) continue;
            try {
                manager = agentState.getManager();
                manager.init();
                for (Attrib attrib : wpm.getAttrib()) {
                    NsclientPacket result = null;
                    try {
                        NsclientCheckParams params = new NsclientCheckParams(attrib.getName());
                        result = manager.processCheckCommand("8", params);
                    }
                    catch (NsclientException e) {
                        this.log().info("unable to collect params for attribute '" + attrib.getName() + "'", (Throwable)e);
                    }
                    if (result == null) continue;
                    if (result.getResultCode() != 0) {
                        this.log().info("not writing parameters for attribute '" + attrib.getName() + "', state is not 'OK'");
                        continue;
                    }
                    NSClientCollectionAttributeType attribType = new NSClientCollectionAttributeType(attrib, attribGroupType);
                    collectionResource.setAttributeValue(attribType, result.getResponse());
                }
                manager.close();
            }
            catch (NsclientException e) {
                throw new NSClientCollectorException("Error collecting data", e);
            }
        }
        collectionSet.setStatus(1);
        return collectionSet;
    }

    @Override
    public void initialize(Map<String, String> parameters) {
        this.log().debug("initialize: Initializing NSClientCollector.");
        this.m_scheduledNodes.clear();
        this.initNSClientPeerFactory();
        this.initNSClientCollectionConfig();
        this.initDatabaseConnectionFactory();
        this.initializeRrdRepository();
    }

    private void initNSClientPeerFactory() {
        this.log().debug("initialize: Initializing NSClientPeerFactory");
        try {
            NSClientPeerFactory.init();
        }
        catch (MarshalException e) {
            this.log().fatal("initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal("initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().fatal("initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initNSClientCollectionConfig() {
        this.log().debug("initialize: Initializing collector: " + this.getClass());
        try {
            NSClientDataCollectionConfigFactory.init();
        }
        catch (MarshalException e) {
            this.log().fatal("initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal("initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (FileNotFoundException e) {
            this.log().fatal("initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().fatal("initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initializeRrdRepository() {
        this.log().debug("initializeRrdRepository: Initializing RRD repo from NSClientCollector...");
        this.initializeRrdDirs();
    }

    private void initializeRrdDirs() {
        File f = new File(NSClientDataCollectionConfigFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + DataCollectionConfigFactory.getInstance().getRrdPath());
        }
    }

    private void initDatabaseConnectionFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (IOException e) {
            this.log().fatal("initDatabaseConnectionFactory: IOException getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            this.log().fatal("initDatabaseConnectionFactory: Marshall Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal("initDatabaseConnectionFactory: Validation Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void initialize(CollectionAgent agent, Map<String, String> parameters) {
        this.log().debug("initialize: Initializing NSClient collection for agent: " + agent);
        Integer scheduledNodeKey = agent.getNodeId();
        NSClientAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            this.log().info("initialize: Not scheduling interface for NSClient collection: " + nodeState.getAddress());
            StringBuffer sb = new StringBuffer();
            sb.append("initialize service: ");
            sb.append(" for address: ");
            sb.append(nodeState.getAddress());
            sb.append(" already scheduled for collection on node: ");
            sb.append(agent);
            this.log().debug(sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        nodeState = new NSClientAgentState(agent.getInetAddress(), parameters);
        this.log().info("initialize: Scheduling interface for collection: " + nodeState.getAddress());
        this.m_scheduledNodes.put(scheduledNodeKey, nodeState);
    }

    @Override
    public void release() {
        this.m_scheduledNodes.clear();
    }

    @Override
    public void release(CollectionAgent agent) {
        Integer scheduledNodeKey = agent.getNodeId();
        NSClientAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            this.m_scheduledNodes.remove(scheduledNodeKey);
        }
    }

    @Override
    public RrdRepository getRrdRepository(String collectionName) {
        return NSClientDataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }

    private class NSClientGroupState {
        private boolean available = false;
        private Date lastChecked;

        public NSClientGroupState(boolean isAvailable) {
            this(isAvailable, new Date());
        }

        public NSClientGroupState(boolean isAvailable, Date lastChecked) {
            this.available = isAvailable;
            this.lastChecked = lastChecked;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public void setAvailable(boolean available) {
            this.available = available;
        }

        public Date getLastChecked() {
            return this.lastChecked;
        }

        public void setLastChecked(Date lastChecked) {
            this.lastChecked = lastChecked;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NSClientAgentState {
        private NsclientManager m_manager;
        private NSClientAgentConfig m_agentConfig;
        private String m_address;
        private HashMap<String, NSClientGroupState> m_groupStates = new HashMap();

        public NSClientAgentState(InetAddress address, Map<String, String> parameters) {
            this.m_address = address.getHostAddress();
            this.m_agentConfig = NSClientPeerFactory.getInstance().getAgentConfig(address);
            this.m_manager = new NsclientManager(this.m_address);
            this.m_manager.setPassword(this.m_agentConfig.getPassword());
            this.m_manager.setTimeout(this.m_agentConfig.getTimeout());
            this.m_manager.setPortNumber(this.m_agentConfig.getPort());
        }

        public String getAddress() {
            return this.m_address;
        }

        public NsclientManager getManager() {
            return this.m_manager;
        }

        public boolean groupIsAvailable(String groupName) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                return false;
            }
            return groupState.isAvailable();
        }

        public void setGroupIsAvailable(String groupName, boolean available) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                groupState = new NSClientGroupState(available);
            }
            groupState.setAvailable(available);
            this.m_groupStates.put(groupName, groupState);
        }

        public boolean shouldCheckAvailability(String groupName, int recheckInterval) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                return true;
            }
            Date lastchecked = groupState.getLastChecked();
            Date now = new Date();
            return now.getTime() - lastchecked.getTime() > (long)recheckInterval;
        }

        public void didCheckGroupAvailability(String groupName) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                NSClientCollector.this.log().warn("didCheckGroupAvailability called on a group without state - this is odd");
                return;
            }
            groupState.setLastChecked(new Date());
        }
    }

    public class NSClientCollectorException
    extends RuntimeException {
        public static final long serialVersionUID = 1L;

        NSClientCollectorException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    class NSClientCollectionSet
    implements CollectionSet {
        private int m_status = 2;
        private NSClientCollectionResource m_collectionResource;

        NSClientCollectionSet(CollectionAgent agent) {
            this.m_collectionResource = new NSClientCollectionResource(agent);
        }

        public int getStatus() {
            return this.m_status;
        }

        void setStatus(int status) {
            this.m_status = status;
        }

        public void visit(CollectionSetVisitor visitor) {
            visitor.visitCollectionSet(this);
            this.m_collectionResource.visit(visitor);
            visitor.completeCollectionSet(this);
        }

        public NSClientCollectionResource getResource() {
            return this.m_collectionResource;
        }

        public boolean ignorePersist() {
            return false;
        }
    }

    class NSClientCollectionResource
    extends AbstractCollectionResource {
        NSClientCollectionResource(CollectionAgent agent) {
            super(agent);
        }

        public int getType() {
            return -1;
        }

        public boolean rescanNeeded() {
            return false;
        }

        public boolean shouldPersist(ServiceParameters params) {
            return true;
        }

        public void setAttributeValue(CollectionAttributeType type, String value) {
            NSClientCollectionAttribute attr = new NSClientCollectionAttribute(this, type, type.getName(), value);
            this.addAttribute(attr);
        }

        public String getResourceTypeName() {
            return "node";
        }

        public String getInstance() {
            return null;
        }
    }

    class NSClientCollectionAttribute
    extends AbstractCollectionAttribute
    implements CollectionAttribute {
        String m_alias;
        String m_value;
        NSClientCollectionResource m_resource;
        CollectionAttributeType m_attribType;

        NSClientCollectionAttribute(NSClientCollectionResource resource, CollectionAttributeType attribType, String alias, String value) {
            this.m_resource = resource;
            this.m_attribType = attribType;
            this.m_alias = alias;
            this.m_value = value;
        }

        public CollectionAttributeType getAttributeType() {
            return this.m_attribType;
        }

        public String getName() {
            return this.m_alias;
        }

        public String getNumericValue() {
            return this.m_value;
        }

        public CollectionResource getResource() {
            return this.m_resource;
        }

        public String getStringValue() {
            return this.m_value;
        }

        public boolean shouldPersist(ServiceParameters params) {
            return true;
        }

        public String getType() {
            return this.m_attribType.getType();
        }

        public String toString() {
            return "NSClientCollectionAttribute " + this.m_alias + "=" + this.m_value;
        }
    }

    class NSClientCollectionAttributeType
    implements CollectionAttributeType {
        Attrib m_attribute;
        AttributeGroupType m_groupType;

        protected NSClientCollectionAttributeType(Attrib attribute, AttributeGroupType groupType) {
            this.m_groupType = groupType;
            this.m_attribute = attribute;
        }

        public AttributeGroupType getGroupType() {
            return this.m_groupType;
        }

        public void storeAttribute(CollectionAttribute attribute, Persister persister) {
            persister.persistNumericAttribute(attribute);
        }

        public String getName() {
            return this.m_attribute.getAlias();
        }

        public String getType() {
            return this.m_attribute.getType();
        }
    }
}

