/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebPlugin
extends AbstractPlugin {
    static Integer DEFAULT_TIMEOUT = 3000;
    static Integer DEFAULT_PORT = 80;
    static String DEFAULT_USER_AGENT = "OpenNMS WebMonitor";
    static String DEFAULT_PATH = "/";
    static String DEFAULT_USER = "admin";
    static String DEFAULT_PASSWORD = "admin";
    static String DEFAULT_HTTP_STATUS_RANGE = "100-399";

    @Override
    public String getProtocolName() {
        return null;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> map) {
        boolean retval;
        block12: {
            retval = false;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            try {
                block11: {
                    try {
                        HttpGet getMethod = new HttpGet(new URI(null, null, address.getHostAddress(), ParameterMap.getKeyedInteger(map, (String)"port", (int)DEFAULT_PORT), ParameterMap.getKeyedString(map, (String)"path", (String)DEFAULT_PATH), null, null));
                        httpClient.getParams().setParameter("http.connection.timeout", (Object)ParameterMap.getKeyedInteger(map, (String)"timeout", (int)DEFAULT_TIMEOUT));
                        httpClient.getParams().setParameter("http.socket.timeout", (Object)ParameterMap.getKeyedInteger(map, (String)"timeout", (int)DEFAULT_TIMEOUT));
                        httpClient.getParams().setParameter("http.useragent", (Object)ParameterMap.getKeyedString(map, (String)"user-agent", (String)DEFAULT_USER_AGENT));
                        httpClient.getParams().setParameter("http.virtual-host", (Object)new HttpHost(ParameterMap.getKeyedString(map, (String)"virtual-host", null), ParameterMap.getKeyedInteger(map, (String)"port", (int)DEFAULT_PORT)));
                        if (ParameterMap.getKeyedBoolean(map, (String)"http-1.0", (boolean)false)) {
                            httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
                        }
                        for (String okey : map.keySet()) {
                            String key = okey.toString();
                            if (!key.matches("header_[0-9]+$")) continue;
                            String headerName = ParameterMap.getKeyedString(map, (String)key, null);
                            String headerValue = ParameterMap.getKeyedString(map, (String)(key + "_value"), null);
                            getMethod.setHeader(headerName, headerValue);
                        }
                        if (ParameterMap.getKeyedBoolean(map, (String)"auth-enabled", (boolean)false)) {
                            httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(ParameterMap.getKeyedString(map, (String)"auth-user", (String)DEFAULT_USER), ParameterMap.getKeyedString(map, (String)"auth-password", (String)DEFAULT_PASSWORD)));
                            if (ParameterMap.getKeyedBoolean(map, (String)"auth-preemptive", (boolean)true)) {
                                HttpRequestInterceptor preemptiveAuth = new HttpRequestInterceptor(){

                                    public void process(HttpRequest request, HttpContext context) throws IOException {
                                        AuthScope authScope;
                                        Credentials creds;
                                        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                                        CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                                        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                                        if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                                            authState.setAuthScheme((AuthScheme)new BasicScheme());
                                            authState.setCredentials(creds);
                                        }
                                    }
                                };
                                httpClient.addRequestInterceptor(preemptiveAuth, 0);
                            }
                        }
                        HttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
                        Integer statusCode = response.getStatusLine().getStatusCode();
                        String expectedText = ParameterMap.getKeyedString(map, (String)"response-text", null);
                        retval = this.inRange(ParameterMap.getKeyedString(map, (String)"response-range", (String)DEFAULT_HTTP_STATUS_RANGE), statusCode);
                        if (expectedText == null) break block11;
                        String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                        if (expectedText.charAt(0) == '~') {
                            retval = responseText.matches(expectedText.substring(1));
                            break block11;
                        }
                        if (responseText.equals(expectedText)) {
                            retval = true;
                            break block11;
                        }
                        retval = false;
                    }
                    catch (IOException e) {
                        WebPlugin.log().info(e.getMessage(), (Throwable)e);
                        retval = false;
                        Object var12_14 = null;
                        break block12;
                    }
                    catch (URISyntaxException e) {
                        WebPlugin.log().info(e.getMessage(), (Throwable)e);
                        retval = false;
                        Object var12_15 = null;
                    }
                }
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                throw throwable;
            }
        }
        return retval;
    }

    protected static ThreadCategory log() {
        return ThreadCategory.getInstance(WebPlugin.class);
    }

    private boolean inRange(String range, Integer val) {
        String[] boundries = range.split("-");
        return val >= new Integer(boundries[0]) && val <= new Integer(boundries[1]);
    }
}

