/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.utils.XmlrpcUtil;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventUtils {
    public static void addEventListener(EventListener listener, List<String> ueiList) {
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener(listener, ueiList);
    }

    public static void checkEventId(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!e.hasDbid()) {
            throw new InsufficientInformationException("eventID is unavailable");
        }
    }

    public static void checkInterface(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getInterface() == null || e.getInterface().length() == 0) {
            throw new InsufficientInformationException("ipaddr for event is unavailable");
        }
    }

    public static boolean isNonIpInterface(String intf) {
        return intf == null || intf.length() == 0 || "0.0.0.0".equals(intf);
    }

    public static void checkInterfaceOrIfIndex(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("event is null");
        }
        if (!(e.getInterface() != null && e.getInterface().length() != 0 || e.hasIfIndex())) {
            throw new InsufficientInformationException("Neither ipaddr nor ifIndex for the event is available");
        }
    }

    public static void checkHost(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getHost() == null || e.getHost().length() == 0) {
            throw new InsufficientInformationException("host for event is unavailable");
        }
    }

    public static void checkNodeId(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!e.hasNodeid()) {
            throw new InsufficientInformationException("nodeid for event is unavailable");
        }
    }

    public static void checkService(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getService() == null || e.getService().length() == 0) {
            throw new InsufficientInformationException("service for event is unavailable");
        }
    }

    public static Event createDeleteInterfaceEvent(String source, long nodeId, String ipAddr, int ifIndex, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/deleteInterface");
        newEvent.setSource(source);
        if (ipAddr != null && ipAddr.length() != 0) {
            newEvent.setInterface(ipAddr);
        }
        newEvent.setNodeid(nodeId);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        if (ifIndex != -1) {
            newEvent.setIfIndex(ifIndex);
        }
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("txno");
        Value parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createDeleteNodeEvent(String source, long nodeId, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/deleteNode");
        newEvent.setSource(source);
        newEvent.setNodeid(nodeId);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("txno");
        Value parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createAssetInfoChangedEvent(String source, long nodeId, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/assetInfoChanged");
        newEvent.setSource(source);
        newEvent.setNodeid(nodeId);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("txno");
        Value parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createInterfaceDeletedEvent(String source, long nodeId, String ipAddr, long txNo) {
        return EventUtils.createInterfaceDeletedEvent(source, nodeId, ipAddr, -1, txNo);
    }

    public static Event createInterfaceDeletedEvent(String source, long nodeId, String ipAddr, int ifIndex, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/interfaceDeleted");
        newEvent.setSource(source);
        newEvent.setNodeid(nodeId);
        if (ipAddr != null && ipAddr.length() != 0) {
            newEvent.setInterface(ipAddr);
        }
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        if (ifIndex != -1) {
            newEvent.setIfIndex(ifIndex);
        }
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("txno");
        Value parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createNodeDeletedEvent(String source, long nodeId, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeDeleted");
        newEvent.setSource(source);
        newEvent.setNodeid(nodeId);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("txno");
        Value parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createServiceDeletedEvent(String source, long nodeId, String ipAddr, String service, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/serviceDeleted");
        newEvent.setSource(source);
        newEvent.setNodeid(nodeId);
        newEvent.setInterface(ipAddr);
        newEvent.setService(service);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("txno");
        Value parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static long getEventID(Event e) {
        long eventID = -1L;
        if (e.hasDbid()) {
            eventID = e.getDbid();
        }
        return eventID;
    }

    public static long getLongParm(Event e, String parmName, long defaultValue) {
        return org.opennms.netmgt.model.events.EventUtils.getLongParm((Event)e, (String)parmName, (long)defaultValue);
    }

    public static int getIntParm(Event e, String parmName, int defaultValue) {
        return org.opennms.netmgt.model.events.EventUtils.getIntParm((Event)e, (String)parmName, (int)defaultValue);
    }

    public static int getIntParm(Event e, String parmName) {
        return org.opennms.netmgt.model.events.EventUtils.getIntParm((Event)e, (String)parmName, (int)0);
    }

    public static long getNodeId(Event e) {
        long nodeID = -1L;
        if (e.hasNodeid()) {
            nodeID = e.getNodeid();
        }
        return nodeID;
    }

    public static String getParm(Event e, String parmName) {
        return org.opennms.netmgt.model.events.EventUtils.getParm((Event)e, (String)parmName);
    }

    public static String getParm(Event e, String parmName, String defaultValue) {
        return org.opennms.netmgt.model.events.EventUtils.getParm((Event)e, (String)parmName, (String)defaultValue);
    }

    public static void requireParm(Event e, String parmName) throws InsufficientInformationException {
        Parms parms = e.getParms();
        if (parms == null) {
            throw new InsufficientInformationException("parameter " + parmName + " required but but no parms are available.");
        }
        Enumeration parmEnum = parms.enumerateParm();
        while (parmEnum.hasMoreElements()) {
            Parm parm = (Parm)parmEnum.nextElement();
            if (!parmName.equals(parm.getParmName())) continue;
            if (parm.getValue() != null && parm.getValue().getContent() != null) {
                return;
            }
            throw new InsufficientInformationException("parameter " + parmName + " required but only null valued parms available");
        }
        throw new InsufficientInformationException("parameter " + parmName + " required but was not available");
    }

    public static void sendEvent(Event newEvent, String callerUei, long txNo, boolean isXmlRpcEnabled) {
        block3: {
            ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
            try {
                EventIpcManagerFactory.getIpcManager().sendNow(newEvent);
                if (log.isDebugEnabled()) {
                    log.debug("sendEvent: successfully sent event " + newEvent);
                }
            }
            catch (Throwable t) {
                log.warn("run: unexpected throwable exception caught during send to middleware", t);
                if (!isXmlRpcEnabled) break block3;
                int status = 2;
                XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, callerUei, "caught unexpected throwable exception.", status, "OpenNMS.Capsd");
            }
        }
    }

    public static Event createNodeAddedEvent(DbNodeEntry nodeEntry) {
        return EventUtils.createNodeAddedEvent(nodeEntry.getNodeId(), nodeEntry.getLabel(), String.valueOf(nodeEntry.getLabelSource()));
    }

    public static Event createNodeAddedEvent(int nodeId, String nodeLabel, String labelSource) {
        return EventUtils.createNodeAddedEvent("OpenNMS.Capsd", nodeId, nodeLabel, labelSource);
    }

    public static Event createNodeAddedEvent(String source, int nodeId, String nodeLabel, String labelSource) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("createAndSendNodeAddedEvent:  nodeId  " + nodeId);
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeAdded");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeId);
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        Value parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("nodelabelsource");
        parmValue = new Value();
        parmValue.setContent(labelSource);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createNodeGainedInterfaceEvent(DbNodeEntry nodeEntry, InetAddress ifaddr) {
        return EventUtils.createNodeGainedInterfaceEvent("OpenNMS.Capsd", nodeEntry.getNodeId(), ifaddr);
    }

    public static Event createNodeGainedInterfaceEvent(String source, int nodeId, InetAddress ifaddr) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("createAndSendNodeAddedEvent:  nodeId  " + nodeId);
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeGainedInterface");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeId);
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(ifaddr.getHostAddress());
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("iphostname");
        Value parmValue = new Value();
        parmValue.setContent(ifaddr.getHostName());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createNodeDeletedEvent(String source, int nodeId, String hostName, String nodeLabel, long txNo) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("createAndSendNodeDeletedEvent:  processing deleteNode event for nodeid:  " + nodeId);
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeDeleted");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeId);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        Value parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        if (nodeLabel != null && String.valueOf(txNo) != null) {
            newEvent.setParms(eventParms);
        }
        return newEvent;
    }

    public static Event createAndSendDeleteNodeEvent(String source, String nodeLabel, String hostName, long txNo) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("createdAndSendDeleteNodeEvent: processing deleteInterface event... ");
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/deleteNode");
        newEvent.setSource(source);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        Value parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createForceRescanEvent(String hostName, long nodeId) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("createdAndSendForceRescanEvent: processing forceRescan event... ");
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/forceRescan");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid(nodeId);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        return newEvent;
    }

    public static Event createAndSendInterfaceDeletedEvent(String source, int nodeId, String ipaddr, String hostName, long txNo) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("createAndSendInterfaceDeletedEvent:  processing deleteInterface event for interface: " + ipaddr + " at nodeid: " + nodeId);
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/interfaceDeleted");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeId);
        newEvent.setInterface(ipaddr);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("txno");
        Value parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createNodeGainedServiceEvent(DbNodeEntry nodeEntry, InetAddress ifaddr, String service, long txNo) {
        int nodeId = nodeEntry.getNodeId();
        String nodeLabel = nodeEntry.getLabel();
        String labelSource = String.valueOf(nodeEntry.getLabelSource());
        String sysName = nodeEntry.getSystemName();
        String sysDescr = nodeEntry.getSystemDescription();
        return EventUtils.createNodeGainedServiceEvent("OpenNMS.Capsd", nodeId, ifaddr, service, nodeLabel, labelSource, sysName, sysDescr);
    }

    public static Event createNodeGainedServiceEvent(String source, int nodeId, InetAddress ifaddr, String service, String nodeLabel, String labelSource, String sysName, String sysDescr) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("createAndSendNodeGainedServiceEvent:  nodeId/interface/service  " + nodeId + "/" + ifaddr.getHostAddress() + "/" + service);
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeGainedService");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeId);
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(ifaddr.getHostAddress());
        newEvent.setService(service);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("iphostname");
        Value parmValue = new Value();
        parmValue.setContent(ifaddr.getHostName());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("nodelabelsource");
        parmValue = new Value();
        parmValue.setContent(labelSource);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        if (sysName != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysname");
            parmValue = new Value();
            parmValue.setContent(sysName);
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (sysDescr != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysdescription");
            parmValue = new Value();
            parmValue.setContent(sysDescr);
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createAndSendDeleteServiceEvent(String source, DbNodeEntry nodeEntry, InetAddress ifaddr, String service, String hostName, long txNo) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("createAndSendDeleteServiceEvent:  nodeId/interface/service  " + nodeEntry.getNodeId() + "/" + ifaddr.getHostAddress() + "/" + service);
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/deleteService");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeEntry.getNodeId());
        newEvent.setHost(hostName);
        newEvent.setInterface(ifaddr.getHostAddress());
        newEvent.setService(service);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("iphostname");
        Value parmValue = new Value();
        parmValue.setContent(ifaddr.getHostName());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        parmValue.setContent(nodeEntry.getLabel());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("nodelabelsource");
        parmValue = new Value();
        char[] labelSource = new char[]{nodeEntry.getLabelSource()};
        parmValue.setContent(new String(labelSource));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createAddInterfaceEvent(String source, String nodeLabel, String ipaddr, String hostName, long txNo) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("createAndSendAddInterfaceEvent:  processing updateServer event for interface:  " + ipaddr + " on server: " + hostName);
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/addInterface");
        newEvent.setSource(source);
        newEvent.setInterface(ipaddr);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        Value parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createAndSendDeleteInterfaceEvent(String source, String nodeLabel, String ipaddr, String hostName, long txNo) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("createAndSendDeleteInterfaceEvent:  processing updateServer event for interface:  " + ipaddr + " on server: " + hostName);
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/deleteInterface");
        newEvent.setSource(source);
        newEvent.setInterface(ipaddr);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        Value parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createChangeServiceEvent(String source, String ipaddr, String service, String action, String hostName, long txNo) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("createAndSendChangeServiceEvent:  processing updateService event for service:  " + service + " on interface: " + ipaddr);
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/changeService");
        newEvent.setSource(source);
        newEvent.setInterface(ipaddr);
        newEvent.setService(service);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("action");
        Value parmValue = new Value();
        parmValue.setContent(action);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createDeleteServiceEvent(String source, long nodeId, String ipAddr, String service, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/deleteService");
        newEvent.setSource(source);
        newEvent.setInterface(ipAddr);
        newEvent.setNodeid(nodeId);
        newEvent.setService(service);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        eventParm.setParmName("txno");
        Value parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static String toString(Event event) {
        return org.opennms.netmgt.model.events.EventUtils.toString((Event)event);
    }

    public static String toString(Value value) {
        return org.opennms.netmgt.model.events.EventUtils.toString((Value)value);
    }

    public static String toString(Snmp snmp) {
        return org.opennms.netmgt.model.events.EventUtils.toString((Snmp)snmp);
    }

    public static String toString(Parms parms) {
        return org.opennms.netmgt.model.events.EventUtils.toString((Parms)parms);
    }

    public static void addParam(Event event, String parmName, Object pollResultId) {
        Parms eventParms = event.getParms();
        if (eventParms == null) {
            eventParms = new Parms();
            event.setParms(eventParms);
        }
        Parm eventParm = new Parm();
        eventParm.setParmName(parmName);
        Value parmValue = new Value();
        parmValue.setContent(String.valueOf(pollResultId));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
    }
}

