/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vulnscand;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.vulnscand.ScheduleTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Scheduler
implements Runnable,
PausableFiber {
    private static final String FIBER_NAME = "Vulnscand Scheduler";
    private int m_status;
    private Thread m_worker;
    private LinkedHashMap<Object, ScheduleTrigger<Runnable>> m_triggers;
    private long m_initialSleep;
    private FifoQueue<Runnable> m_scheduledScanQ;

    Scheduler(FifoQueue<Runnable> rescanQ) throws SQLException {
        this.m_scheduledScanQ = rescanQ;
        this.m_status = 0;
        this.m_worker = null;
        this.m_triggers = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Object key, ScheduleTrigger<Runnable> trigger) {
        Object object = this.getSchedulerLock();
        synchronized (object) {
            this.m_triggers.put(key, trigger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unschedule(Object key) {
        Object object = this.getSchedulerLock();
        synchronized (object) {
            ScheduleTrigger addressInfo = (ScheduleTrigger)this.m_triggers.remove(key);
            this.log().debug("unscheduleAddress: removing node " + addressInfo + " from the scheduler.");
        }
    }

    ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    void unscheduleAddress(InetAddress address) {
        this.unschedule(address);
    }

    public static InetAddress toInetAddress(long address) throws UnknownHostException {
        StringBuffer buf = new StringBuffer();
        buf.append((int)(address >>> 24 & 0xFFL)).append('.');
        buf.append((int)(address >>> 16 & 0xFFL)).append('.');
        buf.append((int)(address >>> 8 & 0xFFL)).append('.');
        buf.append((int)(address & 0xFFL));
        return InetAddress.getByName(buf.toString());
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already run or is running");
        }
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        this.m_status = 1;
        this.log().debug("Scheduler.start: scheduler started");
    }

    public synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        this.m_status = 3;
        this.m_worker.interrupt();
        this.log().debug("Scheduler.stop: scheduler stopped");
    }

    public synchronized void pause() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 6) {
            return;
        }
        this.m_status = 5;
        this.notifyAll();
    }

    public synchronized void resume() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 2) {
            return;
        }
        this.m_status = 7;
        this.notifyAll();
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return FIBER_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.m_status = 2;
        }
        this.log().debug("Scheduler.run: scheduler running");
        boolean firstPass = true;
        while (true) {
            Scheduler scheduler2 = this;
            synchronized (scheduler2) {
                if (this.m_status != 2 && this.m_status != 6 && this.m_status != 5 && this.m_status != 7) {
                    this.log().debug("Scheduler.run: status = " + this.m_status + ", time to exit");
                    break;
                }
            }
            if (firstPass) {
                firstPass = false;
                scheduler2 = this;
                synchronized (scheduler2) {
                    try {
                        this.log().debug("Scheduler.run: initial sleep configured for " + this.getInitialSleep() + "ms...sleeping...");
                        this.wait(this.getInitialSleep());
                    }
                    catch (InterruptedException ex) {
                        this.log().debug("Scheduler.run: interrupted exception during initial sleep...exiting.");
                        break;
                    }
                }
            }
            int added = 0;
            Object object = this.getSchedulerLock();
            synchronized (object) {
                this.log().debug("Scheduler.run: iterating over known nodes list to schedule...");
                for (ScheduleTrigger<Runnable> addressInfo : this.getTriggerList()) {
                    this.log().debug("Scheduler.run: working on " + addressInfo);
                    if (addressInfo.isScheduled() || !addressInfo.isTimeForRescan()) continue;
                    try {
                        addressInfo.setScheduled(true);
                        this.log().debug("Scheduler.run: adding node " + addressInfo + " to the rescan queue.");
                        this.m_scheduledScanQ.add((Object)addressInfo.getJob());
                        ++added;
                    }
                    catch (InterruptedException ex) {
                        this.log().info("Scheduler.schedule: failed to add new node to rescan queue", (Throwable)ex);
                        throw new UndeclaredThrowableException(ex);
                    }
                    catch (FifoQueueException ex) {
                        this.log().info("Scheduler.schedule: failed to add new node to rescan queue", (Throwable)ex);
                        throw new UndeclaredThrowableException(ex);
                    }
                }
            }
            object = this;
            synchronized (object) {
                if (added == 0) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
        this.log().debug("Scheduler.run: scheduler exiting, state = STOPPED");
        Scheduler scheduler3 = this;
        synchronized (scheduler3) {
            this.m_status = 4;
        }
    }

    private Object getSchedulerLock() {
        return this.m_triggers;
    }

    private Collection<ScheduleTrigger<Runnable>> getTriggerList() {
        return this.m_triggers.values();
    }

    void setInitialSleep(long initialSleep) {
        this.m_initialSleep = initialSleep;
    }

    long getInitialSleep() {
        return this.m_initialSleep;
    }
}

