/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class EmailAddress {
    private String address;
    private String username;
    private String server;
    private String domain;
    private String tld;

    public EmailAddress() {
    }

    public EmailAddress(String newAddress) {
        this.address = newAddress;
        this.username = this.address.substring(0, this.address.indexOf("@"));
        String addressTail = this.address.substring(this.address.indexOf("@") + 1, this.address.length());
        StringTokenizer tokens = new StringTokenizer(addressTail, ".");
        ArrayList<String> tokenList = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            tokenList.add(tokens.nextToken());
        }
        this.tld = (String)tokenList.get(tokenList.size() - 1);
        this.domain = (String)tokenList.get(tokenList.size() - 2);
        if (tokenList.size() - 3 >= 0) {
            String serverParts = (String)tokenList.get(tokenList.size() - 3);
            for (int i = tokenList.size() - 4; i >= 0; --i) {
                serverParts = (String)tokenList.get(i) + "." + serverParts;
            }
            this.server = serverParts;
        } else {
            this.server = null;
        }
    }

    public String getAddress() {
        return this.username + "@" + (this.server != null ? this.server + "." : "") + this.domain + "." + this.tld;
    }

    public String getUsername() {
        return this.username;
    }

    public String getServer() {
        return this.server;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getTld() {
        return this.tld;
    }

    public void setUsername(String name) {
        this.username = name;
    }

    public void setServer(String newServer) {
        this.server = newServer;
    }

    public void setDomain(String newDomain) {
        this.domain = newDomain;
    }

    public void setTld(String newTld) {
        this.tld = newTld;
    }
}

