/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.translator.jmx;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.EventTranslatorConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.translator.jmx.EventTranslatorMBean;

public class EventTranslator
extends AbstractServiceDaemon
implements EventTranslatorMBean {
    public static final String NAME = "OpenNMS.EventTranslator";

    public EventTranslator() {
        super(NAME);
    }

    protected void onInit() {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        try {
            DataSourceFactory.init();
            EventTranslatorConfigFactory.init();
        }
        catch (MarshalException e) {
            log.error("Could not unmarshall configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            log.error("validation error ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            log.error("IOException: ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to initialize database: " + e.getMessage(), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            log.error("SQLException: ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            log.error("PropertyVetoException: ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        EventIpcManagerFactory.init();
        EventIpcManager mgr = EventIpcManagerFactory.getIpcManager();
        org.opennms.netmgt.translator.EventTranslator keeper = this.getEventTranslator();
        keeper.setConfig(EventTranslatorConfigFactory.getInstance());
        keeper.setEventManager(mgr);
        keeper.setDataSource(DataSourceFactory.getInstance());
        keeper.init();
    }

    protected void onStart() {
        this.getEventTranslator().start();
    }

    protected void onStop() {
        this.getEventTranslator().stop();
    }

    public int getStatus() {
        return this.getEventTranslator().getStatus();
    }

    private org.opennms.netmgt.translator.EventTranslator getEventTranslator() {
        return org.opennms.netmgt.translator.EventTranslator.getInstance();
    }
}

