/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.collectd.AliasedResource;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdingSet;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorThresholdingSet
extends ThresholdingSet {
    boolean storeByIfAlias = false;

    public CollectorThresholdingSet(int nodeId, String hostAddress, String serviceName, RrdRepository repository, long interval, Map<String, String> params) {
        super(nodeId, hostAddress, serviceName, repository, interval);
        String storeByIfAliasString = params.get("storeByIfAlias");
        this.storeByIfAlias = storeByIfAliasString != null && storeByIfAliasString.toLowerCase().equals("true");
    }

    public boolean hasThresholds(CollectionAttribute attribute) {
        CollectionResource resource = attribute.getResource();
        if (!this.isCollectionEnabled(attribute.getResource())) {
            return false;
        }
        if (resource instanceof AliasedResource && !this.storeByIfAlias) {
            return false;
        }
        return this.hasThresholds(resource.getResourceTypeName(), attribute.getName());
    }

    public List<Event> applyThresholds(CollectionResource resource, Map<String, CollectionAttribute> attributesMap) {
        if (!this.isCollectionEnabled(resource)) {
            this.log().debug("applyThresholds: Ignoring resource " + resource + " because data collection is disabled for this resource.");
            return new LinkedList<Event>();
        }
        CollectionResourceWrapper resourceWrapper = new CollectionResourceWrapper(this.m_interval, this.m_nodeId, this.m_hostAddress, this.m_serviceName, this.m_repository, resource, attributesMap);
        return this.applyThresholds(resourceWrapper, attributesMap);
    }

    @Override
    protected boolean passedThresholdFilters(CollectionResourceWrapper resource, ThresholdEntity thresholdEntity) {
        if (resource.isAnInterfaceResource() && !resource.isValidInterfaceResource()) {
            this.log().info("passedThresholdFilters: Could not get data interface information for '" + resource.getIfLabel() + "' or this interface has an invalid ifIndex.  Not evaluating threshold.");
            return false;
        }
        return super.passedThresholdFilters(resource, thresholdEntity);
    }

    protected boolean isCollectionEnabled(CollectionResource resource) {
        if (resource instanceof IfInfo) {
            return ((IfInfo)resource).isCollectionEnabled();
        }
        return true;
    }
}

