/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.syslogd.ConvertToEvent;
import org.opennms.netmgt.syslogd.MessageDiscardedException;
import org.opennms.netmgt.syslogd.SyslogHandler;

public class SyslogConnection
implements Runnable {
    private DatagramPacket _packet;
    private String m_logPrefix;
    private String _matchPattern;
    private int _hostGroup;
    private int _messageGroup;
    private String _discardUei;
    private UeiList _ueiList;
    private HideMessage _hideMessages;
    private static final String LOG4J_CATEGORY = "OpenNMS.Syslogd";

    public SyslogConnection(DatagramPacket packet, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessages, String discardUei) {
        this._packet = this.copyPacket(packet);
        this._matchPattern = matchPattern;
        this._hostGroup = hostGroup;
        this._messageGroup = messageGroup;
        this._discardUei = discardUei;
        this._ueiList = ueiList;
        this._hideMessages = hideMessages;
        this.m_logPrefix = LOG4J_CATEGORY;
    }

    public void run() {
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        ConvertToEvent re = null;
        try {
            re = ConvertToEvent.make(this._packet, this._matchPattern, this._hostGroup, this._messageGroup, this._ueiList, this._hideMessages, this._discardUei);
        }
        catch (UnsupportedEncodingException e1) {
            log.debug("Failure to convert package", (Throwable)e1);
        }
        catch (MessageDiscardedException e) {
            log.debug("Message discarded, returning without enqueueing event.", (Throwable)e);
            return;
        }
        log.debug("Sending received packet to the queue");
        SyslogHandler.queueManager.putInQueue(re);
        try {
            Thread.sleep(new Random().nextInt(100));
        }
        catch (InterruptedException e) {
            log.debug("Syslogd: Interruption ", (Throwable)e);
        }
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    private DatagramPacket copyPacket(DatagramPacket packet) {
        byte[] message = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, message, 0, packet.getLength());
        InetAddress addr = null;
        try {
            addr = InetAddress.getByAddress(packet.getAddress().getHostName(), packet.getAddress().getAddress());
            DatagramPacket retPacket = new DatagramPacket(message, packet.getOffset(), packet.getLength(), addr, packet.getPort());
            return retPacket;
        }
        catch (UnknownHostException e) {
            ThreadCategory.getInstance(this.getClass()).warn("unable to clone InetAddress object for " + packet.getAddress());
            return null;
        }
    }
}

