/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.RTCConfigFactory;
import org.opennms.netmgt.rtc.datablock.HttpPostInfo;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.opennms.netmgt.rtc.utils.EuiLevelMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataSender
implements Fiber {
    private Map<String, RTCCategory> m_categories;
    private Map<String, Set<HttpPostInfo>> m_catUrlMap;
    private RunnableConsumerThreadPool m_dsrPool;
    private FifoQueue<Runnable> m_dataSenderQ;
    private EuiLevelMapper m_euiMapper;
    private final int POST_ERROR_LIMIT;
    private int m_status;

    private int setCurrentThreadPriority(int priority) {
        int oldPriority;
        block2: {
            Thread currentThread = Thread.currentThread();
            oldPriority = currentThread.getPriority();
            try {
                currentThread.setPriority(priority);
            }
            catch (Exception e) {
                if (!this.log().isDebugEnabled()) break block2;
                this.log().debug("Error setting thread priority: ", (Throwable)e);
            }
        }
        return oldPriority;
    }

    public DataSender(Map<String, RTCCategory> categories, int numSenders) {
        this.m_categories = categories;
        this.m_catUrlMap = new HashMap<String, Set<HttpPostInfo>>();
        this.m_dsrPool = new RunnableConsumerThreadPool("DataSenderPool", 0.6f, 1.0f, numSenders);
        this.m_dataSenderQ = this.m_dsrPool.getRunQueue();
        this.m_euiMapper = new EuiLevelMapper();
        this.POST_ERROR_LIMIT = RTCConfigFactory.getInstance().getErrorsBeforeUrlUnsubscribe();
    }

    public synchronized void start() {
        this.m_status = 1;
        this.log().info("Starting the datasender thread pool..");
        try {
            this.m_dsrPool.start();
            this.log().info("Datasender thread pool started..");
        }
        catch (Exception e) {
            this.log().error("Error starting data sender pool", (Throwable)e);
        }
        this.m_status = 2;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public synchronized void stop() {
        this.m_status = 3;
        this.log().info("DataSender - shutting down the data sender pool");
        try {
            this.m_dsrPool.stop();
        }
        catch (Exception e) {
            this.log().error("Error shutting down data sender pool", (Throwable)e);
        }
        this.m_status = 4;
        this.log().info("DataSender shutdown complete");
    }

    public String getName() {
        return "OpenNMS.RTC.DataSender";
    }

    public int getStatus() {
        return this.m_status;
    }

    /*
     * Exception decompiling
     */
    public synchronized void subscribe(String url, String catlabel, String user, String passwd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void unsubscribe(String urlStr) {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException mue) {
            this.log().warn("ERROR unsubscribing: Invalid URL: " + url);
            return;
        }
        for (String key : this.m_catUrlMap.keySet()) {
            Set<HttpPostInfo> value = this.m_catUrlMap.get(key);
            if (value == null) continue;
            Iterator<HttpPostInfo> postSet = value.iterator();
            while (postSet.hasNext()) {
                HttpPostInfo postInfo = postSet.next();
                if (!url.equals(postInfo.getURL())) continue;
                postSet.remove();
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("Unsubscribed URL: " + url);
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized void sendData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void notifyToSend() {
        try {
            this.m_dataSenderQ.add((Object)new SendRequest());
        }
        catch (InterruptedException iE) {
            this.log().warn("Unable to queue datasender to the dsConsumer queue", (Throwable)iE);
        }
        catch (FifoQueueException qE) {
            this.log().warn("Unable to queue datasender to the dsConsumer queue", (Throwable)qE);
        }
    }

    private class SendRequest
    implements Runnable {
        private SendRequest() {
        }

        public void run() {
            DataSender.this.sendData();
        }
    }
}

