/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

@Distributable
public class WebMonitor
extends IPv4Monitor {
    static Integer DEFAULT_TIMEOUT = 3000;
    static Integer DEFAULT_PORT = 80;
    static String DEFAULT_USER_AGENT = "OpenNMS WebMonitor";
    static String DEFAULT_PATH = "/";
    static String DEFAULT_USER = "admin";
    static String DEFAULT_PASSWORD = "admin";
    static String DEFAULT_HTTP_STATUS_RANGE = "100-399";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map map) {
        PollStatus pollStatus = PollStatus.unresponsive();
        HttpClient httpClient = new HttpClient();
        HostConfiguration hostConfig = new HostConfiguration();
        GetMethod getMethod = new GetMethod(ParameterMap.getKeyedString((Map)map, (String)"path", (String)DEFAULT_PATH));
        httpClient.getParams().setParameter("http.socket.timeout", (Object)ParameterMap.getKeyedInteger((Map)map, (String)"timeout", (int)DEFAULT_TIMEOUT));
        httpClient.getParams().setParameter("http.useragent", (Object)ParameterMap.getKeyedString((Map)map, (String)"user-agent", (String)DEFAULT_USER_AGENT));
        hostConfig.setHost(svc.getAddress().getHostAddress(), ParameterMap.getKeyedInteger((Map)map, (String)"port", (int)DEFAULT_PORT));
        hostConfig.getParams().setParameter("http.virtual-host", (Object)ParameterMap.getKeyedString((Map)map, (String)"virtual-host", null));
        if (ParameterMap.getKeyedBoolean((Map)map, (String)"http-1.0", (boolean)false)) {
            httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        }
        for (Object okey : map.keySet()) {
            String key = okey.toString();
            if (!key.matches("header_[0-9]+$")) continue;
            String headerName = ParameterMap.getKeyedString((Map)map, (String)key, null);
            String headerValue = ParameterMap.getKeyedString((Map)map, (String)(key + "_value"), null);
            getMethod.setRequestHeader(headerName, headerValue);
        }
        if (ParameterMap.getKeyedBoolean((Map)map, (String)"auth-enabled", (boolean)false)) {
            httpClient.getParams().setAuthenticationPreemptive(ParameterMap.getKeyedBoolean((Map)map, (String)"auth-preemptive", (boolean)true));
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(ParameterMap.getKeyedString((Map)map, (String)"auth-user", (String)DEFAULT_USER), ParameterMap.getKeyedString((Map)map, (String)"auth-password", (String)DEFAULT_PASSWORD)));
        }
        try {
            this.log().debug("httpClient request with the following parameters: " + httpClient);
            this.log().debug("hostConfig parameters: " + hostConfig);
            this.log().debug("getMethod parameters: " + getMethod);
            httpClient.executeMethod(hostConfig, (HttpMethod)getMethod);
            Integer statusCode = getMethod.getStatusCode();
            String statusText = getMethod.getStatusText();
            String expectedText = ParameterMap.getKeyedString((Map)map, (String)"response-text", null);
            this.log().debug("returned results are:");
            pollStatus = !this.inRange(ParameterMap.getKeyedString((Map)map, (String)"response-range", (String)DEFAULT_HTTP_STATUS_RANGE), statusCode) ? PollStatus.unavailable((String)statusText) : PollStatus.available();
            if (expectedText != null) {
                String responseText = getMethod.getResponseBodyAsString();
                pollStatus = expectedText.charAt(0) == '~' ? (!responseText.matches(expectedText.substring(1)) ? PollStatus.unavailable((String)"Regex Failed") : PollStatus.available()) : (expectedText.equals(responseText) ? PollStatus.available() : PollStatus.unavailable((String)"Did not find expected Text"));
            }
        }
        catch (HttpException e) {
            this.log().info(e.getMessage());
        }
        catch (IOException e) {
            this.log().info(e.getMessage());
        }
        finally {
            getMethod.releaseConnection();
        }
        return pollStatus;
    }

    private boolean inRange(String range, Integer val) {
        String[] boundries = range.split("-");
        return val >= new Integer(boundries[0]) && val <= new Integer(boundries[1]);
    }
}

