/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class SmtpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 25;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static String LOCALHOST_NAME;
    private static RE MULTILINE;
    private RE ENDMULTILINE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)25);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", " + tracker);
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            block67: {
                Socket socket = null;
                try {
                    StringTokenizer t;
                    int rc;
                    tracker.startAttempt();
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                    socket.setSoTimeout(tracker.getSoTimeout());
                    this.log().debug("SmtpMonitor: connected to host: " + ipv4Addr + " on port: " + port);
                    serviceStatus = PollStatus.unresponsive();
                    BufferedReader rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    String banner = rdr.readLine();
                    if (banner == null) break block67;
                    if (MULTILINE.match(banner)) {
                        String multiLineRC = new String(banner.getBytes(), 0, 3) + " ";
                        try {
                            this.ENDMULTILINE = new RE(multiLineRC);
                        }
                        catch (RESyntaxException ex) {
                            throw new UndeclaredThrowableException(ex);
                        }
                        while ((banner = rdr.readLine()) != null && !this.ENDMULTILINE.match(banner)) {
                        }
                        if (banner == null) break block67;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("poll: banner = " + banner);
                    }
                    if ((rc = Integer.parseInt((t = new StringTokenizer(banner)).nextToken())) == 220) {
                        String multiLineRC;
                        String cmd = "HELO " + LOCALHOST_NAME + "\r\n";
                        socket.getOutputStream().write(cmd.getBytes());
                        String response = rdr.readLine();
                        double responseTime = tracker.elapsedTimeInMillis();
                        if (response == null) break block67;
                        if (MULTILINE.match(response)) {
                            multiLineRC = new String(response.getBytes(), 0, 3) + " ";
                            try {
                                this.ENDMULTILINE = new RE(multiLineRC);
                            }
                            catch (RESyntaxException ex) {
                                throw new UndeclaredThrowableException(ex);
                            }
                            while ((response = rdr.readLine()) != null && !this.ENDMULTILINE.match(response)) {
                            }
                            if (response == null) break block67;
                        }
                        if ((rc = Integer.parseInt((t = new StringTokenizer(response)).nextToken())) == 250) {
                            cmd = "QUIT\r\n";
                            socket.getOutputStream().write(cmd.getBytes());
                            response = rdr.readLine();
                            if (response == null) break block67;
                            if (MULTILINE.match(response)) {
                                multiLineRC = new String(response.getBytes(), 0, 3) + " ";
                                try {
                                    this.ENDMULTILINE = new RE(multiLineRC);
                                }
                                catch (RESyntaxException ex) {
                                    throw new UndeclaredThrowableException(ex);
                                }
                                while ((response = rdr.readLine()) != null && !this.ENDMULTILINE.match(response)) {
                                }
                                if (response == null) break block67;
                            }
                            if ((rc = Integer.parseInt((t = new StringTokenizer(response)).nextToken())) == 221) {
                                serviceStatus = PollStatus.available((Double)responseTime);
                            }
                        }
                    }
                    if (!serviceStatus.isAvailable()) {
                        serviceStatus = PollStatus.unavailable();
                    }
                }
                catch (NumberFormatException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "NumberFormatException while polling address " + ipv4Addr.getHostAddress(), e);
                }
                catch (NoRouteToHostException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "No route to host exception for address " + ipv4Addr.getHostAddress(), e);
                    break;
                }
                catch (InterruptedIOException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "Did not receive expected response within timeout " + tracker);
                }
                catch (ConnectException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "Unable to connect to address " + ipv4Addr.getHostAddress(), e);
                }
                catch (IOException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address " + ipv4Addr.getHostAddress(), e);
                }
                finally {
                    block68: {
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (IOException e) {
                            e.fillInStackTrace();
                            if (!this.log().isDebugEnabled()) break block68;
                            this.log().debug("poll: Error closing socket.", (Throwable)e);
                        }
                    }
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    static {
        MULTILINE = null;
        try {
            LOCALHOST_NAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhE) {
            ThreadCategory.getInstance(SmtpMonitor.class).error("Failed to resolve localhost name, using localhost");
            LOCALHOST_NAME = "localhost";
        }
        try {
            MULTILINE = new RE("^[0-9]{3}-");
        }
        catch (RESyntaxException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }
}

